/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.pdfwriter;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMBoolean;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMString;
import com.plpdf.pdfwriter.OMWriter;
import com.plpdf.util.ImageParameters;
import com.plpdf.util.PDFOperator;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public class ContentStreamWriter {
    private OutputStream output;
    public static final byte[] SPACE = new byte[]{32};
    public static final byte[] EOL = new byte[]{10};

    public ContentStreamWriter(OutputStream out) {
        this.output = out;
    }

    public void writeTokens(List tokens, int start, int end) throws IOException {
        int i = start;
        while (i < end) {
            Object o = tokens.get(i);
            this.writeObject(o);
            this.output.write(32);
            ++i;
        }
        this.output.flush();
    }

    private void writeObject(Object o) throws IOException {
        if (o instanceof OMString) {
            ((OMString)o).writePDF(this.output);
        } else if (o instanceof OMFloat) {
            ((OMFloat)o).writePDF(this.output);
        } else if (o instanceof OMInteger) {
            ((OMInteger)o).writePDF(this.output);
        } else if (o instanceof OMBoolean) {
            ((OMBoolean)o).writePDF(this.output);
        } else if (o instanceof OMName) {
            ((OMName)o).writePDF(this.output);
        } else if (o instanceof OMArray) {
            OMArray array = (OMArray)o;
            this.output.write(OMWriter.ARRAY_OPEN);
            int i = 0;
            while (i < array.size()) {
                this.writeObject(array.get(i));
                this.output.write(SPACE);
                ++i;
            }
            this.output.write(OMWriter.ARRAY_CLOSE);
        } else if (o instanceof OMDictionary) {
            OMDictionary obj = (OMDictionary)o;
            this.output.write(OMWriter.DICT_OPEN);
            for (Map.Entry<OMName, OMBase> entry : obj.entrySet()) {
                if (entry.getValue() == null) continue;
                this.writeObject(entry.getKey());
                this.output.write(SPACE);
                this.writeObject(entry.getValue());
                this.output.write(SPACE);
            }
            this.output.write(OMWriter.DICT_CLOSE);
            this.output.write(SPACE);
        } else if (o instanceof PDFOperator) {
            PDFOperator op = (PDFOperator)o;
            if (op.getOperation().equals("BI")) {
                this.output.write("BI".getBytes("ISO-8859-1"));
                ImageParameters params = op.getImageParameters();
                OMDictionary dic = params.getDictionary();
                for (OMName key : dic.keySet()) {
                    OMBase value = dic.getDictionaryObject(key);
                    key.writePDF(this.output);
                    this.output.write(SPACE);
                    this.writeObject(value);
                    this.output.write(EOL);
                }
                this.output.write("ID".getBytes("ISO-8859-1"));
                this.output.write(EOL);
                this.output.write(op.getImageData());
            } else {
                this.output.write(op.getOperation().getBytes("ISO-8859-1"));
                this.output.write(EOL);
            }
        } else {
            throw new IOException("Error:Unknown type in content stream:" + o);
        }
    }

    public void writeTokens(List tokens) throws IOException {
        this.writeTokens(tokens, 0, tokens.size());
    }
}

