/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.pdfviewer.font;

import com.plpdf.encoding.Encoding;
import com.plpdf.encoding.MacOSRomanEncoding;
import com.plpdf.font.cmap.CMap;
import com.plpdf.font.ttf.CMAPEncodingEntry;
import com.plpdf.font.ttf.CMAPTable;
import com.plpdf.font.ttf.GlyphData;
import com.plpdf.font.ttf.GlyphDescription;
import com.plpdf.font.ttf.HeaderTable;
import com.plpdf.font.ttf.TrueTypeFont;
import com.plpdf.pdfviewer.font.Glyph2D;
import com.plpdf.smmodel.font.SMCIDFontType2Font;
import com.plpdf.smmodel.font.SMFont;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class TTFGlyph2D
implements Glyph2D {
    private static final int START_RANGE_F000 = 61440;
    private static final int START_RANGE_F100 = 61696;
    private static final int START_RANGE_F200 = 61952;
    private TrueTypeFont font;
    private SMCIDFontType2Font descendantFont;
    private String name;
    private float scale = 1.0f;
    private boolean hasScaling = false;
    private CMAPEncodingEntry cmapWinUnicode = null;
    private CMAPEncodingEntry cmapWinSymbol = null;
    private CMAPEncodingEntry cmapMacintoshSymbol = null;
    private boolean isSymbol = false;
    private Map<Integer, GeneralPath> glyphs = new HashMap<Integer, GeneralPath>();
    private Encoding fontEncoding = null;
    private CMap fontCMap = null;
    private boolean isCIDFont = false;
    private boolean hasIdentityCIDMapping = false;
    private boolean hasCID2GIDMapping = false;
    private boolean hasTwoByteMappings = false;

    public TTFGlyph2D(TrueTypeFont trueTypeFont, SMFont pdFont) {
        this(trueTypeFont, pdFont, null);
    }

    public TTFGlyph2D(TrueTypeFont trueTypeFont, SMFont pdFont, SMCIDFontType2Font descFont) {
        this.font = trueTypeFont;
        HeaderTable header = this.font.getHeader();
        if (header != null && header.getUnitsPerEm() != 1000) {
            this.scale = 1000.0f / (float)header.getUnitsPerEm();
            this.hasScaling = true;
        }
        this.extractCMaps();
        this.extractFontSpecifics(pdFont, descFont);
    }

    private void extractCMaps() {
        CMAPTable cmapTable = this.font.getCMAP();
        if (cmapTable != null) {
            CMAPEncodingEntry[] cmaps = cmapTable.getCmaps();
            int i = 0;
            while (i < cmaps.length) {
                if (3 == cmaps[i].getPlatformId()) {
                    if (1 == cmaps[i].getPlatformEncodingId()) {
                        this.cmapWinUnicode = cmaps[i];
                    } else if (cmaps[i].getPlatformEncodingId() == 0) {
                        this.cmapWinSymbol = cmaps[i];
                    }
                } else if (1 == cmaps[i].getPlatformId() && cmaps[i].getPlatformEncodingId() == 0) {
                    this.cmapMacintoshSymbol = cmaps[i];
                }
                ++i;
            }
        }
    }

    private void extractFontSpecifics(SMFont pdFont, SMCIDFontType2Font descFont) {
        this.isSymbol = pdFont.isSymbolicFont();
        this.name = pdFont.getBaseFont();
        this.fontEncoding = pdFont.getFontEncoding();
        if (descFont != null) {
            this.isCIDFont = true;
            this.descendantFont = descFont;
            this.hasIdentityCIDMapping = this.descendantFont.hasIdentityCIDToGIDMap();
            this.hasCID2GIDMapping = this.descendantFont.hasCIDToGIDMap();
            this.fontCMap = pdFont.getCMap();
            if (this.fontCMap != null) {
                this.hasTwoByteMappings = this.fontCMap.hasTwoByteMappings();
            }
        }
    }

    private Point[] describe(GlyphDescription gd) {
        int endPtIndex = 0;
        Point[] points = new Point[gd.getPointCount()];
        int i = 0;
        while (i < gd.getPointCount()) {
            boolean endPt;
            boolean bl = endPt = gd.getEndPtOfContours(endPtIndex) == i;
            if (endPt) {
                ++endPtIndex;
            }
            points[i] = new Point(gd.getXCoordinate(i), gd.getYCoordinate(i), (gd.getFlags(i) & 1) != 0, endPt);
            ++i;
        }
        return points;
    }

    public GeneralPath getPathForGlyphId(int glyphId) {
        GeneralPath glyphPath = null;
        if (this.glyphs.containsKey(glyphId)) {
            glyphPath = this.glyphs.get(glyphId);
        } else {
            GlyphData[] glyphData = this.font.getGlyph().getGlyphs();
            if (glyphId < glyphData.length && glyphData[glyphId] != null) {
                GlyphData glyph = glyphData[glyphId];
                GlyphDescription gd = glyph.getDescription();
                Point[] points = this.describe(gd);
                glyphPath = this.calculatePath(points);
                if (this.hasScaling) {
                    AffineTransform atScale = AffineTransform.getScaleInstance(this.scale, this.scale);
                    glyphPath.transform(atScale);
                }
                this.glyphs.put(glyphId, glyphPath);
            }
        }
        return glyphPath != null ? (GeneralPath)glyphPath.clone() : null;
    }

    private int getGlyphcode(int code) {
        if (this.isCIDFont) {
            return this.getGID(code);
        }
        int result = 0;
        if (this.fontEncoding != null && !this.isSymbol) {
            try {
                String charactername = this.fontEncoding.getName(code);
                if (charactername != null) {
                    if (this.cmapWinUnicode != null) {
                        String unicode = Encoding.getCharacterForName(charactername);
                        if (unicode != null) {
                            result = unicode.codePointAt(0);
                        }
                        result = this.cmapWinUnicode.getGlyphId(result);
                    } else if (this.cmapMacintoshSymbol != null) {
                        result = MacOSRomanEncoding.INSTANCE.getCode(charactername);
                        result = this.cmapMacintoshSymbol.getGlyphId(result);
                    }
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.fontEncoding == null || this.isSymbol) {
            if (this.cmapWinSymbol != null) {
                result = this.cmapWinSymbol.getGlyphId(code);
                if (code >= 0 && code <= 255) {
                    if (result == 0) {
                        result = this.cmapWinSymbol.getGlyphId(code + 61440);
                    }
                    if (result == 0) {
                        result = this.cmapWinSymbol.getGlyphId(code + 61696);
                    }
                    if (result == 0) {
                        result = this.cmapWinSymbol.getGlyphId(code + 61952);
                    }
                }
            } else if (this.cmapMacintoshSymbol != null) {
                result = this.cmapMacintoshSymbol.getGlyphId(code);
            }
        }
        return result;
    }

    private int getGID(int code) {
        String string;
        if (this.hasIdentityCIDMapping) {
            return code;
        }
        if (this.hasCID2GIDMapping) {
            return this.descendantFont.mapCIDToGID(code);
        }
        if (this.fontCMap != null && (string = this.fontCMap.lookup(code, this.hasTwoByteMappings ? 2 : 1)) != null) {
            return string.codePointAt(0);
        }
        return code;
    }

    public GeneralPath getPathForCharactercode(int code) {
        String string;
        int glyphId = this.getGlyphcode(code);
        if (glyphId > 0) {
            return this.getPathForGlyphId(glyphId);
        }
        glyphId = code;
        if (this.fontCMap != null && (string = this.fontCMap.lookup(code, this.hasTwoByteMappings ? 2 : 1)) != null) {
            glyphId = string.codePointAt(0);
        }
        return this.getPathForGlyphId(glyphId);
    }

    private GeneralPath calculatePath(Point[] points) {
        GeneralPath path = new GeneralPath();
        int numberOfPoints = points.length;
        int i = 0;
        boolean endOfContour = true;
        Point startingPoint = null;
        Point offCurveStartPoint = null;
        while (i < numberOfPoints) {
            Point point = points[i % numberOfPoints];
            Point nextPoint1 = points[(i + 1) % numberOfPoints];
            Point nextPoint2 = points[(i + 2) % numberOfPoints];
            if (endOfContour) {
                if (point.endOfContour) {
                    ++i;
                    continue;
                }
                this.moveTo(path, point);
                endOfContour = false;
                startingPoint = point;
                offCurveStartPoint = null;
                if (!point.onCurve && !nextPoint1.onCurve) {
                    offCurveStartPoint = point;
                    startingPoint = this.midValue(point, nextPoint1);
                    this.moveTo(path, startingPoint);
                }
            }
            if (point.onCurve) {
                offCurveStartPoint = null;
            }
            if (point.onCurve && nextPoint1.onCurve) {
                this.lineTo(path, nextPoint1);
                ++i;
                if (!point.endOfContour && !nextPoint1.endOfContour) continue;
                endOfContour = true;
                this.closePath(path);
                continue;
            }
            if (point.onCurve && !nextPoint1.onCurve && nextPoint2.onCurve) {
                if (nextPoint1.endOfContour) {
                    this.quadTo(path, nextPoint1, startingPoint);
                } else {
                    this.quadTo(path, nextPoint1, nextPoint2);
                }
                if (nextPoint1.endOfContour || nextPoint2.endOfContour) {
                    endOfContour = true;
                    this.closePath(path);
                }
                i += 2;
                continue;
            }
            if (offCurveStartPoint != null && !nextPoint1.onCurve && !nextPoint2.onCurve) {
                this.quadTo(path, nextPoint1, this.midValue(nextPoint1, nextPoint2));
                if (point.endOfContour || nextPoint1.endOfContour || nextPoint2.endOfContour) {
                    this.quadTo(path, nextPoint2, this.midValue(nextPoint2, offCurveStartPoint));
                    this.quadTo(path, offCurveStartPoint, startingPoint);
                    endOfContour = true;
                    i += 2;
                    continue;
                }
                ++i;
                continue;
            }
            if (point.onCurve && !nextPoint1.onCurve && !nextPoint2.onCurve) {
                this.quadTo(path, nextPoint1, this.midValue(nextPoint1, nextPoint2));
                if (point.endOfContour || nextPoint1.endOfContour || nextPoint2.endOfContour) {
                    this.quadTo(path, nextPoint2, startingPoint);
                    endOfContour = true;
                    this.closePath(path);
                }
                i += 2;
                continue;
            }
            if (!point.onCurve && !nextPoint1.onCurve) {
                this.quadTo(path, point, this.midValue(point, nextPoint1));
                if (point.endOfContour || nextPoint1.endOfContour) {
                    endOfContour = true;
                    this.quadTo(path, nextPoint1, startingPoint);
                }
                ++i;
                continue;
            }
            if (point.onCurve || !nextPoint1.onCurve) break;
            this.quadTo(path, point, nextPoint1);
            if (point.endOfContour || nextPoint1.endOfContour) {
                endOfContour = true;
                this.closePath(path);
            }
            ++i;
        }
        return path;
    }

    private void closePath(GeneralPath path) {
        path.closePath();
    }

    private void moveTo(GeneralPath path, Point point) {
        path.moveTo(point.x, point.y);
    }

    private void lineTo(GeneralPath path, Point point) {
        path.lineTo(point.x, point.y);
    }

    private void quadTo(GeneralPath path, Point ctrlPoint, Point point) {
        path.quadTo(ctrlPoint.x, ctrlPoint.y, point.x, point.y);
    }

    private int midValue(int a, int b) {
        return a + (b - a) / 2;
    }

    private Point midValue(Point point1, Point point2) {
        return new Point(this.midValue(point1.x, point2.x), this.midValue(point1.y, point2.y));
    }

    public int getNumberOfGlyphs() {
        return this.font != null ? this.font.getGlyph().getGlyphs().length : 0;
    }

    public void dispose() {
        this.cmapMacintoshSymbol = null;
        this.cmapWinSymbol = null;
        this.cmapWinUnicode = null;
        this.font = null;
        this.descendantFont = null;
        this.fontCMap = null;
        this.fontEncoding = null;
        if (this.glyphs != null) {
            this.glyphs.clear();
        }
    }

    private class Point {
        private int x = 0;
        private int y = 0;
        private boolean onCurve = true;
        private boolean endOfContour = false;

        public Point(int xValue, int yValue, boolean onCurveValue, boolean endOfContourValue) {
            this.x = xValue;
            this.y = yValue;
            this.onCurve = onCurveValue;
            this.endOfContour = endOfContourValue;
        }

        public Point(int xValue, int yValue) {
            this(xValue, yValue, false, false);
        }

        public String toString() {
            return String.format("Point(%d,%d,%s,%s)", this.x, this.y, this.onCurve ? "onCurve" : "", this.endOfContour ? "endOfContour" : "");
        }
    }
}

