/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.pdfviewer.font;

import com.plpdf.encoding.Encoding;
import com.plpdf.font.cff.CFFFont;
import com.plpdf.font.cff.CharStringRenderer;
import com.plpdf.pdfviewer.font.Glyph2D;
import java.awt.geom.GeneralPath;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class CFFGlyph2D
implements Glyph2D {
    private HashMap<Integer, GeneralPath> glyphs = new HashMap();
    private HashMap<Integer, Integer> codeToGlyph = new HashMap();
    private String fontname = null;

    public CFFGlyph2D(CFFFont cffFont, Encoding encoding) {
        this.fontname = cffFont.getName();
        Map<String, Integer> nameToCode = encoding != null ? encoding.getNameToCodeMap() : null;
        Collection<CFFFont.Mapping> mappings = cffFont.getMappings();
        LinkedHashMap<Integer, String> codeToNameMap = new LinkedHashMap<Integer, String>();
        for (CFFFont.Mapping mapping : mappings) {
            codeToNameMap.put(mapping.getCode(), mapping.getName());
        }
        CharStringRenderer renderer = cffFont.createRenderer();
        int glyphId = 0;
        for (CFFFont.Mapping mapping : mappings) {
            GeneralPath glyph = null;
            try {
                glyph = renderer.render(mapping.toType1Sequence());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (glyph == null) continue;
            this.glyphs.put(glyphId, glyph);
            int code = mapping.getSID();
            String name = mapping.getName();
            if (nameToCode != null && nameToCode.containsKey(name)) {
                code = nameToCode.get(name);
            }
            this.codeToGlyph.put(code, glyphId);
            ++glyphId;
        }
    }

    public GeneralPath getPathForGlyphId(int glyphId) {
        if (this.glyphs.containsKey(glyphId)) {
            return this.glyphs.get(glyphId);
        }
        return null;
    }

    public GeneralPath getPathForCharactercode(int code) {
        if (this.codeToGlyph.containsKey(code)) {
            return this.getPathForGlyphId(this.codeToGlyph.get(code));
        }
        return null;
    }

    public int getNumberOfGlyphs() {
        if (this.glyphs != null) {
            return this.glyphs.size();
        }
        return 0;
    }

    public void dispose() {
        if (this.glyphs != null) {
            this.glyphs.clear();
        }
        if (this.codeToGlyph != null) {
            this.codeToGlyph.clear();
        }
    }
}

