/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.pdfviewer;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.OMName;
import com.plpdf.pdfviewer.font.Glyph2D;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.SMResources;
import com.plpdf.smmodel.common.SMMatrix;
import com.plpdf.smmodel.common.SMRectangle;
import com.plpdf.smmodel.font.SMFont;
import com.plpdf.smmodel.graphics.SMGraphicsState;
import com.plpdf.smmodel.graphics.SMShading;
import com.plpdf.smmodel.graphics.shading.AxialShadingPaint;
import com.plpdf.smmodel.graphics.shading.RadialShadingPaint;
import com.plpdf.smmodel.graphics.shading.SMShadingResources;
import com.plpdf.smmodel.graphics.shading.SMShadingType2;
import com.plpdf.smmodel.graphics.shading.SMShadingType3;
import com.plpdf.smmodel.interactive.annotation.SMAnnotation;
import com.plpdf.smmodel.interactive.annotation.SMAppearanceDictionary;
import com.plpdf.smmodel.interactive.annotation.SMAppearanceStream;
import com.plpdf.util.Matrix;
import com.plpdf.util.PDFStreamEngine;
import com.plpdf.util.ResourceLoader;
import com.plpdf.util.TextPosition;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class PageDrawer
extends PDFStreamEngine {
    private Graphics2D graphics;
    private int clippingWindingRule = -1;
    protected Dimension pageSize;
    protected SMPage page;
    private GeneralPath linePath = new GeneralPath();
    private Map<SMFont, Glyph2D> fontGlyph2D = new HashMap<SMFont, Glyph2D>();
    private Map<SMFont, Font> awtFonts = new HashMap<SMFont, Font>();

    public PageDrawer() throws IOException, PlpdfException {
        super(ResourceLoader.loadProperties("com/plpdf/res/PageDrawer.properties", true));
    }

    public void drawPage(Graphics g, SMPage p, Dimension pageDimension) throws Exception {
        this.graphics = (Graphics2D)g;
        this.page = p;
        this.pageSize = pageDimension;
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        if (this.page.getContents() != null) {
            SMResources resources = this.page.findResources();
            this.processStream(this.page, resources, this.page.getContents().getStream());
        }
        List<SMAnnotation> annotations = this.page.getAnnotations();
        int i = 0;
        while (i < annotations.size()) {
            SMAnnotation annot = annotations.get(i);
            SMRectangle rect = annot.getRectangle();
            String appearanceName = annot.getAppearanceStream();
            SMAppearanceDictionary appearDictionary = annot.getAppearance();
            if (appearDictionary != null) {
                SMAppearanceStream appearance;
                Map<String, SMAppearanceStream> appearanceMap;
                if (appearanceName == null) {
                    appearanceName = "default";
                }
                if ((appearanceMap = appearDictionary.getNormalAppearance()) != null && (appearance = appearanceMap.get(appearanceName)) != null) {
                    Point2D.Float point = new Point2D.Float(rect.getLowerLeftX(), rect.getLowerLeftY());
                    Matrix matrix = appearance.getMatrix();
                    if (matrix != null) {
                        AffineTransform at = matrix.createAffineTransform();
                        at.transform(point, point);
                    }
                    g.translate((int)((Point2D)point).getX(), -((int)((Point2D)point).getY()));
                    this.processSubStream(this.page, appearance.getResources(), appearance.getStream());
                    g.translate(-((int)((Point2D)point).getX()), (int)((Point2D)point).getY());
                }
            }
            ++i;
        }
    }

    public void dispose() {
        if (this.fontGlyph2D != null) {
            Iterator<Glyph2D> iter = this.fontGlyph2D.values().iterator();
            while (iter.hasNext()) {
                iter.next().dispose();
            }
            this.fontGlyph2D.clear();
            this.fontGlyph2D = null;
        }
        if (this.awtFonts != null) {
            this.awtFonts.clear();
        }
        this.graphics = null;
        this.linePath = null;
        this.page = null;
        this.pageSize = null;
    }

    protected void processTextPosition(TextPosition text) throws Exception {
        try {
            Paint paint;
            Composite composite;
            SMGraphicsState graphicsState = this.getGraphicsState();
            switch (graphicsState.getTextState().getRenderingMode()) {
                case 0: {
                    composite = graphicsState.getNonStrokeJavaComposite();
                    paint = graphicsState.getNonStrokingColor().getJavaColor();
                    if (paint != null) break;
                    paint = graphicsState.getNonStrokingColor().getPaint(this.pageSize.height);
                    break;
                }
                case 1: {
                    composite = graphicsState.getStrokeJavaComposite();
                    paint = graphicsState.getStrokingColor().getJavaColor();
                    if (paint != null) break;
                    paint = graphicsState.getStrokingColor().getPaint(this.pageSize.height);
                    break;
                }
                case 3: {
                    Color nsc = graphicsState.getStrokingColor().getJavaColor();
                    float[] components = new float[]{Color.black.getRed(), Color.black.getGreen(), Color.black.getBlue()};
                    paint = new Color(nsc.getColorSpace(), components, 0.0f);
                    composite = graphicsState.getStrokeJavaComposite();
                    break;
                }
                default: {
                    composite = graphicsState.getNonStrokeJavaComposite();
                    paint = graphicsState.getNonStrokingColor().getJavaColor();
                }
            }
            this.graphics.setComposite(composite);
            this.graphics.setPaint(paint);
            SMFont font = text.getFont();
            Matrix textPos = text.getTextPos().copy();
            float x = textPos.getXPosition();
            float y = (float)this.pageSize.height - textPos.getYPosition();
            textPos.setValue(2, 0, 0.0f);
            textPos.setValue(2, 1, 0.0f);
            textPos.setValue(0, 1, -1.0f * textPos.getValue(0, 1));
            textPos.setValue(1, 0, -1.0f * textPos.getValue(1, 0));
            AffineTransform at = textPos.createAffineTransform();
            SMMatrix fontMatrix = font.getFontMatrix();
            at.scale(fontMatrix.getValue(0, 0) * 1000.0f, fontMatrix.getValue(1, 1) * 1000.0f);
            this.graphics.setClip(graphicsState.getCurrentClippingPath());
            font.drawString(text.getCharacter(), text.getCodePoints(), this.graphics, 1.0f, at, x, y);
        }
        catch (IOException io) {
            io.printStackTrace();
        }
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public SMPage getPage() {
        return this.page;
    }

    public Dimension getPageSize() {
        return this.pageSize;
    }

    public double fixY(double y) {
        return this.pageSize.getHeight() - y;
    }

    public GeneralPath getLinePath() {
        return this.linePath;
    }

    public void setLinePath(GeneralPath newLinePath) {
        if (this.linePath == null || this.linePath.getCurrentPoint() == null) {
            this.linePath = newLinePath;
        } else {
            this.linePath.append(newLinePath, false);
        }
    }

    public void fillPath(int windingRule) throws IOException {
        this.graphics.setComposite(this.getGraphicsState().getNonStrokeJavaComposite());
        Paint nonStrokingPaint = this.getGraphicsState().getNonStrokingColor().getJavaColor();
        if (nonStrokingPaint == null) {
            nonStrokingPaint = this.getGraphicsState().getNonStrokingColor().getPaint(this.pageSize.height);
        }
        if (nonStrokingPaint == null) {
            nonStrokingPaint = Color.WHITE;
        }
        this.graphics.setPaint(nonStrokingPaint);
        this.getLinePath().setWindingRule(windingRule);
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.graphics.setClip(this.getGraphicsState().getCurrentClippingPath());
        this.graphics.fill(this.getLinePath());
        this.getLinePath().reset();
    }

    public void setStroke(BasicStroke newStroke) {
        this.getGraphics().setStroke(newStroke);
    }

    public BasicStroke getStroke() {
        return (BasicStroke)this.getGraphics().getStroke();
    }

    public void strokePath() throws IOException {
        this.graphics.setComposite(this.getGraphicsState().getStrokeJavaComposite());
        Paint strokingPaint = this.getGraphicsState().getStrokingColor().getJavaColor();
        if (strokingPaint == null) {
            strokingPaint = this.getGraphicsState().getStrokingColor().getPaint(this.pageSize.height);
        }
        if (strokingPaint == null) {
            strokingPaint = Color.WHITE;
        }
        this.graphics.setPaint(strokingPaint);
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.graphics.setClip(this.getGraphicsState().getCurrentClippingPath());
        GeneralPath path = this.getLinePath();
        this.graphics.draw(path);
        path.reset();
    }

    @Deprecated
    public void colorChanged(boolean bStroking) throws IOException {
    }

    public Point2D.Double transformedPoint(double x, double y) {
        double[] position = new double[]{x, y};
        this.getGraphicsState().getCurrentTransformationMatrix().createAffineTransform().transform(position, 0, position, 0, 1);
        position[1] = this.fixY(position[1]);
        return new Point2D.Double(position[0], position[1]);
    }

    public void setClippingPath(int windingRule) {
        this.setClippingWindingRule(windingRule);
    }

    public void setClippingWindingRule(int windingRule) {
        this.clippingWindingRule = windingRule;
    }

    public void endPath() {
        if (this.clippingWindingRule > -1) {
            SMGraphicsState graphicsState = this.getGraphicsState();
            GeneralPath clippingPath = (GeneralPath)this.getLinePath().clone();
            clippingPath.setWindingRule(this.clippingWindingRule);
            if (graphicsState.getCurrentClippingPath() != null) {
                Area currentArea = new Area(this.getGraphicsState().getCurrentClippingPath());
                Area newArea = new Area(clippingPath);
                currentArea.intersect(newArea);
                graphicsState.setCurrentClippingPath(currentArea);
            } else {
                graphicsState.setCurrentClippingPath(clippingPath);
            }
            this.clippingWindingRule = -1;
        }
        this.getLinePath().reset();
    }

    public void drawImage(Image awtImage, AffineTransform at) {
        this.graphics.setComposite(this.getGraphicsState().getStrokeJavaComposite());
        this.graphics.setClip(this.getGraphicsState().getCurrentClippingPath());
        this.graphics.drawImage(awtImage, at, null);
    }

    public void SHFill(OMName ShadingName) throws IOException {
        this.shFill(ShadingName);
    }

    public void shFill(OMName shadingName) throws IOException {
        SMShadingResources shading = this.getResources().getShadings().get(shadingName.getName());
        int shadingType = shading.getShadingType();
        Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
        Paint paint = null;
        switch (shadingType) {
            case 1: {
                break;
            }
            case 2: {
                paint = new AxialShadingPaint((SMShadingType2)shading, ctm, this.pageSize.height);
                break;
            }
            case 3: {
                paint = new RadialShadingPaint((SMShadingType3)shading, ctm, this.pageSize.height);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
            default: {
                throw new IOException("Invalid ShadingType " + shadingType + " for Shading " + shadingName);
            }
        }
        this.graphics.setComposite(this.getGraphicsState().getNonStrokeJavaComposite());
        this.graphics.setPaint(paint);
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.graphics.fill(this.getGraphicsState().getCurrentClippingPath());
    }

    protected void SHFill_Function(SMShading Shading) throws IOException {
        throw new IOException("Not Implemented");
    }

    protected void SHFill_Axial(SMShading Shading) throws IOException {
        throw new IOException("Not Implemented");
    }

    protected void SHFill_Radial(SMShading Shading) throws IOException {
        throw new IOException("Not Implemented");
    }

    protected void SHFill_FreeGourad(SMShading Shading) throws IOException {
        throw new IOException("Not Implemented");
    }

    protected void SHFill_LatticeGourad(SMShading Shading) throws IOException {
        throw new IOException("Not Implemented");
    }

    protected void SHFill_CoonsPatch(SMShading Shading) throws IOException {
        throw new IOException("Not Implemented");
    }

    protected void SHFill_TensorPatch(SMShading Shading) throws IOException {
        throw new IOException("Not Implemented");
    }
}

