/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.pdfviewer;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMDocument;
import com.plpdf.om.OMName;
import com.plpdf.om.OMObject;
import com.plpdf.pdfviewer.ArrayEntry;
import com.plpdf.pdfviewer.MapEntry;
import com.plpdf.smmodel.SMDocument;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class PDFTreeModel
implements TreeModel {
    private SMDocument document;

    public PDFTreeModel() {
    }

    public PDFTreeModel(SMDocument doc) {
        this.setDocument(doc);
    }

    public void setDocument(SMDocument doc) {
        this.document = doc;
    }

    public void addTreeModelListener(TreeModelListener l) {
    }

    public Object getChild(Object parent, int index) {
        Object retval = null;
        if (parent instanceof OMArray) {
            ArrayEntry entry = new ArrayEntry();
            entry.setIndex(index);
            entry.setValue(((OMArray)parent).getObject(index));
            retval = entry;
        } else if (parent instanceof OMDictionary) {
            OMDictionary dict = (OMDictionary)parent;
            ArrayList<OMName> keys = new ArrayList<OMName>(dict.keySet());
            Collections.sort(keys);
            Object key = keys.get(index);
            OMBase value = dict.getDictionaryObject((OMName)key);
            MapEntry entry = new MapEntry();
            entry.setKey(key);
            entry.setValue(value);
            retval = entry;
        } else if (parent instanceof MapEntry) {
            retval = this.getChild(((MapEntry)parent).getValue(), index);
        } else if (parent instanceof ArrayEntry) {
            retval = this.getChild(((ArrayEntry)parent).getValue(), index);
        } else if (parent instanceof OMDocument) {
            retval = ((OMDocument)parent).getObjects().get(index);
        } else if (parent instanceof OMObject) {
            retval = ((OMObject)parent).getObject();
        } else {
            throw new RuntimeException("Unknown OM type " + parent.getClass().getName());
        }
        return retval;
    }

    public int getChildCount(Object parent) {
        int retval = 0;
        if (parent instanceof OMArray) {
            retval = ((OMArray)parent).size();
        } else if (parent instanceof OMDictionary) {
            retval = ((OMDictionary)parent).size();
        } else if (parent instanceof MapEntry) {
            retval = this.getChildCount(((MapEntry)parent).getValue());
        } else if (parent instanceof ArrayEntry) {
            retval = this.getChildCount(((ArrayEntry)parent).getValue());
        } else if (parent instanceof OMDocument) {
            retval = ((OMDocument)parent).getObjects().size();
        } else if (parent instanceof OMObject) {
            retval = 1;
        }
        return retval;
    }

    public int getIndexOfChild(Object parent, Object child) {
        int retval = -1;
        if (parent != null && child != null) {
            if (parent instanceof OMArray) {
                OMArray array = (OMArray)parent;
                if (child instanceof ArrayEntry) {
                    ArrayEntry arrayEntry = (ArrayEntry)child;
                    retval = arrayEntry.getIndex();
                } else {
                    retval = array.indexOf((OMBase)child);
                }
            } else if (parent instanceof OMDictionary) {
                MapEntry entry = (MapEntry)child;
                OMDictionary dict = (OMDictionary)parent;
                ArrayList<OMName> keys = new ArrayList<OMName>(dict.keySet());
                Collections.sort(keys);
                int i = 0;
                while (retval == -1 && i < keys.size()) {
                    if (((OMName)keys.get(i)).equals(entry.getKey())) {
                        retval = i;
                    }
                    ++i;
                }
            } else if (parent instanceof MapEntry) {
                retval = this.getIndexOfChild(((MapEntry)parent).getValue(), child);
            } else if (parent instanceof ArrayEntry) {
                retval = this.getIndexOfChild(((ArrayEntry)parent).getValue(), child);
            } else if (parent instanceof OMDocument) {
                retval = ((OMDocument)parent).getObjects().indexOf(child);
            } else if (parent instanceof OMObject) {
                retval = 0;
            } else {
                throw new RuntimeException("Unknown OM type " + parent.getClass().getName());
            }
        }
        return retval;
    }

    public Object getRoot() {
        return this.document.getDocument().getTrailer();
    }

    public boolean isLeaf(Object node) {
        boolean isLeaf = !(node instanceof OMDictionary || node instanceof OMArray || node instanceof OMDocument || node instanceof OMObject || node instanceof MapEntry && !this.isLeaf(((MapEntry)node).getValue()) || node instanceof ArrayEntry && !this.isLeaf(((ArrayEntry)node).getValue()));
        return isLeaf;
    }

    public void removeTreeModelListener(TreeModelListener l) {
    }

    public void valueForPathChanged(TreePath path, Object newValue) {
    }
}

