/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.pdfviewer;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNull;
import com.plpdf.om.OMStream;
import com.plpdf.om.OMString;
import com.plpdf.pdfviewer.ArrayEntry;
import com.plpdf.pdfviewer.MapEntry;
import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;

public class PDFTreeCellRenderer
extends DefaultTreeCellRenderer {
    public Component getTreeCellRendererComponent(JTree tree, Object nodeValue, boolean isSelected, boolean expanded, boolean leaf, int row, boolean componentHasFocus) {
        nodeValue = this.convertToTreeObject(nodeValue);
        return super.getTreeCellRendererComponent(tree, nodeValue, isSelected, expanded, leaf, row, componentHasFocus);
    }

    private Object convertToTreeObject(Object nodeValue) {
        if (nodeValue instanceof MapEntry) {
            MapEntry entry = (MapEntry)nodeValue;
            OMName key = (OMName)entry.getKey();
            OMBase value = (OMBase)entry.getValue();
            nodeValue = String.valueOf(key.getName()) + ":" + this.convertToTreeObject(value);
        } else if (nodeValue instanceof OMFloat) {
            nodeValue = "" + ((OMFloat)nodeValue).floatValue();
        } else if (nodeValue instanceof OMInteger) {
            nodeValue = "" + ((OMInteger)nodeValue).intValue();
        } else if (nodeValue instanceof OMString) {
            nodeValue = ((OMString)nodeValue).getString();
        } else if (nodeValue instanceof OMName) {
            nodeValue = ((OMName)nodeValue).getName();
        } else if (nodeValue instanceof ArrayEntry) {
            ArrayEntry entry = (ArrayEntry)nodeValue;
            nodeValue = "[" + entry.getIndex() + "]" + this.convertToTreeObject(entry.getValue());
        } else if (nodeValue instanceof OMNull) {
            nodeValue = "null";
        } else if (nodeValue instanceof OMDictionary) {
            OMDictionary dict = (OMDictionary)nodeValue;
            nodeValue = nodeValue instanceof OMStream ? "Stream" : "Dictionary";
            OMName type = (OMName)dict.getDictionaryObject(OMName.TYPE);
            if (type != null) {
                nodeValue = nodeValue + "(" + type.getName();
                OMName subType = (OMName)dict.getDictionaryObject(OMName.SUBTYPE);
                if (subType != null) {
                    nodeValue = nodeValue + ":" + subType.getName();
                }
                nodeValue = String.valueOf(nodeValue) + ")";
            }
        } else if (nodeValue instanceof OMArray) {
            nodeValue = "Array";
        } else if (nodeValue instanceof OMString) {
            nodeValue = ((OMString)nodeValue).getString();
        }
        return nodeValue;
    }
}

