/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.pdfviewer;

import com.plpdf.exceptions.PlpdfException;
import com.plpdf.pdfviewer.PageDrawer;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.common.SMRectangle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.IOException;
import javax.swing.JPanel;

public class PDFPagePanel
extends JPanel {
    private static final long serialVersionUID = -4629033339560890669L;
    private SMPage page;
    private PageDrawer drawer = new PageDrawer();
    private Dimension pageDimension = null;
    private Dimension drawDimension = null;

    public void setPage(SMPage pdfPage) {
        this.page = pdfPage;
        SMRectangle cropBox = this.page.findCropBox();
        this.drawDimension = cropBox.createDimension();
        int rotation = this.page.findRotation();
        this.pageDimension = rotation == 90 || rotation == 270 ? new Dimension(this.drawDimension.height, this.drawDimension.width) : this.drawDimension;
        this.setSize(this.pageDimension);
        this.setBackground(Color.white);
    }

    public void paint(Graphics g) {
        try {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            int rotation = this.page.findRotation();
            if (rotation == 90 || rotation == 270) {
                Graphics2D g2D = (Graphics2D)g;
                g2D.translate(this.pageDimension.getWidth(), 0.0);
                g2D.rotate(Math.toRadians(rotation));
            }
            this.drawer.drawPage(g, this.page, this.drawDimension);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

