/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.pdfparser;

import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMObject;
import com.plpdf.persistence.util.OMObjectKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XrefTrailerResolver {
    private final Map<Long, XrefTrailerObj> bytePosToXrefMap = new HashMap<Long, XrefTrailerObj>();
    private XrefTrailerObj curXrefTrailerObj = new XrefTrailerObj();
    private XrefTrailerObj resolvedXrefTrailer = null;

    public final OMDictionary getFirstTrailer() {
        if (this.bytePosToXrefMap.isEmpty()) {
            return null;
        }
        Set<Long> offsets = this.bytePosToXrefMap.keySet();
        TreeSet<Long> sortedOffset = new TreeSet<Long>(offsets);
        return this.bytePosToXrefMap.get(sortedOffset.first()).trailer;
    }

    public final OMDictionary getLastTrailer() {
        if (this.bytePosToXrefMap.isEmpty()) {
            return null;
        }
        Set<Long> offsets = this.bytePosToXrefMap.keySet();
        TreeSet<Long> sortedOffset = new TreeSet<Long>(offsets);
        return this.bytePosToXrefMap.get(sortedOffset.last()).trailer;
    }

    public void nextXrefObj(long startBytePos) {
        this.curXrefTrailerObj = new XrefTrailerObj();
        this.bytePosToXrefMap.put(startBytePos, this.curXrefTrailerObj);
    }

    public void setXRef(OMObjectKey objKey, long offset) {
        if (this.curXrefTrailerObj == null) {
            return;
        }
        this.curXrefTrailerObj.xrefTable.put(objKey, offset);
    }

    public void setTrailer(OMDictionary trailer) {
        if (this.curXrefTrailerObj == null) {
            return;
        }
        this.curXrefTrailerObj.trailer = trailer;
    }

    public OMDictionary getCurrentTrailer() {
        return this.curXrefTrailerObj.trailer;
    }

    public void setStartxref(long startxrefBytePosValue) {
        if (this.resolvedXrefTrailer != null) {
            return;
        }
        this.resolvedXrefTrailer = new XrefTrailerObj();
        this.resolvedXrefTrailer.trailer = new OMDictionary();
        XrefTrailerObj curObj = this.bytePosToXrefMap.get(startxrefBytePosValue);
        ArrayList<Long> xrefSeqBytePos = new ArrayList<Long>();
        if (curObj == null) {
            xrefSeqBytePos.addAll(this.bytePosToXrefMap.keySet());
            Collections.sort(xrefSeqBytePos);
        } else {
            xrefSeqBytePos.add(startxrefBytePosValue);
            while (curObj.trailer != null) {
                long prevBytePos = curObj.trailer.getLong(OMName.PREV, -1L);
                if (prevBytePos == -1L || (curObj = this.bytePosToXrefMap.get(prevBytePos)) == null) break;
                xrefSeqBytePos.add(prevBytePos);
                if (xrefSeqBytePos.size() >= this.bytePosToXrefMap.size()) break;
            }
            Collections.reverse(xrefSeqBytePos);
        }
        for (Long bPos : xrefSeqBytePos) {
            curObj = this.bytePosToXrefMap.get(bPos);
            if (curObj.trailer != null) {
                this.resolvedXrefTrailer.trailer.addAll(curObj.trailer);
            }
            this.resolvedXrefTrailer.xrefTable.putAll(curObj.xrefTable);
        }
        OMObject root = (OMObject)this.resolvedXrefTrailer.trailer.getItem(OMName.ROOT);
        if (root == null) {
            this.resolvedXrefTrailer.trailer = this.curXrefTrailerObj.trailer;
        }
    }

    public OMDictionary getTrailer() {
        return this.resolvedXrefTrailer == null ? null : this.resolvedXrefTrailer.trailer;
    }

    public Map<OMObjectKey, Long> getXrefTable() {
        return this.resolvedXrefTrailer == null ? null : this.resolvedXrefTrailer.xrefTable;
    }

    public Set<Long> getContainedObjectNumbers(int objstmObjNr) {
        if (this.resolvedXrefTrailer == null) {
            return null;
        }
        HashSet<Long> refObjNrs = new HashSet<Long>();
        int cmpVal = -objstmObjNr;
        for (Map.Entry xrefEntry : this.resolvedXrefTrailer.xrefTable.entrySet()) {
            if ((Long)xrefEntry.getValue() != (long)cmpVal) continue;
            refObjNrs.add(((OMObjectKey)xrefEntry.getKey()).getNumber());
        }
        return refObjNrs;
    }

    private class XrefTrailerObj {
        protected OMDictionary trailer = null;
        private final Map<OMObjectKey, Long> xrefTable = new HashMap<OMObjectKey, Long>();

        private XrefTrailerObj() {
        }
    }
}

