/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.pdfparser;

import com.plpdf.exceptions.CryptographyException;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMDocument;
import com.plpdf.om.OMObject;
import com.plpdf.pdfparser.BaseParser;
import com.plpdf.pdfwriter.OMWriter;
import com.plpdf.persistence.util.OMObjectKey;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;

public class VisualSignatureParser
extends BaseParser {
    public VisualSignatureParser(InputStream input) throws IOException {
        super(input);
    }

    public void parse() throws IOException, CryptographyException {
        block5: {
            this.document = new OMDocument();
            this.skipToNextObj();
            boolean wasLastParsedObjectEOF = false;
            try {
                while (!wasLastParsedObjectEOF) {
                    if (this.pdfSource.isEOF()) break;
                    try {
                        wasLastParsedObjectEOF = this.parseObject();
                    }
                    catch (IOException e) {
                        this.skipToNextObj();
                    }
                    this.skipSpaces();
                }
            }
            catch (IOException e) {
                if (wasLastParsedObjectEOF) break block5;
                throw e;
            }
        }
    }

    private void skipToNextObj() throws IOException {
        byte[] b = new byte[16];
        Pattern p = Pattern.compile("\\d+\\s+\\d+\\s+obj.*", 32);
        while (!this.pdfSource.isEOF()) {
            int l = this.pdfSource.read(b);
            if (l < 1) break;
            String s = new String(b, "US-ASCII");
            if (s.startsWith("trailer") || s.startsWith("xref") || s.startsWith("startxref") || s.startsWith("stream") || p.matcher(s).matches()) {
                this.pdfSource.unread(b);
                break;
            }
            this.pdfSource.unread(b, 1, l - 1);
        }
    }

    private boolean parseObject() throws IOException, CryptographyException {
        boolean isEndOfFile = false;
        this.skipSpaces();
        char peekedChar = (char)this.pdfSource.peek();
        while (peekedChar == 'e') {
            this.readString();
            this.skipSpaces();
            peekedChar = (char)this.pdfSource.peek();
        }
        if (!this.pdfSource.isEOF()) {
            if (peekedChar == 'x') {
                return true;
            }
            if (peekedChar == 't' || peekedChar == 's') {
                if (peekedChar == 't') {
                    return true;
                }
                if (peekedChar == 's') {
                    this.skipToNextObj();
                    String eof = this.readExpectedString("%%EOF");
                    if (eof.indexOf("%%EOF") == -1 && !this.pdfSource.isEOF()) {
                        throw new IOException("expected='%%EOF' actual='" + eof + "' next=" + this.readString() + " next=" + this.readString());
                    }
                    isEndOfFile = true;
                }
            } else {
                block24: {
                    long number = -1L;
                    int genNum = -1;
                    String objectKey = null;
                    boolean missingObjectNumber = false;
                    try {
                        char peeked = (char)this.pdfSource.peek();
                        if (peeked == '<') {
                            missingObjectNumber = true;
                        } else {
                            number = this.readObjectNumber();
                        }
                    }
                    catch (IOException e) {
                        number = this.readObjectNumber();
                    }
                    if (!missingObjectNumber) {
                        this.skipSpaces();
                        genNum = this.readGenerationNumber();
                        objectKey = this.readString(3);
                        if (!objectKey.equals("obj")) {
                            throw new IOException("expected='obj' actual='" + objectKey + "' " + this.pdfSource);
                        }
                    } else {
                        number = -1L;
                        genNum = -1;
                    }
                    this.skipSpaces();
                    OMBase pb = this.parseDirObject();
                    String endObjectKey = this.readString();
                    if (endObjectKey.equals("stream")) {
                        this.pdfSource.unread(endObjectKey.getBytes());
                        this.pdfSource.unread(32);
                        if (!(pb instanceof OMDictionary)) {
                            throw new IOException("stream not preceded by dictionary");
                        }
                        pb = this.parseOMStream((OMDictionary)pb, this.getDocument().getScratchFile());
                        endObjectKey = this.readString();
                    }
                    OMObjectKey key = new OMObjectKey(number, genNum);
                    OMObject pdfObject = this.document.getObjectFromPool(key);
                    pb.setNeedToBeUpdate(true);
                    pdfObject.setObject(pb);
                    if (!endObjectKey.equals("endobj")) {
                        if (endObjectKey.startsWith("endobj")) {
                            this.pdfSource.unread(endObjectKey.substring(6).getBytes());
                        } else if (!this.pdfSource.isEOF()) {
                            try {
                                Float.parseFloat(endObjectKey);
                                this.pdfSource.unread(OMWriter.SPACE);
                                this.pdfSource.unread(endObjectKey.getBytes());
                            }
                            catch (NumberFormatException e) {
                                String secondEndObjectKey = this.readString();
                                if (secondEndObjectKey.equals("endobj")) break block24;
                                if (this.isClosing()) {
                                    this.pdfSource.read();
                                }
                                this.skipSpaces();
                                String thirdPossibleEndObj = this.readString();
                                if (thirdPossibleEndObj.equals("endobj")) break block24;
                                throw new IOException("expected='endobj' firstReadAttempt='" + endObjectKey + "' " + "secondReadAttempt='" + secondEndObjectKey + "' " + this.pdfSource);
                            }
                        }
                    }
                }
                this.skipSpaces();
            }
        }
        return isEndOfFile;
    }

    public OMDocument getDocument() throws IOException {
        if (this.document == null) {
            throw new IOException("You must call parse() before calling getDocument()");
        }
        return this.document;
    }
}

