/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.pdfparser;

import com.plpdf.om.OMArray;
import com.plpdf.om.OMDocument;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import com.plpdf.pdfparser.BaseParser;
import com.plpdf.pdfparser.XrefTrailerResolver;
import com.plpdf.persistence.util.OMObjectKey;
import java.io.IOException;
import java.util.ArrayList;

public class PDFXrefStreamParser
extends BaseParser {
    private OMStream stream;
    private XrefTrailerResolver xrefTrailerResolver;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public PDFXrefStreamParser(OMStream strm, OMDocument doc, boolean forceParsing, XrefTrailerResolver resolver) throws IOException {
        super(strm.getUnfilteredStream(), forceParsing);
        this.setDocument(doc);
        this.stream = strm;
        this.xrefTrailerResolver = resolver;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    /*
     * Unable to fully structure code
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void parse() throws IOException {
        try {
            xrefFormat = (OMArray)this.stream.getDictionaryObject(OMName.W);
            indexArray = (OMArray)this.stream.getDictionaryObject(OMName.INDEX);
            if (indexArray == null) {
                indexArray = new OMArray();
                indexArray.add(OMInteger.ZERO);
                indexArray.add(this.stream.getDictionaryObject(OMName.SIZE));
            }
            objNums = new ArrayList<Integer>();
            indexIter = indexArray.iterator();
            while (indexIter.hasNext()) {
                objID = ((OMInteger)indexIter.next()).intValue();
                size = ((OMInteger)indexIter.next()).intValue();
                i = 0;
                while (i < size) {
                    objNums.add(new Integer(objID + i));
                    ++i;
                }
            }
            objIter = objNums.iterator();
            w0 = xrefFormat.getInt(0);
            w1 = xrefFormat.getInt(1);
            w2 = xrefFormat.getInt(2);
            lineSize = w0 + w1 + w2;
            if (true) ** GOTO lbl66
            do {
                currLine = new byte[lineSize];
                this.pdfSource.read(currLine);
                type = 0;
                i = 0;
                while (i < w0) {
                    type += (currLine[i] & 255) << (w0 - i - 1) * 8;
                    ++i;
                }
                objID = (Integer)objIter.next();
                switch (type) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        offset = 0;
                        i = 0;
                        while (i < w1) {
                            offset += (currLine[i + w0] & 255) << (w1 - i - 1) * 8;
                            ++i;
                        }
                        genNum = 0;
                        i = 0;
                        while (i < w2) {
                            genNum += (currLine[i + w0 + w1] & 255) << (w2 - i - 1) * 8;
                            ++i;
                        }
                        objKey = new OMObjectKey(objID.intValue(), genNum);
                        this.xrefTrailerResolver.setXRef(objKey, offset);
                        break;
                    }
                    case 2: {
                        objstmObjNr = 0;
                        i = 0;
                        while (i < w1) {
                            objstmObjNr += (currLine[i + w0] & 255) << (w1 - i - 1) * 8;
                            ++i;
                        }
                        objKey = new OMObjectKey(objID.intValue(), 0L);
                        this.xrefTrailerResolver.setXRef(objKey, -objstmObjNr);
                        break;
                    }
                }
lbl66:
                // 5 sources

                if (this.pdfSource.available() <= 0) return;
            } while (objIter.hasNext());
            return;
        }
        finally {
            this.pdfSource.close();
        }
    }
}

