/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.pdfparser;

import com.plpdf.io.RandomAccessBuffer;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMObject;
import com.plpdf.om.OMStream;
import com.plpdf.pdfparser.PDFXRef;
import com.plpdf.pdfwriter.OMWriterXRefEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFXRefStream
implements PDFXRef {
    private static final int ENTRY_OBJSTREAM = 2;
    private static final int ENTRY_NORMAL = 1;
    private static final int ENTRY_FREE = 0;
    private Map<Integer, Object> streamData;
    private Set<Integer> objectNumbers;
    private OMStream stream = new OMStream(new OMDictionary(), new RandomAccessBuffer());
    private long size = -1L;

    public PDFXRefStream() {
        this.streamData = new TreeMap<Integer, Object>();
        this.objectNumbers = new TreeSet<Integer>();
    }

    public OMStream getStream() throws IOException {
        this.stream.setItem(OMName.TYPE, (OMBase)OMName.XREF);
        if (this.size == -1L) {
            throw new IllegalArgumentException("size is not set in xrefstream");
        }
        this.stream.setLong(OMName.SIZE, this.getSizeEntry());
        this.stream.setFilters(OMName.FLATE_DECODE);
        List<Integer> indexEntry = this.getIndexEntry();
        OMArray indexAsArray = new OMArray();
        for (Integer i : indexEntry) {
            indexAsArray.add(OMInteger.get(i.intValue()));
        }
        this.stream.setItem(OMName.INDEX, (OMBase)indexAsArray);
        int[] wEntry = this.getWEntry();
        OMArray wAsArray = new OMArray();
        int i = 0;
        while (i < wEntry.length) {
            int j = wEntry[i];
            wAsArray.add(OMInteger.get(j));
            ++i;
        }
        this.stream.setItem(OMName.W, (OMBase)wAsArray);
        OutputStream unfilteredStream = this.stream.createUnfilteredStream();
        this.writeStreamData(unfilteredStream, wEntry);
        Set<OMName> keySet = this.stream.keySet();
        for (OMName cosName : keySet) {
            OMBase dictionaryObject = this.stream.getDictionaryObject(cosName);
            dictionaryObject.setDirect(true);
        }
        return this.stream;
    }

    public void addTrailerInfo(OMDictionary trailerDict) {
        Set<Map.Entry<OMName, OMBase>> entrySet = trailerDict.entrySet();
        for (Map.Entry<OMName, OMBase> entry : entrySet) {
            OMName key = entry.getKey();
            if (!OMName.INFO.equals(key) && !OMName.ROOT.equals(key) && !OMName.ENCRYPT.equals(key) && !OMName.ID.equals(key) && !OMName.PREV.equals(key)) continue;
            this.stream.setItem(key, entry.getValue());
        }
    }

    public void addEntry(OMWriterXRefEntry entry) {
        this.objectNumbers.add((int)entry.getKey().getNumber());
        if (entry.isFree()) {
            FreeReference value = new FreeReference();
            value.nextGenNumber = entry.getKey().getGeneration();
            value.nextFree = entry.getKey().getNumber();
            this.streamData.put((int)value.nextFree, value);
        } else {
            NormalReference value = new NormalReference();
            value.genNumber = entry.getKey().getGeneration();
            value.offset = entry.getOffset();
            this.streamData.put((int)entry.getKey().getNumber(), value);
        }
    }

    /*
     * Unable to fully structure code
     */
    private int[] getWEntry() {
        wMax = new long[3];
        for (Object entry : this.streamData.values()) {
            if (entry instanceof FreeReference) {
                free = (FreeReference)entry;
                wMax[0] = Math.max(wMax[0], 0L);
                wMax[1] = Math.max(wMax[1], free.nextFree);
                wMax[2] = Math.max(wMax[2], free.nextGenNumber);
                continue;
            }
            if (entry instanceof NormalReference) {
                ref = (NormalReference)entry;
                wMax[0] = Math.max(wMax[0], 1L);
                wMax[1] = Math.max(wMax[1], ref.offset);
                wMax[2] = Math.max(wMax[2], ref.genNumber);
                continue;
            }
            if (entry instanceof ObjectStreamReference) {
                objStream = (ObjectStreamReference)entry;
                wMax[0] = Math.max(wMax[0], 2L);
                wMax[1] = Math.max(wMax[1], objStream.offset);
                wMax[2] = Math.max(wMax[2], objStream.objectNumberOfObjectStream);
                continue;
            }
            throw new RuntimeException("unexpected reference type");
        }
        w = new int[3];
        i = 0;
        ** GOTO lbl32
        {
            v0 = i;
            w[v0] = w[v0] + 1;
            v1 = i;
            wMax[v1] = wMax[v1] >> 8;
            do {
                if (wMax[i] > 0L) continue block1;
                ++i;
lbl32:
                // 2 sources

            } while (i < w.length);
        }
        return w;
    }

    private long getSizeEntry() {
        return this.size;
    }

    public void setSize(long streamSize) {
        this.size = streamSize;
    }

    private List<Integer> getIndexEntry() {
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        Integer first = null;
        Integer length = null;
        for (Integer objNumber : this.objectNumbers) {
            if (first == null) {
                first = objNumber;
                length = 1;
            }
            if (first + length == objNumber) {
                length = length + 1;
            }
            if (first + length >= objNumber) continue;
            linkedList.add(first);
            linkedList.add(length);
            first = objNumber;
            length = 1;
        }
        linkedList.add(first);
        linkedList.add(length);
        return linkedList;
    }

    private void writeNumber(OutputStream os, long number, int bytes) throws IOException {
        byte[] buffer = new byte[bytes];
        int i = 0;
        while (i < bytes) {
            buffer[i] = (byte)(number & 0xFFL);
            number >>= 8;
            ++i;
        }
        i = 0;
        while (i < bytes) {
            os.write(buffer[bytes - i - 1]);
            ++i;
        }
    }

    private void writeStreamData(OutputStream os, int[] w) throws IOException {
        for (Object entry : this.streamData.values()) {
            if (entry instanceof FreeReference) {
                FreeReference free = (FreeReference)entry;
                this.writeNumber(os, 0L, w[0]);
                this.writeNumber(os, free.nextFree, w[1]);
                this.writeNumber(os, free.nextGenNumber, w[2]);
                continue;
            }
            if (entry instanceof NormalReference) {
                NormalReference ref = (NormalReference)entry;
                this.writeNumber(os, 1L, w[0]);
                this.writeNumber(os, ref.offset, w[1]);
                this.writeNumber(os, ref.genNumber, w[2]);
                continue;
            }
            if (entry instanceof ObjectStreamReference) {
                ObjectStreamReference objStream = (ObjectStreamReference)entry;
                this.writeNumber(os, 2L, w[0]);
                this.writeNumber(os, objStream.offset, w[1]);
                this.writeNumber(os, objStream.objectNumberOfObjectStream, w[2]);
                continue;
            }
            throw new RuntimeException("unexpected reference type");
        }
        os.flush();
        os.close();
    }

    @Override
    public OMObject getObject(int objectNumber) {
        return null;
    }

    class FreeReference {
        long nextGenNumber;
        long nextFree;

        FreeReference() {
        }
    }

    class NormalReference {
        long genNumber;
        long offset;

        NormalReference() {
        }
    }

    class ObjectStreamReference {
        long objectNumberOfObjectStream;
        long offset;

        ObjectStreamReference() {
        }
    }
}

