/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.pdfparser;

import com.plpdf.exceptions.CryptographyException;
import com.plpdf.io.RandomAccess;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMBoolean;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNull;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMObject;
import com.plpdf.om.OMStream;
import com.plpdf.pdfparser.BaseParser;
import com.plpdf.smmodel.common.SMStream;
import com.plpdf.util.ImageParameters;
import com.plpdf.util.PDFOperator;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFStreamParser
extends BaseParser {
    private List<Object> streamObjects = new ArrayList<Object>(100);
    private RandomAccess file;
    private PDFOperator lastBIToken = null;
    private final int maxBinCharTestLength = 10;
    private final byte[] binCharTestArr = new byte[10];

    public PDFStreamParser(InputStream stream, RandomAccess raf, boolean forceParsing) throws IOException {
        super(stream, forceParsing);
        this.file = raf;
    }

    public PDFStreamParser(InputStream stream, RandomAccess raf) throws IOException {
        this(stream, raf, FORCE_PARSING);
    }

    public PDFStreamParser(SMStream stream) throws IOException {
        this(stream.createInputStream(), stream.getStream().getScratchFile());
    }

    public PDFStreamParser(OMStream stream, boolean forceParsing) throws IOException {
        this(stream.getUnfilteredStream(), stream.getScratchFile(), forceParsing);
    }

    public PDFStreamParser(OMStream stream) throws IOException {
        this(stream.getUnfilteredStream(), stream.getScratchFile());
    }

    public void parse() throws IOException, CryptographyException {
        try {
            Object token = null;
            while ((token = this.parseNextToken()) != null) {
                this.streamObjects.add(token);
            }
        }
        finally {
            this.pdfSource.close();
        }
    }

    public List<Object> getTokens() {
        return this.streamObjects;
    }

    public void close() throws IOException {
        this.pdfSource.close();
    }

    public Iterator<Object> getTokenIterator() {
        return new Iterator<Object>(){
            private Object token;

            private void tryNext() throws CryptographyException {
                try {
                    if (this.token == null) {
                        this.token = PDFStreamParser.this.parseNextToken();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }

            @Override
            public boolean hasNext() {
                try {
                    this.tryNext();
                }
                catch (CryptographyException e) {
                    e.printStackTrace();
                }
                return this.token != null;
            }

            @Override
            public Object next() {
                try {
                    this.tryNext();
                }
                catch (CryptographyException e) {
                    e.printStackTrace();
                }
                Object tmp = this.token;
                if (tmp == null) {
                    throw new NoSuchElementException();
                }
                this.token = null;
                return tmp;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private Object parseNextToken() throws IOException, CryptographyException {
        Object retval = null;
        this.skipSpaces();
        int nextByte = this.pdfSource.peek();
        if ((byte)nextByte == -1) {
            return null;
        }
        char c = (char)nextByte;
        switch (c) {
            case '<': {
                int leftBracket = this.pdfSource.read();
                c = (char)this.pdfSource.peek();
                this.pdfSource.unread(leftBracket);
                if (c == '<') {
                    OMDictionary pod = this.parseOMDictionary();
                    this.skipSpaces();
                    if ((char)this.pdfSource.peek() == 's') {
                        retval = this.parseOMStream(pod, this.file);
                        break;
                    }
                    retval = pod;
                    break;
                }
                retval = this.parseOMString(false);
                break;
            }
            case '[': {
                retval = this.parseOMArray();
                break;
            }
            case '(': {
                retval = this.parseOMString(false);
                break;
            }
            case '/': {
                retval = this.parseOMName();
                break;
            }
            case 'n': {
                String nullString = this.readString();
                if (nullString.equals("null")) {
                    retval = OMNull.NULL;
                    break;
                }
                retval = PDFOperator.getOperator(nullString);
                break;
            }
            case 'f': 
            case 't': {
                String next = this.readString();
                if (next.equals("true")) {
                    retval = OMBoolean.TRUE;
                    break;
                }
                if (next.equals("false")) {
                    retval = OMBoolean.FALSE;
                    break;
                }
                retval = PDFOperator.getOperator(next);
                break;
            }
            case 'R': {
                String line = this.readString();
                if (line.equals("R")) {
                    retval = new OMObject(null);
                    break;
                }
                retval = PDFOperator.getOperator(line);
                break;
            }
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                StringBuffer buf = new StringBuffer();
                buf.append(c);
                this.pdfSource.read();
                boolean dotNotRead = c != '.';
                while (Character.isDigit(c = (char)this.pdfSource.peek()) || dotNotRead && c == '.') {
                    buf.append(c);
                    this.pdfSource.read();
                    if (!dotNotRead || c != '.') continue;
                    dotNotRead = false;
                }
                retval = OMNumber.get(buf.toString());
                break;
            }
            case 'B': {
                String next = this.readString();
                retval = PDFOperator.getOperator(next);
                if (!next.equals("BI")) break;
                this.lastBIToken = (PDFOperator)retval;
                OMDictionary imageParams = new OMDictionary();
                this.lastBIToken.setImageParameters(new ImageParameters(imageParams));
                Object nextToken = null;
                while ((nextToken = this.parseNextToken()) instanceof OMName) {
                    Object value = this.parseNextToken();
                    imageParams.setItem((OMName)nextToken, (OMBase)value);
                }
                PDFOperator imageData = (PDFOperator)nextToken;
                this.lastBIToken.setImageData(imageData.getImageData());
                break;
            }
            case 'I': {
                String id = "" + (char)this.pdfSource.read() + (char)this.pdfSource.read();
                if (!id.equals("ID")) {
                    throw new IOException("Error: Expected operator 'ID' actual='" + id + "'");
                }
                ByteArrayOutputStream imageData = new ByteArrayOutputStream();
                if (this.isWhitespace()) {
                    this.pdfSource.read();
                }
                int lastByte = this.pdfSource.read();
                int currentByte = this.pdfSource.read();
                while (!(lastByte == 69 && currentByte == 73 && this.hasNextSpaceOrReturn() && this.hasNoFollowingBinData(this.pdfSource) || this.pdfSource.isEOF())) {
                    imageData.write(lastByte);
                    lastByte = currentByte;
                    currentByte = this.pdfSource.read();
                }
                retval = PDFOperator.getOperator("ID");
                ((PDFOperator)retval).setImageData(imageData.toByteArray());
                break;
            }
            case ']': {
                this.pdfSource.read();
                retval = OMNull.NULL;
                break;
            }
            default: {
                String operator = this.readOperator();
                retval = operator.trim().length() == 0 ? null : PDFOperator.getOperator(operator);
            }
        }
        return retval;
    }

    private boolean hasNextSpaceOrReturn() throws IOException {
        return this.isSpaceOrReturn(this.pdfSource.peek());
    }

    private boolean hasNoFollowingBinData(PushbackInputStream pdfSource) throws IOException {
        int readBytes = pdfSource.read(this.binCharTestArr, 0, 10);
        boolean noBinData = true;
        int startOpIdx = -1;
        int endOpIdx = -1;
        if (readBytes > 0) {
            int bIdx = 0;
            while (bIdx < readBytes) {
                byte b = this.binCharTestArr[bIdx];
                if (b < 9 || b > 10 && b < 32 && b != 13) {
                    noBinData = false;
                    break;
                }
                if (startOpIdx == -1 && b != 9 && b != 32 && b != 10 && b != 13) {
                    startOpIdx = bIdx;
                } else if (startOpIdx != -1 && endOpIdx == -1 && (b == 9 || b == 32 || b == 10 || b == 13)) {
                    endOpIdx = bIdx;
                }
                ++bIdx;
            }
            if (readBytes == 10) {
                if (startOpIdx != -1 && endOpIdx == -1) {
                    endOpIdx = 10;
                }
                if (endOpIdx != -1 && startOpIdx != -1 && endOpIdx - startOpIdx > 3) {
                    noBinData = false;
                }
            }
            pdfSource.unread(this.binCharTestArr, 0, readBytes);
        }
        return noBinData;
    }

    protected String readOperator() throws IOException {
        this.skipSpaces();
        StringBuffer buffer = new StringBuffer(4);
        int nextChar = this.pdfSource.peek();
        while (!(nextChar == -1 || this.isWhitespace(nextChar) || this.isClosing(nextChar) || nextChar == 91 || nextChar == 60 || nextChar == 40 || nextChar == 47 || nextChar >= 48 && nextChar <= 57)) {
            char currentChar = (char)this.pdfSource.read();
            nextChar = this.pdfSource.peek();
            buffer.append(currentChar);
            if (currentChar != 'd' || nextChar != 48 && nextChar != 49) continue;
            buffer.append((char)this.pdfSource.read());
            nextChar = this.pdfSource.peek();
        }
        return buffer.toString();
    }

    private boolean isSpaceOrReturn(int c) {
        return c == 10 || c == 13 || c == 32;
    }

    private boolean isSpaceOrReturn() throws IOException {
        return this.isSpaceOrReturn(this.pdfSource.peek());
    }
}

