/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.pdfparser;

import com.plpdf.exceptions.CryptographyException;
import com.plpdf.exceptions.PlpdfException;
import com.plpdf.exceptions.WrappedIOException;
import com.plpdf.io.RandomAccess;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMDocument;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMObject;
import com.plpdf.om.OMStream;
import com.plpdf.pdfparser.BaseParser;
import com.plpdf.pdfparser.PDFXrefStreamParser;
import com.plpdf.pdfparser.XrefTrailerResolver;
import com.plpdf.persistence.util.OMObjectKey;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.fdf.FDFDocument;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFParser
extends BaseParser {
    private static final int SPACE_BYTE = 32;
    private static final String PDF_HEADER = "%PDF-";
    private static final String FDF_HEADER = "%FDF-";
    private static final String PDF_DEFAULT_VERSION = "1.4";
    private static final String FDF_DEFAULT_VERSION = "1.0";
    private List<ConflictObj> conflictList = new ArrayList<ConflictObj>();
    protected XrefTrailerResolver xrefTrailerResolver = new XrefTrailerResolver();
    private File tempDirectory = null;
    private RandomAccess raf = null;

    public PDFParser(InputStream input) throws IOException {
        this(input, null, FORCE_PARSING);
    }

    public PDFParser(InputStream input, RandomAccess rafi) throws IOException {
        this(input, rafi, FORCE_PARSING);
    }

    public PDFParser(InputStream input, RandomAccess rafi, boolean force) throws IOException {
        super(input, force);
        this.raf = rafi;
    }

    public void setTempDirectory(File tmpDir) {
        this.tempDirectory = tmpDir;
    }

    protected boolean isContinueOnError(Exception e) {
        return this.forceParsing;
    }

    public void parse() throws IOException, CryptographyException {
        try {
            try {
                this.document = this.raf == null ? (this.tempDirectory != null ? new OMDocument(this.tempDirectory) : new OMDocument()) : new OMDocument(this.raf);
                this.setDocument(this.document);
                this.parseHeader();
                this.skipToNextObj();
                boolean wasLastParsedObjectEOF = false;
                while (!this.pdfSource.isEOF()) {
                    try {
                        wasLastParsedObjectEOF |= this.parseObject();
                    }
                    catch (IOException e) {
                        if (wasLastParsedObjectEOF) break;
                        if (this.isContinueOnError(e)) {
                            this.skipSpaces();
                            long lastOffset = this.pdfSource.getOffset();
                            this.skipToNextObj();
                            if (lastOffset == this.pdfSource.getOffset()) {
                                this.readStringNumber();
                                this.skipToNextObj();
                            }
                        }
                        throw e;
                    }
                    this.skipSpaces();
                }
                this.xrefTrailerResolver.setStartxref(this.document.getStartXref());
                this.document.setTrailer(this.xrefTrailerResolver.getTrailer());
                this.document.addXRefTable(this.xrefTrailerResolver.getXrefTable());
                if (!this.document.isEncrypted()) {
                    this.document.dereferenceObjectStreams();
                }
                ConflictObj.resolveConflicts(this.document, this.conflictList);
            }
            catch (Throwable t) {
                if (this.document != null) {
                    this.document.close();
                    this.document = null;
                }
                if (t instanceof IOException) {
                    throw (IOException)t;
                }
                throw new WrappedIOException(t);
            }
        }
        finally {
            this.pdfSource.close();
        }
    }

    private void skipToNextObj() throws IOException {
        byte[] b = new byte[16];
        Pattern p = Pattern.compile("\\d+\\s+\\d+\\s+obj.*", 32);
        while (!this.pdfSource.isEOF()) {
            int l = this.pdfSource.read(b);
            if (l < 1) break;
            String s = new String(b, "US-ASCII");
            if (s.startsWith("trailer") || s.startsWith("xref") || s.startsWith("startxref") || s.startsWith("stream") || p.matcher(s).matches()) {
                this.pdfSource.unread(b);
                break;
            }
            this.pdfSource.unread(b, 1, l - 1);
        }
    }

    private void parseHeader() throws IOException {
        String headerGarbage;
        String header = this.readLine();
        if (header.indexOf(PDF_HEADER) == -1 && header.indexOf(FDF_HEADER) == -1) {
            header = this.readLine();
            while (header.indexOf(PDF_HEADER) == -1 && header.indexOf(FDF_HEADER) == -1) {
                if (header.length() > 0 && Character.isDigit(header.charAt(0))) break;
                header = this.readLine();
            }
        }
        if (header.indexOf(PDF_HEADER) == -1 && header.indexOf(FDF_HEADER) == -1) {
            throw new IOException("Error: Header doesn't contain versioninfo");
        }
        int headerStart = header.indexOf(PDF_HEADER);
        if (headerStart == -1) {
            headerStart = header.indexOf(FDF_HEADER);
        }
        if (headerStart > 0) {
            header = header.substring(headerStart, header.length());
        }
        if (header.startsWith(PDF_HEADER)) {
            if (!header.matches("%PDF-\\d.\\d")) {
                if (header.length() < PDF_HEADER.length() + 3) {
                    header = "%PDF-1.4";
                } else {
                    headerGarbage = String.valueOf(header.substring(PDF_HEADER.length() + 3, header.length())) + "\n";
                    header = header.substring(0, PDF_HEADER.length() + 3);
                    this.pdfSource.unread(headerGarbage.getBytes("ISO-8859-1"));
                }
            }
        } else if (!header.matches("%FDF-\\d.\\d")) {
            if (header.length() < FDF_HEADER.length() + 3) {
                header = "%FDF-1.0";
            } else {
                headerGarbage = String.valueOf(header.substring(FDF_HEADER.length() + 3, header.length())) + "\n";
                header = header.substring(0, FDF_HEADER.length() + 3);
                this.pdfSource.unread(headerGarbage.getBytes("ISO-8859-1"));
            }
        }
        this.document.setHeaderString(header);
        try {
            if (header.startsWith(PDF_HEADER)) {
                float pdfVersion = Float.parseFloat(header.substring(PDF_HEADER.length(), Math.min(header.length(), PDF_HEADER.length() + 3)));
                this.document.setVersion(pdfVersion);
            } else {
                float pdfVersion = Float.parseFloat(header.substring(FDF_HEADER.length(), Math.min(header.length(), FDF_HEADER.length() + 3)));
                this.document.setVersion(pdfVersion);
            }
        }
        catch (NumberFormatException e) {
            throw new IOException("Error getting pdf version:" + e);
        }
    }

    public OMDocument getDocument() throws IOException {
        if (this.document == null) {
            throw new IOException("You must call parse() before calling getDocument()");
        }
        return this.document;
    }

    public SMDocument getSMDocument() throws IOException {
        return new SMDocument(this.getDocument());
    }

    public FDFDocument getFDFDocument() throws IOException {
        return new FDFDocument(this.getDocument());
    }

    private boolean parseObject() throws IOException, CryptographyException, PlpdfException {
        long currentObjByteOffset = this.pdfSource.getOffset();
        boolean isEndOfFile = false;
        this.skipSpaces();
        char peekedChar = (char)this.pdfSource.peek();
        while (peekedChar == 'e') {
            this.readString();
            this.skipSpaces();
            currentObjByteOffset = this.pdfSource.getOffset();
            peekedChar = (char)this.pdfSource.peek();
        }
        if (!this.pdfSource.isEOF()) {
            if (peekedChar == 'x') {
                this.parseXrefTable(currentObjByteOffset);
            } else if (peekedChar == 't' || peekedChar == 's') {
                if (peekedChar == 't') {
                    this.parseTrailer();
                    peekedChar = (char)this.pdfSource.peek();
                }
                if (peekedChar == 's') {
                    this.parseStartXref();
                    while (this.isWhitespace(this.pdfSource.peek()) && !this.pdfSource.isEOF()) {
                        this.pdfSource.read();
                    }
                    String eof = "";
                    if (!this.pdfSource.isEOF()) {
                        eof = this.readLine();
                    }
                    if (!"%%EOF".equals(eof)) {
                        if (eof.startsWith("%%EOF")) {
                            this.pdfSource.unread(32);
                            this.pdfSource.unread(eof.substring(5).getBytes("ISO-8859-1"));
                        } else if (!this.pdfSource.isEOF()) {
                            this.pdfSource.unread(32);
                            this.pdfSource.unread(eof.getBytes("ISO-8859-1"));
                        }
                    }
                    isEndOfFile = true;
                }
            } else {
                OMObjectKey key;
                OMObject pdfObject;
                long number = -1L;
                int genNum = -1;
                String objectKey = null;
                boolean missingObjectNumber = false;
                try {
                    char peeked = (char)this.pdfSource.peek();
                    if (peeked == '<') {
                        missingObjectNumber = true;
                    } else {
                        number = this.readObjectNumber();
                    }
                }
                catch (IOException e) {
                    number = this.readObjectNumber();
                }
                if (!missingObjectNumber) {
                    this.skipSpaces();
                    genNum = this.readGenerationNumber();
                    objectKey = this.readString(3);
                    if (!(objectKey.equals("obj") || this.isContinueOnError(null) && objectKey.equals("o"))) {
                        throw new IOException("expected='obj' actual='" + objectKey + "' " + this.pdfSource);
                    }
                } else {
                    number = -1L;
                    genNum = -1;
                }
                this.skipSpaces();
                OMBase pb = this.parseDirObject();
                String endObjectKey = this.readString();
                if (endObjectKey.equals("stream")) {
                    this.pdfSource.unread(endObjectKey.getBytes("ISO-8859-1"));
                    this.pdfSource.unread(32);
                    if (pb instanceof OMDictionary) {
                        OMName objectType;
                        OMStream strmObj = (OMStream)(pb = this.parseOMStream((OMDictionary)pb, this.getDocument().getScratchFile()));
                        OMBase objectType_ = strmObj.getItem(OMName.TYPE);
                        if (objectType_ instanceof OMName && (objectType = (OMName)objectType_) != null && objectType.equals(OMName.XREF)) {
                            this.parseXrefStream(strmObj, currentObjByteOffset);
                        }
                    } else {
                        throw new IOException("stream not preceded by dictionary");
                    }
                    this.skipSpaces();
                    endObjectKey = this.readLine();
                }
                if ((pdfObject = this.document.getObjectFromPool(key = new OMObjectKey(number, genNum))).getObject() == null) {
                    pdfObject.setObject(pb);
                } else {
                    this.addObjectToConflicts(currentObjByteOffset, key, pb);
                }
                if (!endObjectKey.equals("endobj")) {
                    if (endObjectKey.startsWith("endobj")) {
                        this.pdfSource.unread(32);
                        this.pdfSource.unread(endObjectKey.substring(6).getBytes("ISO-8859-1"));
                    } else if (!endObjectKey.trim().endsWith("endobj") && !this.pdfSource.isEOF()) {
                        this.pdfSource.unread(32);
                        this.pdfSource.unread(endObjectKey.getBytes("ISO-8859-1"));
                    }
                }
                this.skipSpaces();
            }
        }
        return isEndOfFile;
    }

    private void addObjectToConflicts(long offset, OMObjectKey key, OMBase pb) throws IOException {
        OMObject obj = new OMObject(null);
        obj.setObjectNumber(OMInteger.get(key.getNumber()));
        obj.setGenerationNumber(OMInteger.get(key.getGeneration()));
        obj.setObject(pb);
        ConflictObj conflictObj = new ConflictObj(offset, key, obj);
        this.conflictList.add(conflictObj);
    }

    protected boolean parseStartXref() throws IOException {
        if (this.pdfSource.peek() != 115) {
            return false;
        }
        String startXRef = this.readString();
        if (!startXRef.trim().equals("startxref")) {
            return false;
        }
        this.skipSpaces();
        this.getDocument().setStartXref(this.readLong());
        return true;
    }

    protected boolean parseXrefTable(long startByteOffset) throws IOException {
        char c;
        if (this.pdfSource.peek() != 120) {
            return false;
        }
        String xref = this.readString();
        if (!xref.trim().equals("xref")) {
            return false;
        }
        this.xrefTrailerResolver.nextXrefObj(startByteOffset);
        do {
            long currObjID = this.readObjectNumber();
            long count = this.readLong();
            this.skipSpaces();
            int i = 0;
            while ((long)i < count) {
                String currentLine;
                String[] splitString;
                if (this.pdfSource.isEOF() || this.isEndOfName((char)this.pdfSource.peek()) || this.pdfSource.peek() == 116 || (splitString = (currentLine = this.readLine()).split(" ")).length < 3) break;
                if (splitString[splitString.length - 1].equals("n")) {
                    try {
                        long currOffset = Long.parseLong(splitString[0]);
                        int currGenID = Integer.parseInt(splitString[1]);
                        OMObjectKey objKey = new OMObjectKey(currObjID, currGenID);
                        this.xrefTrailerResolver.setXRef(objKey, currOffset);
                    }
                    catch (NumberFormatException e) {
                        throw new IOException(e.getMessage());
                    }
                } else if (!splitString[2].equals("f")) {
                    throw new IOException("Corrupt XRefTable Entry - ObjID:" + currObjID);
                }
                ++currObjID;
                this.skipSpaces();
                ++i;
            }
            this.skipSpaces();
        } while ((c = (char)this.pdfSource.peek()) >= '0' && c <= '9');
        return true;
    }

    protected boolean parseTrailer() throws IOException {
        if (this.pdfSource.peek() != 116) {
            return false;
        }
        String nextLine = this.readLine();
        if (!nextLine.trim().equals("trailer")) {
            if (nextLine.startsWith("trailer")) {
                byte[] b = nextLine.getBytes("ISO-8859-1");
                int len = "trailer".length();
                this.pdfSource.unread(10);
                this.pdfSource.unread(b, len, b.length - len);
            } else {
                return false;
            }
        }
        this.skipSpaces();
        OMDictionary parsedTrailer = this.parseOMDictionary();
        this.xrefTrailerResolver.setTrailer(parsedTrailer);
        this.readVersionInTrailer(parsedTrailer);
        this.skipSpaces();
        return true;
    }

    private void readVersionInTrailer(OMDictionary parsedTrailer) {
        float trailerVersion;
        OMName version;
        OMObject root = (OMObject)parsedTrailer.getItem(OMName.ROOT);
        if (root != null && (version = (OMName)root.getItem(OMName.VERSION)) != null && (trailerVersion = Float.valueOf(version.getName()).floatValue()) > this.document.getVersion()) {
            this.document.setVersion(trailerVersion);
        }
    }

    public void parseXrefStream(OMStream stream, long objByteOffset) throws IOException {
        this.xrefTrailerResolver.nextXrefObj(objByteOffset);
        this.xrefTrailerResolver.setTrailer(stream);
        PDFXrefStreamParser parser = new PDFXrefStreamParser(stream, this.document, this.forceParsing, this.xrefTrailerResolver);
        parser.parse();
    }

    private static boolean tolerantConflicResolver(Collection<Long> values, long offset, int tolerance) {
        if (values.contains(offset)) {
            return true;
        }
        for (Long integer : values) {
            if (Math.abs(integer - offset) > (long)tolerance) continue;
            return true;
        }
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConflictObj {
        private long offset;
        private OMObjectKey objectKey;
        private OMObject object;

        public ConflictObj(long offsetValue, OMObjectKey key, OMObject pdfObject) {
            this.offset = offsetValue;
            this.objectKey = key;
            this.object = pdfObject;
        }

        public String toString() {
            return "Object(" + this.offset + ", " + this.objectKey + ")";
        }

        private static void resolveConflicts(OMDocument document, List<ConflictObj> conflictList) throws IOException {
            Iterator<ConflictObj> conflicts = conflictList.iterator();
            if (conflicts.hasNext()) {
                Collection<Long> values = document.getXrefTable().values();
                do {
                    OMObject pdfObject;
                    ConflictObj o = conflicts.next();
                    Long offset = new Long(o.offset);
                    if (!PDFParser.tolerantConflicResolver(values, offset, 4) || (pdfObject = document.getObjectFromPool(o.objectKey)).getObjectNumber() == null || !pdfObject.getObjectNumber().equals(o.object.getObjectNumber())) continue;
                    pdfObject.setObject(o.object.getObject());
                } while (conflicts.hasNext());
            }
        }
    }
}

