/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.pdfparser;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMDocument;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMObject;
import com.plpdf.om.OMStream;
import com.plpdf.pdfparser.BaseParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFObjectStreamParser
extends BaseParser {
    private List<OMObject> streamObjects = null;
    private List<Long> objectNumbers = null;
    private List<Long> objectOffsets = null;
    private OMStream stream;

    public PDFObjectStreamParser(OMStream strm, OMDocument doc, boolean forceParsing) throws IOException {
        super(strm.getUnfilteredStream(), forceParsing);
        this.setDocument(doc);
        this.stream = strm;
    }

    public PDFObjectStreamParser(OMStream strm, OMDocument doc) throws IOException {
        this(strm, doc, FORCE_PARSING);
    }

    public void parse() throws IOException {
        try {
            int numberOfObjects = this.stream.getInt("N");
            int first = this.stream.getInt("First");
            this.objectNumbers = new ArrayList<Long>(numberOfObjects);
            this.objectOffsets = new ArrayList<Long>(numberOfObjects);
            this.streamObjects = new ArrayList<OMObject>(numberOfObjects);
            int i = 0;
            while (i < numberOfObjects) {
                long objectNumber = this.readObjectNumber();
                long objectOffset = this.readLong();
                this.objectNumbers.add(new Long(objectNumber));
                this.objectOffsets.add(new Long(objectOffset));
                ++i;
            }
            OMObject object = null;
            OMBase cosObject = null;
            int objectCounter = 0;
            int objectNextOffset = 0;
            int i2 = 0;
            while (i2 < numberOfObjects) {
                OMInteger objNum = OMInteger.get(this.objectNumbers.get(i2).intValue());
                objectNextOffset = first + this.objectOffsets.get(i2).intValue();
                if ((long)objectNextOffset > this.getOffset()) {
                    this.seekplus((long)objectNextOffset - this.getOffset());
                }
                if ((cosObject = this.parseDirObject()) != null) {
                    object = new OMObject(cosObject);
                    object.setGenerationNumber(OMInteger.ZERO);
                    object.setObjectNumber(objNum);
                    this.streamObjects.add(object);
                }
                ++objectCounter;
                ++i2;
            }
        }
        finally {
            this.pdfSource.close();
        }
    }

    public List<OMObject> getObjects() {
        return this.streamObjects;
    }
}

