/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.pdfparser;

import com.plpdf.exceptions.CryptographyException;
import com.plpdf.io.IOUtils;
import com.plpdf.io.PushBackInputStream;
import com.plpdf.io.RandomAccess;
import com.plpdf.io.RandomAccessBuffer;
import com.plpdf.io.RandomAccessBufferedFileInputStream;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMDocument;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNull;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMObject;
import com.plpdf.om.OMStream;
import com.plpdf.om.OMString;
import com.plpdf.pdfparser.PDFObjectStreamParser;
import com.plpdf.pdfparser.PDFParser;
import com.plpdf.persistence.util.OMObjectKey;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.SMPage;
import com.plpdf.smmodel.encryption.AccessPermission;
import com.plpdf.smmodel.encryption.DecryptionMaterial;
import com.plpdf.smmodel.encryption.PublicKeyDecryptionMaterial;
import com.plpdf.smmodel.encryption.SMEncryptionDictionary;
import com.plpdf.smmodel.encryption.SecurityHandler;
import com.plpdf.smmodel.encryption.SecurityHandlersManager;
import com.plpdf.smmodel.encryption.StandardDecryptionMaterial;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NonSequentialPDFParser
extends PDFParser {
    private static final int E = 101;
    private static final int N = 110;
    public static final String SYSPROP_PARSEMINIMAL = "com.plpdf.pdfparser.nonSequentialPDFParser.parseMinimal";
    public static final String SYSPROP_EOFLOOKUPRANGE = "com.plpdf.pdfparser.nonSequentialPDFParser.eofLookupRange";
    private static final InputStream EMPTY_INPUT_STREAM = new ByteArrayInputStream(new byte[0]);
    protected static final int DEFAULT_TRAIL_BYTECOUNT = 2048;
    protected static final char[] EOF_MARKER = new char[]{'%', '%', 'E', 'O', 'F'};
    protected static final char[] STARTXREF_MARKER = new char[]{'s', 't', 'a', 'r', 't', 'x', 'r', 'e', 'f'};
    protected static final char[] OBJ_MARKER = new char[]{'o', 'b', 'j'};
    private final File pdfFile;
    private final RandomAccessBufferedFileInputStream raStream;
    protected SecurityHandler securityHandler = null;
    private String keyStoreFilename = null;
    private String alias = null;
    private String password = "";
    private int readTrailBytes = 2048;
    private boolean parseMinimalCatalog = "true".equals(System.getProperty("com.plpdf.pdfparser.nonSequentialPDFParser.parseMinimal"));
    private boolean initialParseDone = false;
    private boolean allPagesParsed = false;
    private boolean isTmpPDFFile = false;
    public static final String TMP_FILE_PREFIX = "tmpPDF";
    private OMDictionary pagesDictionary = null;
    private boolean inGetLength = false;
    private final int streamCopyBufLen = 8192;
    private final byte[] streamCopyBuf = new byte[8192];

    public NonSequentialPDFParser(String filename) throws IOException {
        this(new File(filename), null);
    }

    public NonSequentialPDFParser(File file, RandomAccess raBuf) throws IOException {
        this(file, raBuf, "");
    }

    public NonSequentialPDFParser(File file, RandomAccess raBuf, String decryptionPassword) throws IOException {
        super(EMPTY_INPUT_STREAM, null, false);
        this.pdfFile = file;
        this.raStream = new RandomAccessBufferedFileInputStream(this.pdfFile);
        this.init(file, raBuf, decryptionPassword);
    }

    private void init(File file, RandomAccess raBuf, String decryptionPassword) throws IOException {
        String eofLookupRangeStr = System.getProperty(SYSPROP_EOFLOOKUPRANGE);
        if (eofLookupRangeStr != null) {
            try {
                this.setEOFLookupRange(Integer.parseInt(eofLookupRangeStr));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.setDocument(raBuf == null ? new OMDocument(new RandomAccessBuffer(), false) : new OMDocument(raBuf, false));
        this.pdfSource = new PushBackInputStream(this.raStream, 4096);
        this.password = decryptionPassword;
    }

    public NonSequentialPDFParser(InputStream input) throws IOException {
        this(input, null, "");
    }

    public NonSequentialPDFParser(InputStream input, RandomAccess raBuf, String decryptionPassword) throws IOException {
        super(EMPTY_INPUT_STREAM, null, false);
        this.pdfFile = this.createTmpFile(input);
        this.raStream = new RandomAccessBufferedFileInputStream(this.pdfFile);
        this.init(this.pdfFile, raBuf, decryptionPassword);
    }

    private File createTmpFile(InputStream input) throws IOException {
        File file;
        File tmpFile = null;
        FileOutputStream fos = null;
        try {
            tmpFile = File.createTempFile(TMP_FILE_PREFIX, ".pdf");
            fos = new FileOutputStream(tmpFile);
            IOUtils.copy(input, fos);
            this.isTmpPDFFile = true;
            file = tmpFile;
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly(fos);
            throw throwable;
        }
        IOUtils.closeQuietly(input);
        IOUtils.closeQuietly(fos);
        return file;
    }

    public void setEOFLookupRange(int byteCount) {
        if (byteCount > 15) {
            this.readTrailBytes = byteCount;
        }
    }

    protected void initialParse() throws IOException {
        OMObject catalogObj;
        OMDictionary trailer;
        long xrefOffset;
        long startxrefOff = this.getStartxrefOffset();
        this.setPdfSource(startxrefOff);
        this.parseStartXref();
        long prev = xrefOffset = this.document.getStartXref();
        while (prev > -1L) {
            this.setPdfSource(prev);
            this.skipSpaces();
            if (this.pdfSource.peek() == 120) {
                this.parseXrefTable(prev);
                if (!this.parseTrailer()) {
                    throw new IOException("Expected trailer object at position: " + this.pdfSource.getOffset());
                }
                trailer = this.xrefTrailerResolver.getCurrentTrailer();
                prev = trailer.getInt(OMName.PREV);
                continue;
            }
            prev = this.parseXrefObjStream(prev);
        }
        this.xrefTrailerResolver.setStartxref(xrefOffset);
        trailer = this.xrefTrailerResolver.getTrailer();
        this.document.setTrailer(trailer);
        OMBase trailerEncryptItem = this.document.getTrailer().getItem(OMName.ENCRYPT);
        if (trailerEncryptItem != null) {
            if (trailerEncryptItem instanceof OMObject) {
                OMObject trailerEncryptObj = (OMObject)trailerEncryptItem;
                this.parseObjectDynamically(trailerEncryptObj, false);
            }
            try {
                SMEncryptionDictionary encParameters = new SMEncryptionDictionary(this.document.getEncryptionDictionary());
                Object decryptionMaterial = null;
                if (this.keyStoreFilename != null) {
                    KeyStore ks = KeyStore.getInstance("PKCS12");
                    ks.load(new FileInputStream(this.keyStoreFilename), this.password.toCharArray());
                    decryptionMaterial = new PublicKeyDecryptionMaterial(ks, this.alias, this.password);
                } else {
                    decryptionMaterial = new StandardDecryptionMaterial(this.password);
                }
                this.securityHandler = SecurityHandlersManager.getInstance().getSecurityHandler(encParameters.getFilter());
                this.securityHandler.prepareForDecryption(encParameters, this.document.getDocumentID(), (DecryptionMaterial)decryptionMaterial);
                AccessPermission permission = this.securityHandler.getCurrentAccessPermission();
                permission.canExtractContent();
            }
            catch (Exception e) {
                throw new IOException("Error (" + e.getClass().getSimpleName() + ") while creating security handler for decryption: " + e.getMessage());
            }
        }
        for (OMBase trailerEntry : trailer.getValues()) {
            if (!(trailerEntry instanceof OMObject)) continue;
            OMObject tmpObj = (OMObject)trailerEntry;
            this.parseObjectDynamically(tmpObj, false);
        }
        OMObject root = (OMObject)this.xrefTrailerResolver.getTrailer().getItem(OMName.ROOT);
        if (root == null) {
            throw new IOException("Missing root object specification in trailer.");
        }
        this.parseObjectDynamically(root, false);
        if (!this.parseMinimalCatalog && (catalogObj = this.document.getCatalog()) != null && catalogObj.getObject() instanceof OMDictionary) {
            this.parseDictObjects((OMDictionary)catalogObj.getObject(), null);
            this.allPagesParsed = true;
            this.document.setDecrypted();
        }
        this.initialParseDone = true;
    }

    private long parseXrefObjStream(long objByteOffset) throws IOException {
        this.readObjectNumber();
        this.readGenerationNumber();
        this.readPattern(OBJ_MARKER);
        OMDictionary dict = this.parseOMDictionary();
        OMStream xrefStream = this.parseOMStream(dict, this.getDocument().getScratchFile());
        this.parseXrefStream(xrefStream, (int)objByteOffset);
        return dict.getLong(OMName.PREV);
    }

    private final long getPdfSourceOffset() {
        return this.pdfSource.getOffset();
    }

    protected final void setPdfSource(long fileOffset) throws IOException {
        this.pdfSource.seek(fileOffset);
    }

    protected final void releasePdfSourceInputStream() throws IOException {
    }

    private final void closeFileStream() throws IOException {
        if (this.pdfSource != null) {
            this.pdfSource.close();
        }
    }

    protected final long getStartxrefOffset() throws IOException {
        long skipBytes;
        byte[] buf;
        long fileLen = this.pdfFile.length();
        FileInputStream fIn = null;
        try {
            fIn = new FileInputStream(this.pdfFile);
            int trailByteCount = fileLen < (long)this.readTrailBytes ? (int)fileLen : this.readTrailBytes;
            buf = new byte[trailByteCount];
            skipBytes = fileLen - (long)trailByteCount;
            fIn.skip(skipBytes);
            int off = 0;
            while (off < trailByteCount) {
                int readBytes = fIn.read(buf, off, trailByteCount - off);
                if (readBytes < 1) {
                    throw new IOException("No more bytes to read for trailing buffer, but expected: " + (trailByteCount - off));
                }
                off += readBytes;
            }
        }
        finally {
            if (fIn != null) {
                try {
                    fIn.close();
                }
                catch (IOException iOException) {}
            }
        }
        int bufOff = this.lastIndexOf(EOF_MARKER, buf, buf.length);
        if (bufOff < 0) {
            throw new IOException("Missing end of file marker '" + new String(EOF_MARKER) + "'");
        }
        if ((bufOff = this.lastIndexOf(STARTXREF_MARKER, buf, bufOff)) < 0) {
            throw new IOException("Missing 'startxref' marker.");
        }
        return skipBytes + (long)bufOff;
    }

    protected int lastIndexOf(char[] pattern, byte[] buf, int endOff) {
        int lastPatternChOff = pattern.length - 1;
        int bufOff = endOff;
        int patOff = lastPatternChOff;
        char lookupCh = pattern[patOff];
        while (--bufOff >= 0) {
            if (buf[bufOff] == lookupCh) {
                if (--patOff < 0) {
                    return bufOff;
                }
                lookupCh = pattern[patOff];
                continue;
            }
            if (patOff >= lastPatternChOff) continue;
            patOff = lastPatternChOff;
            lookupCh = pattern[patOff];
        }
        return -1;
    }

    protected final void readPattern(char[] pattern) throws IOException {
        this.skipSpaces();
        char[] cArray = pattern;
        int n = pattern.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (this.pdfSource.read() != c) {
                throw new IOException("Expected pattern '" + new String(pattern) + " but missed at character '" + c + "'");
            }
            ++n2;
        }
        this.skipSpaces();
    }

    private OMDictionary getPagesObject() throws IOException {
        if (this.pagesDictionary != null) {
            return this.pagesDictionary;
        }
        OMObject pages = (OMObject)this.document.getCatalog().getItem(OMName.PAGES);
        if (pages == null) {
            throw new IOException("Missing PAGES entry in document catalog.");
        }
        OMBase object = this.parseObjectDynamically(pages, false);
        if (!(object instanceof OMDictionary)) {
            throw new IOException("PAGES not a dictionary object, but: " + object.getClass().getSimpleName());
        }
        this.pagesDictionary = (OMDictionary)object;
        return this.pagesDictionary;
    }

    @Override
    public void parse() throws IOException {
        boolean exceptionOccurred = true;
        try {
            if (!this.initialParseDone) {
                this.initialParse();
            }
            int pageCount = this.getPageNumber();
            if (!this.allPagesParsed) {
                int pNr = 0;
                while (pNr < pageCount) {
                    this.getPage(pNr);
                    ++pNr;
                }
                this.allPagesParsed = true;
                this.document.setDecrypted();
            }
            exceptionOccurred = false;
        }
        finally {
            try {
                this.closeFileStream();
            }
            catch (IOException iOException) {}
            this.deleteTempFile();
            if (exceptionOccurred && this.document != null) {
                try {
                    this.document.close();
                    this.document = null;
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected File getPdfFile() {
        return this.pdfFile;
    }

    protected void deleteTempFile() {
        if (this.isTmpPDFFile) {
            try {
                this.pdfFile.delete();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
    }

    public SecurityHandler getSecurityHandler() {
        return this.securityHandler;
    }

    @Override
    public SMDocument getSMDocument() throws IOException {
        SMDocument pdDocument = super.getSMDocument();
        if (this.securityHandler != null) {
            pdDocument.setSecurityHandler(this.securityHandler);
        }
        return pdDocument;
    }

    public int getPageNumber() throws IOException {
        int pageCount = this.getPagesObject().getInt(OMName.COUNT);
        if (pageCount < 0) {
            throw new IOException("No page number specified.");
        }
        return pageCount;
    }

    public SMPage getPage(int pageNr) throws IOException {
        this.getPagesObject();
        OMArray kids = (OMArray)this.pagesDictionary.getDictionaryObject(OMName.KIDS);
        if (kids == null) {
            throw new IOException("Missing 'Kids' entry in pages dictionary.");
        }
        OMObject pageObj = this.getPageObject(pageNr, kids, 0);
        if (pageObj == null) {
            throw new IOException("Page " + pageNr + " not found.");
        }
        OMDictionary pageDict = (OMDictionary)pageObj.getObject();
        if (this.parseMinimalCatalog && !this.allPagesParsed) {
            OMDictionary resDict = (OMDictionary)pageDict.getDictionaryObject(OMName.RESOURCES);
            this.parseDictObjects(resDict, new OMName[0]);
        }
        return new SMPage(pageDict);
    }

    private OMObject getPageObject(int num, OMArray startKids, int startPageCount) throws IOException {
        int curPageCount = startPageCount;
        for (OMObject obj : startKids) {
            OMDictionary dic;
            int count;
            OMBase base = obj.getObject();
            if (base == null) {
                base = this.parseObjectDynamically(obj, false);
                obj.setObject(base);
            }
            if ((count = (dic = (OMDictionary)base).getInt(OMName.COUNT)) >= 0 && curPageCount + count <= num) {
                curPageCount += count;
                continue;
            }
            OMArray kids = (OMArray)dic.getDictionaryObject(OMName.KIDS);
            if (kids != null) {
                OMObject ans = this.getPageObject(num, kids, curPageCount);
                if (ans == null) continue;
                return ans;
            }
            if (curPageCount == num) {
                return obj;
            }
            ++curPageCount;
        }
        return null;
    }

    private final long getObjectId(OMObject obj) {
        return obj.getObjectNumber().longValue() << 32 | obj.getGenerationNumber().longValue();
    }

    private final void addNewToList(Queue<OMBase> toBeParsedList, Collection<OMBase> newObjects, Set<Long> addedObjects) {
        for (OMBase newObject : newObjects) {
            long objId;
            if (newObject instanceof OMObject && !addedObjects.add(objId = this.getObjectId((OMObject)newObject))) continue;
            toBeParsedList.add(newObject);
        }
    }

    private final void addNewToList(Queue<OMBase> toBeParsedList, OMBase newObject, Set<Long> addedObjects) {
        long objId;
        if (newObject instanceof OMObject && !addedObjects.add(objId = this.getObjectId((OMObject)newObject))) {
            return;
        }
        toBeParsedList.add(newObject);
    }

    /*
     * Unable to fully structure code
     */
    private void parseDictObjects(OMDictionary dict, OMName ... excludeObjects) throws IOException {
        toBeParsedList = new LinkedList<OMBase>();
        objToBeParsed = new TreeMap<Long, List<OMObject>>();
        parsedObjects = new HashSet<Long>();
        addedObjects = new HashSet<Long>();
        if (excludeObjects != null) {
            var10_7 = excludeObjects;
            var9_8 = excludeObjects.length;
            var8_11 = 0;
            while (var8_11 < var9_8) {
                objName = var10_7[var8_11];
                baseObj = dict.getItem(objName);
                if (baseObj instanceof OMObject) {
                    parsedObjects.add(this.getObjectId((OMObject)baseObj));
                }
                ++var8_11;
            }
        }
        this.addNewToList(toBeParsedList, dict.getValues(), addedObjects);
        ** GOTO lbl65
        {
            if (baseObj instanceof OMStream) {
                this.addNewToList(toBeParsedList, ((OMStream)baseObj).getValues(), addedObjects);
            } else if (baseObj instanceof OMDictionary) {
                this.addNewToList(toBeParsedList, ((OMDictionary)baseObj).getValues(), addedObjects);
            } else if (baseObj instanceof OMArray) {
                arrIter = ((OMArray)baseObj).iterator();
                while (arrIter.hasNext()) {
                    this.addNewToList(toBeParsedList, arrIter.next(), addedObjects);
                }
            } else if (baseObj instanceof OMObject) {
                obj = (OMObject)baseObj;
                objId = this.getObjectId(obj);
                objKey = new OMObjectKey(obj.getObjectNumber().intValue(), obj.getGenerationNumber().intValue());
                if (!parsedObjects.contains(objId)) {
                    fileOffset = this.xrefTrailerResolver.getXrefTable().get(objKey);
                    if (fileOffset != null) {
                        if (fileOffset > 0L) {
                            objToBeParsed.put(fileOffset, Collections.singletonList(obj));
                        } else {
                            fileOffset = this.xrefTrailerResolver.getXrefTable().get(new OMObjectKey(-fileOffset.longValue(), 0L));
                            if (fileOffset == null || fileOffset <= 0L) {
                                throw new IOException("Invalid object stream xref object reference: " + fileOffset);
                            }
                            stmObjects = (ArrayList<OMObject>)objToBeParsed.get(fileOffset);
                            if (stmObjects == null) {
                                stmObjects = new ArrayList<OMObject>();
                                objToBeParsed.put(fileOffset, stmObjects);
                            }
                            stmObjects.add(obj);
                        }
                    } else {
                        pdfObject = this.document.getObjectFromPool(objKey);
                        pdfObject.setObject(OMNull.NULL);
                    }
                }
            }
            do {
                if ((baseObj = (OMBase)toBeParsedList.poll()) != null) continue block1;
                if (objToBeParsed.isEmpty()) break block1;
                for (OMObject obj : (List)objToBeParsed.remove(objToBeParsed.firstKey())) {
                    parsedObj = this.parseObjectDynamically(obj, false);
                    obj.setObject(parsedObj);
                    this.addNewToList(toBeParsedList, parsedObj, addedObjects);
                    parsedObjects.add(this.getObjectId(obj));
                }
lbl65:
                // 2 sources

            } while (!toBeParsedList.isEmpty() || !objToBeParsed.isEmpty());
        }
    }

    protected final OMBase parseObjectDynamically(OMObject obj, boolean requireExistingNotCompressedObj) throws IOException {
        return this.parseObjectDynamically(obj.getObjectNumber().intValue(), obj.getGenerationNumber().intValue(), requireExistingNotCompressedObj);
    }

    protected OMBase parseObjectDynamically(int objNr, int objGenNr, boolean requireExistingNotCompressedObj) throws IOException {
        OMObjectKey objKey = new OMObjectKey(objNr, objGenNr);
        OMObject pdfObject = this.document.getObjectFromPool(objKey);
        if (pdfObject.getObject() == null) {
            Long offsetOrObjstmObNr = this.xrefTrailerResolver.getXrefTable().get(objKey);
            if (requireExistingNotCompressedObj && (offsetOrObjstmObNr == null || offsetOrObjstmObNr <= 0L)) {
                throw new IOException("Object must be defined and must not be compressed object: " + objKey.getNumber() + ":" + objKey.getGeneration());
            }
            if (offsetOrObjstmObNr == null) {
                pdfObject.setObject(OMNull.NULL);
            } else if (offsetOrObjstmObNr > 0L) {
                this.setPdfSource(offsetOrObjstmObNr);
                long readObjNr = this.readObjectNumber();
                long readObjGen = this.readGenerationNumber();
                this.readPattern(OBJ_MARKER);
                if (readObjNr != objKey.getNumber() || readObjGen != objKey.getGeneration()) {
                    throw new IOException("XREF for " + objKey.getNumber() + ":" + objKey.getGeneration() + " points to wrong object: " + readObjNr + ":" + readObjGen);
                }
                this.skipSpaces();
                OMBase pb = this.parseDirObject();
                String endObjectKey = this.readString();
                if (endObjectKey.equals("stream")) {
                    OMStream stream;
                    this.pdfSource.unread(endObjectKey.getBytes("ISO-8859-1"));
                    this.pdfSource.unread(32);
                    if (pb instanceof OMDictionary) {
                        stream = this.parseOMStream((OMDictionary)pb, this.getDocument().getScratchFile());
                        if (this.securityHandler != null) {
                            try {
                                this.securityHandler.decryptStream(stream, objNr, objGenNr);
                            }
                            catch (CryptographyException ce) {
                                throw new IOException("Error decrypting stream object " + objNr + ": " + ce.getMessage());
                            }
                        }
                    } else {
                        throw new IOException("Stream not preceded by dictionary (offset: " + offsetOrObjstmObNr + ").");
                    }
                    pb = stream;
                    this.skipSpaces();
                    endObjectKey = this.readLine();
                    if (!endObjectKey.startsWith("endobj") && endObjectKey.startsWith("endstream") && (endObjectKey = endObjectKey.substring(9).trim()).length() == 0) {
                        endObjectKey = this.readLine();
                    }
                } else if (this.securityHandler != null) {
                    if (pb instanceof OMString) {
                        this.decrypt((OMString)pb, objNr, objGenNr);
                    } else if (pb instanceof OMDictionary) {
                        for (Map.Entry<OMName, OMBase> entry : ((OMDictionary)pb).entrySet()) {
                            if (!(entry.getValue() instanceof OMString)) continue;
                            this.decrypt((OMString)entry.getValue(), objNr, objGenNr);
                        }
                    } else if (pb instanceof OMArray) {
                        OMArray array = (OMArray)pb;
                        int aIdx = 0;
                        int len = array.size();
                        while (aIdx < len) {
                            if (array.get(aIdx) instanceof OMString) {
                                this.decrypt((OMString)array.get(aIdx), objNr, objGenNr);
                            }
                            ++aIdx;
                        }
                    }
                }
                pdfObject.setObject(pb);
                if (!endObjectKey.startsWith("endobj")) {
                    throw new IOException("Object (" + readObjNr + ":" + readObjGen + ") at offset " + offsetOrObjstmObNr + " does not end with 'endobj'.");
                }
                this.releasePdfSourceInputStream();
            } else {
                int objstmObjNr = (int)(-offsetOrObjstmObNr.longValue());
                OMBase objstmBaseObj = this.parseObjectDynamically(objstmObjNr, 0, true);
                if (objstmBaseObj instanceof OMStream) {
                    PDFObjectStreamParser parser = new PDFObjectStreamParser((OMStream)objstmBaseObj, this.document, this.forceParsing);
                    parser.parse();
                    Set<Long> refObjNrs = this.xrefTrailerResolver.getContainedObjectNumbers(objstmObjNr);
                    for (OMObject next : parser.getObjects()) {
                        OMObjectKey stmObjKey = new OMObjectKey(next);
                        if (!refObjNrs.contains(stmObjKey.getNumber())) continue;
                        OMObject stmObj = this.document.getObjectFromPool(stmObjKey);
                        stmObj.setObject(next.getObject());
                    }
                }
            }
        }
        return pdfObject.getObject();
    }

    protected final void decrypt(OMString str, long objNr, long objGenNr) throws IOException {
        try {
            this.securityHandler.decryptString(str, objNr, objGenNr, true);
        }
        catch (CryptographyException ce) {
            throw new IOException("Error decrypting string: " + ce.getMessage());
        }
    }

    private OMNumber getLength(OMBase lengthBaseObj) throws IOException {
        OMNumber retVal;
        block10: {
            if (lengthBaseObj == null) {
                return null;
            }
            if (this.inGetLength) {
                throw new IOException("Loop while reading length from " + lengthBaseObj);
            }
            retVal = null;
            try {
                this.inGetLength = true;
                if (lengthBaseObj instanceof OMNumber) {
                    retVal = (OMNumber)lengthBaseObj;
                    break block10;
                }
                if (lengthBaseObj instanceof OMObject) {
                    OMObject lengthObj = (OMObject)lengthBaseObj;
                    if (lengthObj.getObject() == null) {
                        long curFileOffset = this.getPdfSourceOffset();
                        this.releasePdfSourceInputStream();
                        this.parseObjectDynamically(lengthObj, true);
                        this.setPdfSource(curFileOffset);
                        if (lengthObj.getObject() == null) {
                            throw new IOException("Length object content was not read.");
                        }
                    }
                    if (!(lengthObj.getObject() instanceof OMNumber)) {
                        throw new IOException("Wrong type of referenced length object " + lengthObj + ": " + lengthObj.getObject().getClass().getSimpleName());
                    }
                    retVal = (OMNumber)lengthObj.getObject();
                    break block10;
                }
                throw new IOException("Wrong type of length object: " + lengthBaseObj.getClass().getSimpleName());
            }
            finally {
                this.inGetLength = false;
            }
        }
        return retVal;
    }

    @Override
    protected OMStream parseOMStream(OMDictionary dic, RandomAccess file) throws IOException {
        OMStream stream = new OMStream(dic, file);
        OutputStream out = null;
        try {
            String endStream;
            OMNumber streamLengthObj;
            this.readString();
            int whitespace = this.pdfSource.read();
            while (whitespace == 32) {
                whitespace = this.pdfSource.read();
            }
            if (whitespace == 13) {
                whitespace = this.pdfSource.read();
                if (whitespace != 10) {
                    this.pdfSource.unread(whitespace);
                }
            } else if (whitespace != 10) {
                this.pdfSource.unread(whitespace);
            }
            if ((streamLengthObj = this.getLength(dic.getItem(OMName.LENGTH))) == null) {
                throw new IOException("Missing length for stream.");
            }
            out = stream.createFilteredStream(streamLengthObj);
            long remainBytes = streamLengthObj.longValue();
            int bytesRead = 0;
            boolean unexpectedEndOfStream = false;
            if (remainBytes == 35090L) {
                System.out.println();
            }
            while (remainBytes > 0L) {
                int readBytes = this.pdfSource.read(this.streamCopyBuf, 0, remainBytes > 8192L ? 8192 : (int)remainBytes);
                if (readBytes <= 0) {
                    unexpectedEndOfStream = true;
                    break;
                }
                out.write(this.streamCopyBuf, 0, readBytes);
                remainBytes -= (long)readBytes;
                bytesRead += readBytes;
            }
            if (unexpectedEndOfStream) {
                this.pdfSource.unread(bytesRead);
                out = stream.createFilteredStream(streamLengthObj);
                this.readUntilEndStream(out);
            }
            if (!(endStream = this.readString()).equals("endstream")) {
                throw new IOException("Error reading stream using length value. Expected='endstream' actual='" + endStream + "' ");
            }
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return stream;
    }

    private void readUntilEndStream(OutputStream out) throws IOException {
        int bufSize;
        int charMatchCount = 0;
        byte[] keyw = ENDSTREAM;
        int quickTestOffset = 5;
        while ((bufSize = this.pdfSource.read(this.streamCopyBuf, charMatchCount, 8192 - charMatchCount)) > 0) {
            int bIdx = charMatchCount;
            int maxQuicktestIdx = (bufSize += charMatchCount) - 5;
            while (bIdx < bufSize) {
                byte ch;
                int quickTestIdx;
                if (charMatchCount == 0 && (quickTestIdx = bIdx + 5) < maxQuicktestIdx && ((ch = this.streamCopyBuf[quickTestIdx]) > 116 || ch < 97)) {
                    bIdx = quickTestIdx;
                } else {
                    ch = this.streamCopyBuf[bIdx];
                    if (ch == keyw[charMatchCount]) {
                        if (++charMatchCount == keyw.length) {
                            ++bIdx;
                            break;
                        }
                    } else if (charMatchCount == 3 && ch == ENDOBJ[charMatchCount]) {
                        keyw = ENDOBJ;
                        ++charMatchCount;
                    } else {
                        charMatchCount = ch == 101 ? 1 : (ch == 110 && charMatchCount == 7 ? 2 : 0);
                        keyw = ENDSTREAM;
                    }
                }
                ++bIdx;
            }
            int contentBytes = Math.max(0, bIdx - charMatchCount);
            if (contentBytes > 0) {
                out.write(this.streamCopyBuf, 0, contentBytes);
            }
            if (charMatchCount == keyw.length) {
                this.pdfSource.unread(this.streamCopyBuf, contentBytes, bufSize - contentBytes);
                break;
            }
            System.arraycopy(keyw, 0, this.streamCopyBuf, 0, charMatchCount);
        }
    }
}

