/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.pdfparser;

import com.plpdf.io.RandomAccess;
import com.plpdf.io.RandomAccessFile;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMDocument;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMObject;
import com.plpdf.om.OMString;
import com.plpdf.om.OMUnread;
import com.plpdf.pdfparser.BaseParser;
import com.plpdf.persistence.util.OMObjectKey;
import com.plpdf.smmodel.ConformingSMDocument;
import com.plpdf.smmodel.SMDocument;
import com.plpdf.smmodel.common.XrefEntry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ConformingPDFParser
extends BaseParser {
    protected RandomAccess inputFile;
    List<XrefEntry> xrefEntries;
    private long currentOffset;
    private ConformingSMDocument doc = null;
    private boolean throwNonConformingException = true;
    private boolean recursivlyRead = true;

    public ConformingPDFParser(File inputFile) throws IOException {
        this.inputFile = new RandomAccessFile(inputFile, "r");
    }

    public void parse() throws IOException {
        long xRefTableLocation;
        this.document = new OMDocument();
        this.doc = new ConformingSMDocument(this.document);
        this.currentOffset = this.inputFile.length() - 1L;
        this.currentOffset = xRefTableLocation = this.parseTrailerInformation();
        this.parseXrefTable();
        boolean oldValue = this.recursivlyRead;
        this.recursivlyRead = false;
        List<OMObjectKey> keys = this.doc.getObjectKeysFromPool();
        for (OMObjectKey key : keys) {
            this.getObject(key.getNumber(), key.getGeneration());
        }
        this.recursivlyRead = oldValue;
    }

    public OMDocument getDocument() throws IOException {
        if (this.document == null) {
            throw new IOException("You must call parse() before calling getDocument()");
        }
        return this.document;
    }

    public SMDocument getPDDocument() throws IOException {
        return this.doc;
    }

    private boolean parseXrefTable() throws IOException {
        String currentLine = this.readLine();
        if (this.throwNonConformingException && !"xref".equals(currentLine)) {
            throw new AssertionError((Object)("xref table not found.\nExpected: xref\nFound: " + currentLine));
        }
        int objectNumber = this.readInt();
        int entries = this.readInt();
        this.xrefEntries = new ArrayList<XrefEntry>(entries);
        int i = 0;
        while (i < entries) {
            this.xrefEntries.add(new XrefEntry(objectNumber++, this.readInt(), this.readInt(), this.readLine()));
            ++i;
        }
        return true;
    }

    protected long parseTrailerInformation() throws IOException, NumberFormatException {
        long xrefLocation = -1L;
        this.consumeWhitespaceBackwards();
        String currentLine = this.readLineBackwards();
        if (this.throwNonConformingException && !"%%EOF".equals(currentLine)) {
            throw new AssertionError((Object)("Invalid EOF marker.\nExpected: %%EOF\nFound: " + currentLine));
        }
        xrefLocation = this.readLongBackwards();
        currentLine = this.readLineBackwards();
        if (this.throwNonConformingException && !"startxref".equals(currentLine)) {
            throw new AssertionError((Object)("Invalid trailer.\nExpected: startxref\nFound: " + currentLine));
        }
        this.document.setTrailer(this.readDictionaryBackwards());
        this.consumeWhitespaceBackwards();
        currentLine = this.readLineBackwards();
        if (this.throwNonConformingException && !"trailer".equals(currentLine)) {
            throw new AssertionError((Object)("Invalid trailer.\nExpected: trailer\nFound: " + currentLine));
        }
        return xrefLocation;
    }

    protected byte readByteBackwards() throws IOException {
        this.inputFile.seek(this.currentOffset);
        byte singleByte = (byte)this.inputFile.read();
        --this.currentOffset;
        return singleByte;
    }

    protected byte readByte() throws IOException {
        this.inputFile.seek(this.currentOffset);
        byte singleByte = (byte)this.inputFile.read();
        ++this.currentOffset;
        return singleByte;
    }

    protected String readBackwardUntilWhitespace() throws IOException {
        StringBuilder sb = new StringBuilder();
        byte singleByte = this.readByteBackwards();
        while (!this.isWhitespace(singleByte)) {
            sb.insert(0, (char)singleByte);
            singleByte = this.readByteBackwards();
        }
        return sb.toString();
    }

    /*
     * Unable to fully structure code
     */
    protected byte consumeWhitespaceBackwards() throws IOException {
        this.inputFile.seek(this.currentOffset);
        singleByte = (byte)this.inputFile.read();
        if (this.isWhitespace(singleByte)) ** GOTO lbl6
        return singleByte;
lbl-1000:
        // 1 sources

        {
            singleByte = this.readByteBackwards();
lbl6:
            // 2 sources

            ** while (this.isWhitespace((int)singleByte))
        }
lbl7:
        // 1 sources

        ++this.currentOffset;
        return singleByte;
    }

    /*
     * Unable to fully structure code
     */
    protected byte consumeWhitespace() throws IOException {
        this.inputFile.seek(this.currentOffset);
        singleByte = (byte)this.inputFile.read();
        if (this.isWhitespace(singleByte)) ** GOTO lbl6
        return singleByte;
lbl-1000:
        // 1 sources

        {
            singleByte = this.readByte();
lbl6:
            // 2 sources

            ** while (this.isWhitespace((int)singleByte))
        }
lbl7:
        // 1 sources

        --this.currentOffset;
        return singleByte;
    }

    protected long readLongBackwards() throws IOException, NumberFormatException {
        StringBuilder sb = new StringBuilder();
        this.consumeWhitespaceBackwards();
        byte singleByte = this.readByteBackwards();
        while (!this.isWhitespace(singleByte)) {
            sb.insert(0, (char)singleByte);
            singleByte = this.readByteBackwards();
        }
        if (sb.length() == 0) {
            throw new AssertionError((Object)("Number not found.  Expected number at offset: " + this.currentOffset));
        }
        return Long.parseLong(sb.toString());
    }

    protected int readInt() throws IOException {
        StringBuilder sb = new StringBuilder();
        this.consumeWhitespace();
        byte singleByte = this.readByte();
        while (!this.isWhitespace(singleByte)) {
            sb.append((char)singleByte);
            singleByte = this.readByte();
        }
        if (sb.length() == 0) {
            throw new AssertionError((Object)("Number not found.  Expected number at offset: " + this.currentOffset));
        }
        return Integer.parseInt(sb.toString());
    }

    protected OMNumber readNumber() throws IOException {
        StringBuilder sb = new StringBuilder();
        this.consumeWhitespace();
        byte singleByte = this.readByte();
        while (!this.isWhitespace(singleByte)) {
            sb.append((char)singleByte);
            singleByte = this.readByte();
        }
        if (sb.length() == 0) {
            throw new AssertionError((Object)("Number not found.  Expected number at offset: " + this.currentOffset));
        }
        return this.parseNumber(sb.toString());
    }

    protected OMNumber parseNumber(String number) throws IOException {
        if (number.matches("^[0-9]+$")) {
            return OMInteger.get(number);
        }
        return new OMFloat(Float.parseFloat(number));
    }

    protected OMBase processCosObject(String string) throws IOException {
        if (string != null && string.endsWith(">")) {
            return OMString.createFromHexString(string.replaceAll("^<", "").replaceAll(">$", ""));
        }
        return null;
    }

    protected OMBase readObjectBackwards() throws IOException {
        OMBase obj = null;
        this.consumeWhitespaceBackwards();
        String lastSection = this.readBackwardUntilWhitespace();
        if ("R".equals(lastSection)) {
            long gen = this.readLongBackwards();
            long number = this.readLongBackwards();
            this.doc.putObjectInPool(new OMUnread(), number, gen);
            obj = new OMUnread(number, gen, this);
        } else {
            if (">>".equals(lastSection)) {
                throw new RuntimeException("Not yet implemented");
            }
            if (lastSection != null && lastSection.endsWith("]")) {
                OMArray array = new OMArray();
                lastSection = lastSection.replaceAll("]$", "");
                while (!lastSection.startsWith("[")) {
                    if (lastSection.matches("^\\s*<.*>\\s*$")) {
                        array.add(OMString.createFromHexString(lastSection.replaceAll("^\\s*<", "").replaceAll(">\\s*$", "")));
                    }
                    lastSection = this.readBackwardUntilWhitespace();
                }
                if ((lastSection = lastSection.replaceAll("^\\[", "")).matches("^\\s*<.*>\\s*$")) {
                    array.add(OMString.createFromHexString(lastSection.replaceAll("^\\s*<", "").replaceAll(">\\s*$", "")));
                }
                obj = array;
            } else if (lastSection != null && lastSection.endsWith(">")) {
                obj = this.processCosObject(lastSection);
            } else {
                try {
                    Long.parseLong(lastSection);
                    obj = OMNumber.get(lastSection);
                }
                catch (NumberFormatException e) {
                    throw new RuntimeException("Not yet implemented");
                }
            }
        }
        return obj;
    }

    protected OMName readNameBackwards() throws IOException {
        String name = this.readBackwardUntilWhitespace();
        name = name.replaceAll("^/", "");
        return OMName.getPDFName(name);
    }

    public OMBase getObject(long objectNumber, long generation) throws IOException {
        XrefEntry entry = this.xrefEntries.get((int)objectNumber);
        this.currentOffset = entry.getByteOffset();
        return this.readObject(objectNumber, generation);
    }

    public OMBase readObject(long objectNumber, long generation) throws IOException {
        OMBase obj;
        if (this.document != null && this.recursivlyRead && (obj = this.doc.getObjectFromPool(objectNumber, generation)) != null) {
            return obj;
        }
        int actualObjectNumber = this.readInt();
        if (objectNumber != (long)actualObjectNumber && this.throwNonConformingException) {
            throw new AssertionError((Object)("Object numer expected was " + objectNumber + " but actual was " + actualObjectNumber));
        }
        this.consumeWhitespace();
        int actualGeneration = this.readInt();
        if (generation != (long)actualGeneration && this.throwNonConformingException) {
            throw new AssertionError((Object)("Generation expected was " + generation + " but actual was " + actualGeneration));
        }
        this.consumeWhitespace();
        String obj2 = this.readWord();
        if (!"obj".equals(obj2) && this.throwNonConformingException) {
            throw new AssertionError((Object)("Expected keyword 'obj' but found " + obj2));
        }
        this.doc.putObjectInPool(new OMObject(null), objectNumber, generation);
        OMBase object = this.readObject();
        this.doc.putObjectInPool(object, objectNumber, generation);
        return object;
    }

    protected OMBase readObject() throws IOException {
        this.consumeWhitespace();
        String string = this.readWord();
        if (string.startsWith("<<")) {
            OMDictionary dictionary = new OMDictionary();
            boolean atEndOfDictionary = false;
            if ("".equals(string = string.replaceAll("^<<", "")) || string.matches("^\\w$")) {
                string = this.readWord().trim();
            }
            while (!atEndOfDictionary) {
                OMName name = OMName.getPDFName(string);
                OMBase object = this.readObject();
                dictionary.setItem(name, object);
                byte singleByte = this.consumeWhitespace();
                if (singleByte == 62) {
                    this.readByte();
                    atEndOfDictionary = true;
                }
                if (atEndOfDictionary) continue;
                string = this.readWord().trim();
            }
            return dictionary;
        }
        if (string.startsWith("/")) {
            OMName name = OMName.getPDFName(string);
            return name;
        }
        if (string.startsWith("-")) {
            return this.parseNumber(string);
        }
        if (string.charAt(0) >= '0' && string.charAt(0) <= '9') {
            long tempOffset = this.currentOffset;
            this.consumeWhitespace();
            String tempString = this.readWord();
            if (tempString.matches("^[0-9]+$")) {
                tempString = this.readWord();
                if (!"R".equals(tempString)) {
                    this.currentOffset = tempOffset;
                    return this.parseNumber(string);
                }
            } else {
                this.currentOffset = tempOffset;
                return this.parseNumber(string);
            }
            this.currentOffset = tempOffset;
            int number = Integer.parseInt(string);
            int gen = this.readInt();
            String r = this.readWord();
            if (!"R".equals(r) && this.throwNonConformingException) {
                throw new AssertionError((Object)("Expected keyword 'R' but found " + r));
            }
            if (this.recursivlyRead) {
                long tempLocation = this.currentOffset;
                this.currentOffset = this.xrefEntries.get(number).getByteOffset();
                OMBase returnValue = this.readObject(number, gen);
                this.currentOffset = tempLocation;
                return returnValue;
            }
            OMObject obj = new OMObject(new OMUnread());
            obj.setObjectNumber(OMInteger.get(number));
            obj.setGenerationNumber(OMInteger.get(gen));
            return obj;
        }
        if (string.startsWith("]")) {
            if ("]".equals(string)) {
                return null;
            }
            int oldLength = string.length();
            this.currentOffset -= (long)oldLength;
            return null;
        }
        if (string.startsWith("[")) {
            int oldLength = string.length();
            string = "[";
            this.currentOffset -= (long)(oldLength - string.length() + 1);
            OMArray array = new OMArray();
            OMBase object = this.readObject();
            while (object != null) {
                array.add(object);
                object = this.readObject();
            }
            return array;
        }
        if (string.startsWith("(")) {
            StringBuilder sb = new StringBuilder(string.substring(1));
            byte singleByte = this.readByte();
            while (singleByte != 41) {
                sb.append((char)singleByte);
                singleByte = this.readByte();
            }
            return new OMString(sb.toString());
        }
        throw new RuntimeException("Not yet implemented: " + string + " loation=" + this.currentOffset);
    }

    protected String readString() throws IOException {
        this.consumeWhitespace();
        StringBuilder buffer = new StringBuilder();
        int c = this.pdfSource.read();
        while (!this.isEndOfName((char)c) && !this.isClosing(c) && c != -1) {
            buffer.append((char)c);
            c = this.pdfSource.read();
        }
        if (c != -1) {
            this.pdfSource.unread(c);
        }
        return buffer.toString();
    }

    protected OMDictionary readDictionaryBackwards() throws IOException {
        OMDictionary dict = new OMDictionary();
        this.consumeWhitespaceBackwards();
        byte singleByte = this.readByteBackwards();
        if (this.throwNonConformingException && singleByte != 62) {
            throw new AssertionError((Object)"");
        }
        singleByte = this.readByteBackwards();
        if (this.throwNonConformingException && singleByte != 62) {
            throw new AssertionError((Object)"");
        }
        boolean atEndOfDictionary = false;
        singleByte = this.consumeWhitespaceBackwards();
        if (singleByte == 60) {
            this.inputFile.seek(this.currentOffset - 1L);
            atEndOfDictionary = (byte)this.inputFile.read() == 60;
        }
        OMDictionary backwardsDictionary = new OMDictionary();
        while (!atEndOfDictionary) {
            OMBase object = this.readObjectBackwards();
            OMName name = this.readNameBackwards();
            backwardsDictionary.setItem(name, object);
            singleByte = this.consumeWhitespaceBackwards();
            if (singleByte != 60) continue;
            this.inputFile.seek(this.currentOffset - 1L);
            boolean bl = atEndOfDictionary = (byte)this.inputFile.read() == 60;
        }
        Set<OMName> backwardsKeys = backwardsDictionary.keySet();
        int i = backwardsKeys.size() - 1;
        while (i >= 0) {
            dict.setItem((OMName)backwardsKeys.toArray()[i], backwardsDictionary.getItem((OMName)backwardsKeys.toArray()[i]));
            --i;
        }
        this.readByteBackwards();
        this.readByteBackwards();
        return dict;
    }

    protected String readLineBackwards() throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean endOfObject = false;
        do {
            byte singleByte;
            if ((singleByte = this.readByteBackwards()) == 10) {
                this.inputFile.seek(this.currentOffset);
                if ((byte)this.inputFile.read() == 13) {
                    --this.currentOffset;
                }
                endOfObject = true;
                continue;
            }
            if (singleByte == 13) {
                endOfObject = true;
                continue;
            }
            sb.insert(0, (char)singleByte);
        } while (!endOfObject);
        return sb.toString();
    }

    protected String readLine() throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean endOfLine = false;
        do {
            byte singleByte;
            if ((singleByte = this.readByte()) == 10) {
                this.inputFile.seek(this.currentOffset);
                if ((byte)this.inputFile.read() == 13) {
                    ++this.currentOffset;
                }
                endOfLine = true;
                continue;
            }
            if (singleByte == 13) {
                endOfLine = true;
                continue;
            }
            sb.append((char)singleByte);
        } while (!endOfLine);
        return sb.toString();
    }

    protected String readWord() throws IOException {
        StringBuilder sb = new StringBuilder();
        boolean stop = true;
        do {
            byte singleByte;
            if (!(stop = this.isWhitespace(singleByte = this.readByte())) && sb.length() > 0) {
                boolean bl = stop = singleByte == 47 || singleByte == 91 || singleByte == 93 || singleByte == 62 && !">".equals(sb.toString());
                if (stop) {
                    --this.currentOffset;
                }
            }
            if (stop) continue;
            sb.append((char)singleByte);
        } while (!stop);
        return sb.toString();
    }

    public boolean isRecursivlyRead() {
        return this.recursivlyRead;
    }

    public void setRecursivlyRead(boolean recursivlyRead) {
        this.recursivlyRead = recursivlyRead;
    }
}

