/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.om;

import com.plpdf.charsets.KOI8UCharset;
import com.plpdf.encoding.PdfDocEncoding;
import com.plpdf.exceptions.OMVisitorException;
import com.plpdf.exceptions.PlpdfException;
import com.plpdf.om.IOMVisitor;
import com.plpdf.om.OMBase;
import com.plpdf.persistence.util.OMHEXTable;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class OMString
extends OMBase {
    private static final String CLASS_NAME = OMString.class.getName();
    public static final byte[] STRING_OPEN = new byte[]{40};
    public static final byte[] STRING_CLOSE = new byte[]{41};
    public static final byte[] HEX_STRING_OPEN = new byte[]{60};
    public static final byte[] HEX_STRING_CLOSE = new byte[]{62};
    public static final byte[] ESCAPE = new byte[]{92};
    public static final byte[] CR_ESCAPE = new byte[]{92, 114};
    public static final byte[] LF_ESCAPE = new byte[]{92, 110};
    public static final byte[] HT_ESCAPE = new byte[]{92, 116};
    public static final byte[] BS_ESCAPE = new byte[]{92, 98};
    public static final byte[] FF_ESCAPE = new byte[]{92, 102};
    private ByteArrayOutputStream out = null;
    private String str = null;
    private boolean forceHexForm = false;
    private boolean isDictionary = false;

    public OMString() {
        this.out = new ByteArrayOutputStream();
    }

    public OMString(boolean isDictionaryValue) {
        this();
        this.isDictionary = isDictionaryValue;
    }

    public OMString(String value) {
        try {
            boolean unicode16 = false;
            char[] chars = value.toCharArray();
            int length = chars.length;
            int i = 0;
            while (i < length) {
                if (chars[i] > '\u00ff') {
                    unicode16 = true;
                    break;
                }
                ++i;
            }
            if (unicode16) {
                byte[] data = value.getBytes("UTF-16BE");
                this.out = new ByteArrayOutputStream(data.length + 2);
                this.out.write(254);
                this.out.write(255);
                this.out.write(data);
            } else {
                byte[] data = value.getBytes("ISO-8859-1");
                this.out = new ByteArrayOutputStream(data.length);
                this.out.write(data);
            }
        }
        catch (IOException ignore) {
            ignore.printStackTrace();
        }
    }

    public OMString(byte[] value) {
        try {
            this.out = new ByteArrayOutputStream(value.length);
            this.out.write(value);
        }
        catch (IOException ignore) {
            ignore.printStackTrace();
        }
    }

    public void setForceLiteralForm(boolean v) {
        this.forceHexForm = !v;
    }

    public void setForceHexForm(boolean v) {
        this.forceHexForm = v;
    }

    public static OMString createFromHexString(String hex) throws IOException {
        return OMString.createFromHexString(hex, false);
    }

    public static OMString createFromHexString(String hex, boolean force) throws IOException {
        OMString retval = new OMString();
        StringBuilder hexBuffer = new StringBuilder(hex.trim());
        if (hexBuffer.length() % 2 != 0) {
            hexBuffer.append('0');
        }
        int length = hexBuffer.length();
        int i = 0;
        while (i < length) {
            try {
                retval.append(Integer.parseInt(hexBuffer.substring(i, i + 2), 16));
            }
            catch (NumberFormatException e) {
                if (force) {
                    retval.append(63);
                }
                IOException exception = new IOException("Invalid hex string: " + hex);
                exception.initCause(e);
                throw exception;
            }
            i += 2;
        }
        return retval;
    }

    public String getHexString() {
        StringBuilder retval = new StringBuilder(this.out.size() * 2);
        byte[] data = this.getBytes();
        int length = data.length;
        int i = 0;
        while (i < length) {
            retval.append(OMHEXTable.HEX_TABLE[(data[i] + 256) % 256]);
            ++i;
        }
        return retval.toString();
    }

    public String getString() {
        String retval;
        if (this.str != null) {
            return this.str;
        }
        String encoding = "ISO-8859-1";
        byte[] data = this.getBytes();
        int start = 0;
        if (data.length > 2) {
            if (data[0] == -1 && data[1] == -2) {
                encoding = "UTF-16LE";
                start = 2;
            } else if (data[0] == -2 && data[1] == -1) {
                encoding = "UTF-16BE";
                start = 2;
            }
        }
        try {
            if (this.isDictionary && encoding.equals("ISO-8859-1")) {
                byte[] tmp = this.getBytes();
                PdfDocEncoding pde = new PdfDocEncoding();
                StringBuilder sb = new StringBuilder(tmp.length);
                byte[] byArray = tmp;
                int n = tmp.length;
                int n2 = 0;
                while (n2 < n) {
                    byte b = byArray[n2];
                    String character = pde.getCharacter((b + 256) % 256);
                    if (character != null) {
                        sb.append(character);
                    }
                    ++n2;
                }
                retval = sb.toString();
            } else {
                retval = new String(this.getBytes(), start, data.length - start, encoding);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            retval = new String(this.getBytes());
        }
        this.str = retval;
        return retval;
    }

    public void append(byte[] data) throws IOException {
        this.out.write(data);
        this.str = null;
    }

    public void append(int in) throws IOException {
        this.out.write(in);
        this.str = null;
    }

    public void reset() {
        this.out.reset();
        this.str = null;
    }

    public byte[] getBytes() {
        return this.out.toByteArray();
    }

    public String toString() {
        return "OMString{" + this.getString() + "}";
    }

    public void writePDF(OutputStream output) throws IOException {
        byte[] bytes = this.getBytes();
        int length = bytes.length;
        output.write(HEX_STRING_OPEN);
        int i = 0;
        while (i < length) {
            output.write(OMHEXTable.TABLE[(bytes[i] + 256) % 256]);
            ++i;
        }
        output.write(HEX_STRING_CLOSE);
    }

    public Object accept(IOMVisitor visitor) throws OMVisitorException {
        return visitor.visitFromString(this);
    }

    public boolean equals(Object obj) {
        if (obj instanceof OMString) {
            OMString strObj = (OMString)obj;
            return this.getString().equals(strObj.getString()) && this.forceHexForm == strObj.forceHexForm;
        }
        return false;
    }

    public int hashCode() {
        int result = this.getString().hashCode();
        return result += this.forceHexForm ? 17 : 0;
    }

    public OMString(String value, String encoding) throws IOException, PlpdfException {
        if (encoding.equalsIgnoreCase("utf-16")) {
            try {
                byte[] data = value.getBytes("UTF-16BE");
                this.out = new ByteArrayOutputStream(data.length + 2);
                this.out.write(254);
                this.out.write(255);
                this.out.write(data);
            }
            catch (UnsupportedEncodingException uee) {
                throw new PlpdfException(CLASS_NAME, "UnsupportedEncoding", new String[]{"UTF-16BE"});
            }
        }
        if (encoding.equalsIgnoreCase("KOI8-U")) {
            KOI8UCharset charset = new KOI8UCharset();
            byte[] data = charset.encode(value).array();
            this.out = new ByteArrayOutputStream(data.length);
            this.out.write(data);
        } else {
            String newEncoding = String.valueOf(encoding.substring(0, 1).toUpperCase()) + encoding.substring(1);
            try {
                byte[] data = value.getBytes(newEncoding);
                this.out = new ByteArrayOutputStream(data.length);
                this.out.write(data);
            }
            catch (UnsupportedEncodingException uee) {
                throw new PlpdfException(CLASS_NAME, "UnsupportedEncoding", new String[]{newEncoding});
            }
        }
    }

    public String toStringBytes() {
        return new String(this.getBytes());
    }
}

