/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.om;

import com.plpdf.exceptions.CryptographyException;
import com.plpdf.exceptions.OMVisitorException;
import com.plpdf.filter.Filter;
import com.plpdf.filter.FilterManager;
import com.plpdf.io.RandomAccess;
import com.plpdf.io.RandomAccessFileInputStream;
import com.plpdf.io.RandomAccessFileOutputStream;
import com.plpdf.om.IOMVisitor;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.pdfparser.PDFStreamParser;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMStream
extends OMDictionary {
    private static final int BUFFER_SIZE = 16384;
    private RandomAccess file;
    private RandomAccessFileOutputStream filteredStream;
    private RandomAccessFileOutputStream unFilteredStream;

    public OMStream(RandomAccess storage) {
        this.file = storage;
    }

    public OMStream(OMDictionary dictionary, RandomAccess storage) {
        super(dictionary);
        this.file = storage;
    }

    public void replaceWithStream(OMStream stream) {
        this.clear();
        this.addAll(stream);
        this.file = stream.file;
        this.filteredStream = stream.filteredStream;
        this.unFilteredStream = stream.unFilteredStream;
    }

    public RandomAccess getScratchFile() {
        return this.file;
    }

    public List<Object> getStreamTokens() throws IOException, CryptographyException {
        PDFStreamParser parser = new PDFStreamParser(this);
        parser.parse();
        return parser.getTokens();
    }

    public InputStream getFilteredStream() throws IOException {
        if (this.filteredStream == null) {
            this.doEncode();
        }
        long position = this.filteredStream.getPosition();
        long length = this.filteredStream.getLength();
        RandomAccessFileInputStream input = new RandomAccessFileInputStream(this.file, position, length);
        return new BufferedInputStream(input, 16384);
    }

    public long getFilteredLength() throws IOException {
        if (this.filteredStream == null) {
            this.doEncode();
        }
        return this.filteredStream.getLength();
    }

    public InputStream getUnfilteredStream() throws IOException {
        InputStream retval = null;
        if (this.unFilteredStream == null) {
            this.doDecode();
        }
        if (this.unFilteredStream != null) {
            long position = this.unFilteredStream.getPosition();
            long length = this.unFilteredStream.getLength();
            RandomAccessFileInputStream input = new RandomAccessFileInputStream(this.file, position, length);
            retval = new BufferedInputStream(input, 16384);
        } else {
            retval = new ByteArrayInputStream(new byte[0]);
        }
        return retval;
    }

    @Override
    public Object accept(IOMVisitor visitor) throws OMVisitorException {
        return visitor.visitFromStream(this);
    }

    private void doDecode() throws IOException {
        this.unFilteredStream = this.filteredStream;
        OMBase filters = this.getFilters();
        if (filters != null) {
            if (filters instanceof OMName) {
                this.doDecode((OMName)filters, 0);
            } else if (filters instanceof OMArray) {
                OMArray filterArray = (OMArray)filters;
                int i = 0;
                while (i < filterArray.size()) {
                    OMName filterName = (OMName)filterArray.get(i);
                    this.doDecode(filterName, i);
                    ++i;
                }
            } else {
                throw new IOException("Error: Unknown filter type:" + filters);
            }
        }
    }

    private void doDecode(OMName filterName, int filterIndex) throws IOException {
        FilterManager manager = this.getFilterManager();
        Filter filter = manager.getFilter(filterName);
        boolean done = false;
        IOException exception = null;
        long position = this.unFilteredStream.getPosition();
        long length = this.unFilteredStream.getLength();
        long writtenLength = this.unFilteredStream.getLengthWritten();
        if (length == 0L) {
            this.unFilteredStream = new RandomAccessFileOutputStream(this.file);
            done = true;
        } else {
            BufferedInputStream input;
            int tryCount = 0;
            while (!done && tryCount < 5) {
                try {
                    input = new BufferedInputStream(new RandomAccessFileInputStream(this.file, position, length), 16384);
                    this.unFilteredStream = new RandomAccessFileOutputStream(this.file);
                    filter.decode(input, this.unFilteredStream, this, filterIndex);
                    done = true;
                }
                catch (IOException io) {
                    --length;
                    exception = io;
                }
                ++tryCount;
            }
            if (!done) {
                length = writtenLength;
                tryCount = 0;
                while (!done && tryCount < 5) {
                    try {
                        input = new BufferedInputStream(new RandomAccessFileInputStream(this.file, position, length), 16384);
                        this.unFilteredStream = new RandomAccessFileOutputStream(this.file);
                        filter.decode(input, this.unFilteredStream, this, filterIndex);
                        done = true;
                    }
                    catch (IOException io) {
                        --length;
                        exception = io;
                    }
                    ++tryCount;
                }
            }
        }
        if (!done) {
            throw exception;
        }
    }

    private void doEncode() throws IOException {
        this.filteredStream = this.unFilteredStream;
        OMBase filters = this.getFilters();
        if (filters != null) {
            if (filters instanceof OMName) {
                this.doEncode((OMName)filters, 0);
            } else if (filters instanceof OMArray) {
                OMArray filterArray = (OMArray)filters;
                int i = filterArray.size() - 1;
                while (i >= 0) {
                    OMName filterName = (OMName)filterArray.get(i);
                    this.doEncode(filterName, i);
                    --i;
                }
            }
        }
    }

    private void doEncode(OMName filterName, int filterIndex) throws IOException {
        FilterManager manager = this.getFilterManager();
        Filter filter = manager.getFilter(filterName);
        BufferedInputStream input = new BufferedInputStream(new RandomAccessFileInputStream(this.file, this.filteredStream.getPosition(), this.filteredStream.getLength()), 16384);
        this.filteredStream = new RandomAccessFileOutputStream(this.file);
        filter.encode(input, this.filteredStream, this, filterIndex);
    }

    public OMBase getFilters() {
        return this.getDictionaryObject(OMName.FILTER);
    }

    public OutputStream createFilteredStream() throws IOException {
        this.filteredStream = new RandomAccessFileOutputStream(this.file);
        this.unFilteredStream = null;
        return new BufferedOutputStream(this.filteredStream, 16384);
    }

    public OutputStream createFilteredStream(OMBase expectedLength) throws IOException {
        this.filteredStream = new RandomAccessFileOutputStream(this.file);
        this.filteredStream.setExpectedLength(expectedLength);
        this.unFilteredStream = null;
        return new BufferedOutputStream(this.filteredStream, 16384);
    }

    public void setFilters(OMBase filters) throws IOException {
        this.setItem(OMName.FILTER, filters);
        this.filteredStream = null;
    }

    public OutputStream createUnfilteredStream() throws IOException {
        this.unFilteredStream = new RandomAccessFileOutputStream(this.file);
        this.filteredStream = null;
        return new BufferedOutputStream(this.unFilteredStream, 16384);
    }
}

