/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.om;

import com.plpdf.om.OMBase;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMInteger;
import java.io.IOException;

public abstract class OMNumber
extends OMBase {
    public static final OMInteger ZERO = OMInteger.ZERO;
    public static final OMInteger ONE = OMInteger.ONE;

    public abstract float floatValue();

    public abstract double doubleValue();

    public abstract int intValue();

    public abstract long longValue();

    public static OMNumber get(String number) throws IOException {
        if (number.length() == 1) {
            char digit = number.charAt(0);
            if ('0' <= digit && digit <= '9') {
                return OMInteger.get(digit - 48);
            }
            if (digit == '-' || digit == '.') {
                return OMInteger.ZERO;
            }
            throw new IOException("Not a number: " + number);
        }
        if (number.indexOf(46) == -1 && number.toLowerCase().indexOf(101) == -1) {
            try {
                return OMInteger.get(Long.parseLong(number));
            }
            catch (NumberFormatException e) {
                throw new IOException("Value is not an integer: " + number);
            }
        }
        return new OMFloat(number);
    }
}

