/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.om;

import com.plpdf.exceptions.OMVisitorException;
import com.plpdf.om.IOMVisitor;
import com.plpdf.om.OMBase;
import com.plpdf.persistence.util.OMHEXTable;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OMName
extends OMBase
implements Comparable<OMName> {
    private static Map<String, OMName> nameMap = new ConcurrentHashMap<String, OMName>(8192);
    private static Map<String, OMName> commonNameMap = new HashMap<String, OMName>();
    public static final OMName A = new OMName("A");
    public static final OMName AA = new OMName("AA");
    public static final OMName ACRO_FORM = new OMName("AcroForm");
    public static final OMName ACTUAL_TEXT = new OMName("ActualText");
    public static final OMName AIS = new OMName("AIS");
    public static final OMName ALT = new OMName("Alt");
    public static final OMName ALTERNATE = new OMName("Alternate");
    public static final OMName ANNOT = new OMName("Annot");
    public static final OMName ANNOTS = new OMName("Annots");
    public static final OMName ANTI_ALIAS = new OMName("AntiAlias");
    public static final OMName AP_REF = new OMName("APRef");
    public static final OMName ARTIFACT = new OMName("Artifact");
    public static final OMName ART_BOX = new OMName("ArtBox");
    public static final OMName AS = new OMName("AS");
    public static final OMName ASCII85_DECODE = new OMName("ASCII85Decode");
    public static final OMName ASCII85_DECODE_ABBREVIATION = new OMName("A85");
    public static final OMName ATTACHED = new OMName("Attached");
    public static final OMName ASCENT = new OMName("Ascent");
    public static final OMName ASCII_HEX_DECODE = new OMName("ASCIIHexDecode");
    public static final OMName ASCII_HEX_DECODE_ABBREVIATION = new OMName("AHx");
    public static final OMName AP = new OMName("AP");
    public static final OMName APP = new OMName("App");
    public static final OMName AUTHOR = new OMName("Author");
    public static final OMName AVG_WIDTH = new OMName("AvgWidth");
    public static final OMName B = new OMName("B");
    public static final OMName BACKGROUND = new OMName("Background");
    public static final OMName BASE_ENCODING = new OMName("BaseEncoding");
    public static final OMName BASE_FONT = new OMName("BaseFont");
    public static final OMName BASE_STATE = new OMName("BaseState");
    public static final OMName BBOX = new OMName("BBox");
    public static final OMName BLACK_IS_1 = new OMName("BlackIs1");
    public static final OMName BLACK_POINT = new OMName("BlackPoint");
    public static final OMName BLEED_BOX = new OMName("BleedBox");
    public static final OMName BITS_PER_COMPONENT = new OMName("BitsPerComponent");
    public static final OMName BITS_PER_COORDINATE = new OMName("BitsPerCoordinate");
    public static final OMName BITS_PER_FLAG = new OMName("BitsPerFlag");
    public static final OMName BITS_PER_SAMPLE = new OMName("BitsPerSample");
    public static final OMName BOUNDS = new OMName("Bounds");
    public static final OMName BPC = new OMName("BPC");
    public static final OMName CATALOG = new OMName("Catalog");
    public static final OMName C = new OMName("C");
    public static final OMName C0 = new OMName("C0");
    public static final OMName C1 = new OMName("C1");
    public static final OMName CA = new OMName("CA");
    public static final OMName CA_NS = new OMName("ca");
    public static final OMName CALGRAY = new OMName("CalGray");
    public static final OMName CALRGB = new OMName("CalRGB");
    public static final OMName CAP_HEIGHT = new OMName("CapHeight");
    public static final OMName CCITTFAX_DECODE = new OMName("CCITTFaxDecode");
    public static final OMName CCITTFAX_DECODE_ABBREVIATION = new OMName("CCF");
    public static final OMName CENTER_WINDOW = new OMName("CenterWindow");
    public static final OMName CF = new OMName("CF");
    public static final OMName CFM = new OMName("CFM");
    public static final OMName CHAR_PROCS = new OMName("CharProcs");
    public static final OMName CHAR_SET = new OMName("CharSet");
    public static final OMName CID_FONT_TYPE0 = new OMName("CIDFontType0");
    public static final OMName CID_FONT_TYPE2 = new OMName("CIDFontType2");
    public static final OMName CIDSYSTEMINFO = new OMName("CIDSystemInfo");
    public static final OMName CID_TO_GID_MAP = new OMName("CIDToGIDMap");
    public static final OMName COLORANTS = new OMName("Colorants");
    public static final OMName COLORS = new OMName("Colors");
    public static final OMName COLORSPACE = new OMName("ColorSpace");
    public static final OMName COLUMNS = new OMName("Columns");
    public static final OMName CONTACT_INFO = new OMName("ContactInfo");
    public static final OMName CONTENTS = new OMName("Contents");
    public static final OMName COORDS = new OMName("Coords");
    public static final OMName COUNT = new OMName("Count");
    public static final OMName CLR_F = new OMName("ClrF");
    public static final OMName CLR_FF = new OMName("ClrFf");
    public static final OMName CREATION_DATE = new OMName("CreationDate");
    public static final OMName CREATOR = new OMName("Creator");
    public static final OMName CROP_BOX = new OMName("CropBox");
    public static final OMName CRYPT = new OMName("Crypt");
    public static final OMName CS = new OMName("CS");
    public static final OMName DEFAULT = new OMName("default");
    public static final OMName D = new OMName("D");
    public static final OMName DA = new OMName("DA");
    public static final OMName DATE = new OMName("Date");
    public static final OMName DCT_DECODE = new OMName("DCTDecode");
    public static final OMName DCT_DECODE_ABBREVIATION = new OMName("DCT");
    public static final OMName DECODE = new OMName("Decode");
    public static final OMName DECODE_PARMS = new OMName("DecodeParms");
    public static final OMName DESC = new OMName("Desc");
    public static final OMName DESCENT = new OMName("Descent");
    public static final OMName DESCENDANT_FONTS = new OMName("DescendantFonts");
    public static final OMName DEST = new OMName("Dest");
    public static final OMName DESTS = new OMName("Dests");
    public static final OMName DEVICECMYK = new OMName("DeviceCMYK");
    public static final OMName DEVICEGRAY = new OMName("DeviceGray");
    public static final OMName DEVICEN = new OMName("DeviceN");
    public static final OMName DEVICERGB = new OMName("DeviceRGB");
    public static final OMName DIFFERENCES = new OMName("Differences");
    public static final OMName DIGEST_METHOD = new OMName("DigestMethod");
    public static final OMName DIGEST_SHA1 = new OMName("SHA1");
    public static final OMName DIGEST_SHA256 = new OMName("SHA256");
    public static final OMName DIGEST_SHA384 = new OMName("SHA384");
    public static final OMName DIGEST_SHA512 = new OMName("SHA512");
    public static final OMName DIGEST_RIPEMD160 = new OMName("RIPEMD160");
    public static final OMName DIRECTION = new OMName("Direction");
    public static final OMName DISPLAY_DOC_TITLE = new OMName("DisplayDocTitle");
    public static final OMName DL = new OMName("DL");
    public static final OMName DOC_CHECKSUM = new OMName("DocChecksum");
    public static final OMName DOC_TIME_STAMP = new OMName("DocTimeStamp");
    public static final OMName DOMAIN = new OMName("Domain");
    public static final OMName DOS = new OMName("DOS");
    public static final OMName DP = new OMName("DP");
    public static final OMName DR = new OMName("DR");
    public static final OMName DUPLEX = new OMName("Duplex");
    public static final OMName DV = new OMName("DV");
    public static final OMName DW = new OMName("DW");
    public static final OMName E = new OMName("E");
    public static final OMName EF = new OMName("EF");
    public static final OMName EMBEDDED_FILES = new OMName("EmbeddedFiles");
    public static final OMName EMBEDDED_FDFS = new OMName("EmbeddedFDFs");
    public static final OMName ENCODE = new OMName("Encode");
    public static final OMName ENCODING = new OMName("Encoding");
    public static final OMName ENCODING_90MS_RKSJ_H = new OMName("90ms-RKSJ-H");
    public static final OMName ENCODING_90MS_RKSJ_V = new OMName("90ms-RKSJ-V");
    public static final OMName ENCODING_ETEN_B5_H = new OMName("ETen?B5?H");
    public static final OMName ENCODING_ETEN_B5_V = new OMName("ETen?B5?V");
    public static final OMName ENCRYPT = new OMName("Encrypt");
    public static final OMName ENCRYPT_META_DATA = new OMName("EncryptMetadata");
    public static final OMName EXT_G_STATE = new OMName("ExtGState");
    public static final OMName EXTEND = new OMName("Extend");
    public static final OMName EXTENDS = new OMName("Extends");
    public static final OMName F = new OMName("F");
    public static final OMName F_DECODE_PARMS = new OMName("FDecodeParms");
    public static final OMName F_FILTER = new OMName("FFilter");
    public static final OMName FF = new OMName("Ff");
    public static final OMName FIELDS = new OMName("Fields");
    public static final OMName FILESPEC = new OMName("Filespec");
    public static final OMName FILTER = new OMName("Filter");
    public static final OMName FIRST = new OMName("First");
    public static final OMName FIRST_CHAR = new OMName("FirstChar");
    public static final OMName FIT_WINDOW = new OMName("FitWindow");
    public static final OMName FL = new OMName("FL");
    public static final OMName FLAGS = new OMName("Flags");
    public static final OMName FLATE_DECODE = new OMName("FlateDecode");
    public static final OMName FLATE_DECODE_ABBREVIATION = new OMName("Fl");
    public static final OMName FONT = new OMName("Font");
    public static final OMName FONT_BBOX = new OMName("FontBBox");
    public static final OMName FONT_FAMILY = new OMName("FontFamily");
    public static final OMName FONT_FILE = new OMName("FontFile");
    public static final OMName FONT_FILE2 = new OMName("FontFile2");
    public static final OMName FONT_FILE3 = new OMName("FontFile3");
    public static final OMName FONT_DESC = new OMName("FontDescriptor");
    public static final OMName FONT_MATRIX = new OMName("FontMatrix");
    public static final OMName FONT_NAME = new OMName("FontName");
    public static final OMName FONT_STRETCH = new OMName("FontStretch");
    public static final OMName FONT_WEIGHT = new OMName("FontWeight");
    public static final OMName FORM = new OMName("Form");
    public static final OMName FORMTYPE = new OMName("FormType");
    public static final OMName FRM = new OMName("FRM");
    public static final OMName FT = new OMName("FT");
    public static final OMName FUNCTION = new OMName("Function");
    public static final OMName FUNCTION_TYPE = new OMName("FunctionType");
    public static final OMName FUNCTIONS = new OMName("Functions");
    public static final OMName GAMMA = new OMName("Gamma");
    public static final OMName H = new OMName("H");
    public static final OMName HEIGHT = new OMName("Height");
    public static final OMName HIDE_MENUBAR = new OMName("HideMenubar");
    public static final OMName HIDE_TOOLBAR = new OMName("HideToolbar");
    public static final OMName HIDE_WINDOWUI = new OMName("HideWindowUI");
    public static final OMName ICCBASED = new OMName("ICCBased");
    public static final OMName I = new OMName("I");
    public static final OMName ID = new OMName("ID");
    public static final OMName ID_TREE = new OMName("IDTree");
    public static final OMName IDENTITY = new OMName("Identity");
    public static final OMName IDENTITY_H = new OMName("Identity-H");
    public static final OMName IMAGE = new OMName("Image");
    public static final OMName IMAGE_MASK = new OMName("ImageMask");
    public static final OMName INDEX = new OMName("Index");
    public static final OMName INDEXED = new OMName("Indexed");
    public static final OMName INFO = new OMName("Info");
    public static final OMName ITALIC_ANGLE = new OMName("ItalicAngle");
    public static final OMName JAVA_SCRIPT = new OMName("JavaScript");
    public static final OMName JBIG2_DECODE = new OMName("JBIG2Decode");
    public static final OMName JBIG2_GLOBALS = new OMName("JBIG2Globals");
    public static final OMName JPX_DECODE = new OMName("JPXDecode");
    public static final OMName K = new OMName("K");
    public static final OMName KEYWORDS = new OMName("Keywords");
    public static final OMName KIDS = new OMName("Kids");
    public static final OMName LAB = new OMName("Lab");
    public static final OMName LANG = new OMName("Lang");
    public static final OMName LAST_CHAR = new OMName("LastChar");
    public static final OMName LAST_MODIFIED = new OMName("LastModified");
    public static final OMName LC = new OMName("LC");
    public static final OMName L = new OMName("L");
    public static final OMName LEADING = new OMName("Leading");
    public static final OMName LEGAL_ATTESTATION = new OMName("LegalAttestation");
    public static final OMName LENGTH = new OMName("Length");
    public static final OMName LENGTH1 = new OMName("Length1");
    public static final OMName LENGTH2 = new OMName("Length2");
    public static final OMName LIMITS = new OMName("Limits");
    public static final OMName LJ = new OMName("LJ");
    public static final OMName LW = new OMName("LW");
    public static final OMName LZW_DECODE = new OMName("LZWDecode");
    public static final OMName LZW_DECODE_ABBREVIATION = new OMName("LZW");
    public static final OMName M = new OMName("M");
    public static final OMName MAC = new OMName("Mac");
    public static final OMName MAC_ROMAN_ENCODING = new OMName("MacRomanEncoding");
    public static final OMName MARK_INFO = new OMName("MarkInfo");
    public static final OMName MASK = new OMName("Mask");
    public static final OMName MATRIX = new OMName("Matrix");
    public static final OMName MAX_LEN = new OMName("MaxLen");
    public static final OMName MAX_WIDTH = new OMName("MaxWidth");
    public static final OMName MCID = new OMName("MCID");
    public static final OMName MDP = new OMName("MDP");
    public static final OMName MEDIA_BOX = new OMName("MediaBox");
    public static final OMName STRUCT_PARENT = new OMName("StructParent");
    public static final OMName STRUCT_PARENTS = new OMName("StructParents");
    public static final OMName METADATA = new OMName("Metadata");
    public static final OMName MISSING_WIDTH = new OMName("MissingWidth");
    public static final OMName ML = new OMName("ML");
    public static final OMName MM_TYPE1 = new OMName("MMType1");
    public static final OMName MOD_DATE = new OMName("ModDate");
    public static final OMName N = new OMName("N");
    public static final OMName NAME = new OMName("Name");
    public static final OMName NAMES = new OMName("Names");
    public static final OMName NEXT = new OMName("Next");
    public static final OMName NM = new OMName("NM");
    public static final OMName NON_EFONT_NO_WARN = new OMName("NonEFontNoWarn");
    public static final OMName NON_FULL_SCREEN_PAGE_MODE = new OMName("NonFullScreenPageMode");
    public static final OMName NUMS = new OMName("Nums");
    public static final OMName O = new OMName("O");
    public static final OMName OBJ = new OMName("Obj");
    public static final OMName OBJ_STM = new OMName("ObjStm");
    public static final OMName OC = new OMName("OC");
    public static final OMName OCG = new OMName("OCG");
    public static final OMName OCGS = new OMName("OCGs");
    public static final OMName OCPROPERTIES = new OMName("OCProperties");
    public static final OMName OFF = new OMName("OFF");
    public static final OMName ON = new OMName("ON");
    public static final OMName OP = new OMName("OP");
    public static final OMName OP_NS = new OMName("op");
    public static final OMName OPM = new OMName("OPM");
    public static final OMName OPT = new OMName("Opt");
    public static final OMName OS = new OMName("OS");
    public static final OMName OUTLINES = new OMName("Outlines");
    public static final OMName OPEN_ACTION = new OMName("OpenAction");
    public static final OMName ORDER = new OMName("Order");
    public static final OMName ORDERING = new OMName("Ordering");
    public static final OMName P = new OMName("P");
    public static final OMName PAGE = new OMName("Page");
    public static final OMName PAGE_LABELS = new OMName("PageLabels");
    public static final OMName PAGE_LAYOUT = new OMName("PageLayout");
    public static final OMName PAGE_MODE = new OMName("PageMode");
    public static final OMName PAGES = new OMName("Pages");
    public static final OMName PAINT_TYPE = new OMName("PaintType");
    public static final OMName PARENT = new OMName("Parent");
    public static final OMName PARENT_TREE = new OMName("ParentTree");
    public static final OMName PARENT_TREE_NEXT_KEY = new OMName("ParentTreeNextKey");
    public static final OMName PATTERN = new OMName("Pattern");
    public static final OMName PATTERN_TYPE = new OMName("PatternType");
    public static final OMName PDF_DOC_ENCODING = new OMName("PDFDocEncoding");
    public static final OMName PG = new OMName("Pg");
    public static final OMName PRE_RELEASE = new OMName("PreRelease");
    public static final OMName PREDICTOR = new OMName("Predictor");
    public static final OMName PREV = new OMName("Prev");
    public static final OMName PRINT_AREA = new OMName("PrintArea");
    public static final OMName PRINT_CLIP = new OMName("PrintClip");
    public static final OMName PRINT_SCALING = new OMName("PrintScaling");
    public static final OMName PROC_SET = new OMName("ProcSet");
    public static final OMName PRODUCER = new OMName("Producer");
    public static final OMName PROP_BUILD = new OMName("Prop_Build");
    public static final OMName PROPERTIES = new OMName("Properties");
    public static final OMName PUB_SEC = new OMName("PubSec");
    public static final OMName Q = new OMName("Q");
    public static final OMName R = new OMName("R");
    public static final OMName RANGE = new OMName("Range");
    public static final OMName REASONS = new OMName("Reasons");
    public static final OMName RECIPIENTS = new OMName("Recipients");
    public static final OMName RECT = new OMName("Rect");
    public static final OMName REGISTRY = new OMName("Registry");
    public static final OMName RESOURCES = new OMName("Resources");
    public static final OMName RI = new OMName("RI");
    public static final OMName ROLE_MAP = new OMName("RoleMap");
    public static final OMName ROOT = new OMName("Root");
    public static final OMName ROTATE = new OMName("Rotate");
    public static final OMName ROWS = new OMName("Rows");
    public static final OMName RUN_LENGTH_DECODE = new OMName("RunLengthDecode");
    public static final OMName RUN_LENGTH_DECODE_ABBREVIATION = new OMName("RL");
    public static final OMName RV = new OMName("RV");
    public static final OMName S = new OMName("S");
    public static final OMName SA = new OMName("SA");
    public static final OMName SE = new OMName("SE");
    public static final OMName SEPARATION = new OMName("Separation");
    public static final OMName SET_F = new OMName("SetF");
    public static final OMName SET_FF = new OMName("SetFf");
    public static final OMName SHADING = new OMName("Shading");
    public static final OMName SHADING_TYPE = new OMName("ShadingType");
    public static final OMName SM = new OMName("SM");
    public static final OMName SMASK = new OMName("SMask");
    public static final OMName SIZE = new OMName("Size");
    public static final OMName STANDARD_ENCODING = new OMName("StandardEncoding");
    public static final OMName STATUS = new OMName("Status");
    public static final OMName STD_CF = new OMName("StdCF");
    public static final OMName STEM_H = new OMName("StemH");
    public static final OMName STEM_V = new OMName("StemV");
    public static final OMName STM_F = new OMName("StmF");
    public static final OMName STR_F = new OMName("StrF");
    public static final OMName STRUCT_TREE_ROOT = new OMName("StructTreeRoot");
    public static final OMName SUB_FILTER = new OMName("SubFilter");
    public static final OMName SUBJ = new OMName("Subj");
    public static final OMName SUBJECT = new OMName("Subject");
    public static final OMName SUPPLEMENT = new OMName("Supplement");
    public static final OMName SUBTYPE = new OMName("Subtype");
    public static final OMName SV = new OMName("SV");
    public static final OMName T = new OMName("T");
    public static final OMName TARGET = new OMName("Target");
    public static final OMName THREADS = new OMName("Threads");
    public static final OMName TILING_TYPE = new OMName("TilingType");
    public static final OMName TIME_STAMP = new OMName("TimeStamp");
    public static final OMName TITLE = new OMName("Title");
    public static final OMName TK = new OMName("TK");
    public static final OMName TRAPPED = new OMName("Trapped");
    public static final OMName TRIM_BOX = new OMName("TrimBox");
    public static final OMName TRUE_TYPE = new OMName("TrueType");
    public static final OMName TRUSTED_MODE = new OMName("TrustedMode");
    public static final OMName TO_UNICODE = new OMName("ToUnicode");
    public static final OMName TU = new OMName("TU");
    public static final OMName TYPE = new OMName("Type");
    public static final OMName TYPE0 = new OMName("Type0");
    public static final OMName TYPE1 = new OMName("Type1");
    public static final OMName TYPE3 = new OMName("Type3");
    public static final OMName U = new OMName("U");
    public static final OMName UF = new OMName("UF");
    public static final OMName UNCHANGED = new OMName("Unchanged");
    public static final OMName UNIX = new OMName("Unix");
    public static final OMName URI = new OMName("URI");
    public static final OMName URL = new OMName("URL");
    public static final OMName V = new OMName("V");
    public static final OMName VERSION = new OMName("Version");
    public static final OMName VERTICES_PER_ROW = new OMName("VerticesPerRow");
    public static final OMName VIEW_AREA = new OMName("ViewArea");
    public static final OMName VIEW_CLIP = new OMName("ViewClip");
    public static final OMName VIEWER_PREFERENCES = new OMName("ViewerPreferences");
    public static final OMName W = new OMName("W");
    public static final OMName WIDTH = new OMName("Width");
    public static final OMName WIDTHS = new OMName("Widths");
    public static final OMName WIN_ANSI_ENCODING = new OMName("WinAnsiEncoding");
    public static final OMName WHITE_POINT = new OMName("WhitePoint");
    public static final OMName XHEIGHT = new OMName("XHeight");
    public static final OMName XOBJECT = new OMName("XObject");
    public static final OMName XREF = new OMName("XRef");
    public static final OMName XREF_STM = new OMName("XRefStm");
    public static final OMName X_STEP = new OMName("XStep");
    public static final OMName Y_STEP = new OMName("YStep");
    public static final byte[] NAME_PREFIX = new byte[]{47};
    public static final byte[] NAME_ESCAPE = new byte[]{35};
    public static final OMName SUBFILTER = new OMName("SubFilter");
    public static final OMName ADOBE_PPKLITE = new OMName("Adobe.PPKLite");
    public static final OMName ENTRUST_PPKEF = new OMName("Entrust.PPKEF");
    public static final OMName CICI_SIGNIT = new OMName("CICI.SignIt");
    public static final OMName VERISIGN_PPKVS = new OMName("VeriSign.PPKVS");
    public static final OMName ADBE_X509_RSA_SHA1 = new OMName("adbe.x509.rsa_sha1");
    public static final OMName ADBE_PKCS7_DETACHED = new OMName("adbe.pkcs7.detached");
    public static final OMName ADBE_PKCS7_SHA1 = new OMName("adbe.pkcs7.sha1");
    public static final OMName LOCATION = new OMName("Location");
    public static final OMName REASON = new OMName("Reason");
    public static final OMName BYTERANGE = new OMName("ByteRange");
    public static final OMName SIG = new OMName("Sig");
    public static final OMName SIG_FLAGS = new OMName("SigFlags");
    public static final OMName OC_CONFIG_DICT = new OMName("D");
    public static final OMName OC_ORDER = new OMName("Order");
    public static final OMName EVENT = new OMName("Event");
    public static final OMName PRINT = new OMName("Print");
    public static final OMName VIEW = new OMName("View");
    public static final OMName CATEGORY = new OMName("Category");
    public static final OMName USAGE = new OMName("Usage");
    public static final OMName CREATORINFO = new OMName("CreatorInfo");
    public static final OMName PREFERRED = new OMName("Preferred");
    public static final OMName LANGUAGE = new OMName("Language");
    public static final OMName EXPORTSTATE = new OMName("ExportState");
    public static final OMName EXPORT = new OMName("Export");
    public static final OMName MIN = new OMName("min");
    public static final OMName MAX = new OMName("max");
    public static final OMName ZOOM = new OMName("Zoom");
    public static final OMName PRINTSTATE = new OMName("PrintState");
    public static final OMName VIEWSTATE = new OMName("ViewState");
    public static final OMName IMAGEMASK = new OMName("ImageMask");
    public static final OMName BITSPERCOMPONENT = new OMName("BitsPerComponent");
    public static final OMName CCITTFAXDECODE = new OMName("CCITTFaxDecode");
    public static final OMName BLACKIS1 = new OMName("BlackIs1");
    public static final OMName INTERPOLATE = new OMName("Interpolate");
    public static final OMName ENCODEDBYTEALIGN = new OMName("EncodedByteAlign");
    public static final OMName ENDOFLINE = new OMName("EndOfLine");
    public static final OMName ENDOFBLOCK = new OMName("EndOfBlock");
    public static final OMName DECODEPARMS = new OMName("DecodeParms");
    public static final OMName PERCEPTUAL = new OMName("Perceptual");
    public static final OMName RELATIVECOLORIMETRIC = new OMName("RelativeColorimetric");
    public static final OMName SATURATION = new OMName("Saturation");
    public static final OMName ABSOLUTECOLORIMETRIC = new OMName("AbsoluteColorimetric");
    public static final OMName WHITEPOINT = new OMName("WhitePoint");
    public static final OMName INTENT = new OMName("Intent");
    public static final OMName DCTDECODE = new OMName("DCTDecode");
    public static final OMName JPXDECODE = new OMName("JPXDecode");
    public static final OMName JBIG2DECODE = new OMName("JBIG2Decode");
    public static final OMName PATTERNTYPE = new OMName("PatternType");
    public static final OMName PERMS = new OMName("Perms");
    public static final OMName BORDER = new OMName("Border");
    public static final OMName OUTPUT_INTENTS = new OMName("OutputIntents");
    public static final OMName OUTPUT_INTENT = new OMName("OutputIntent");
    public static final OMName GTS_PDFA1 = new OMName("GTS_PDFA1");
    public static final OMName DEST_OUTPUT_PROFILE = new OMName("DestOutputProfile");
    public static final OMName OUTPUT_CONDITION = new OMName("OutputCondition");
    public static final OMName OUTPUT_CONDITION_IDENTIFIER = new OMName("OutputConditionIdentifier");
    public static final OMName REGISTRY_NAME = new OMName("RegistryName");
    public static final OMName NEEDAPPEARANCES = new OMName("NeedAppearances");
    public static final OMName MK = new OMName("MK");
    public static final OMName XML = new OMName("XML");
    private String name;
    private int hashCode;

    public static final OMName getPDFName(String aName) {
        OMName name = null;
        if (aName != null && (name = commonNameMap.get(aName)) == null && (name = nameMap.get(aName)) == null) {
            name = new OMName(aName, false);
        }
        return name;
    }

    private OMName(String aName, boolean staticValue) {
        this.name = aName;
        if (staticValue) {
            commonNameMap.put(aName, this);
        } else {
            nameMap.put(aName, this);
        }
        this.hashCode = this.name.hashCode();
    }

    public OMName(String aName) {
        this(aName, true);
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "OMName{" + this.name + "}";
    }

    public boolean equals(Object o) {
        boolean retval;
        boolean bl = retval = this == o;
        if (!retval && o instanceof OMName) {
            OMName other = (OMName)o;
            retval = this.name == other.name || this.name.equals(other.name);
        }
        return retval;
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(OMName other) {
        return this.name.compareTo(other.name);
    }

    @Override
    public Object accept(IOMVisitor visitor) throws OMVisitorException {
        return visitor.visitFromName(this);
    }

    public void writePDF(OutputStream output) throws IOException {
        output.write(NAME_PREFIX);
        byte[] bytes = this.getName().getBytes("ISO-8859-1");
        int i = 0;
        while (i < bytes.length) {
            int current = (bytes[i] + 256) % 256;
            if (current <= 32 || current >= 127 || current == 40 || current == 41 || current == 91 || current == 93 || current == 47 || current == 37 || current == 60 || current == 62 || current == NAME_ESCAPE[0]) {
                output.write(NAME_ESCAPE);
                output.write(OMHEXTable.TABLE[current]);
            } else {
                output.write(current);
            }
            ++i;
        }
    }

    public static synchronized void clearResources() {
        nameMap.clear();
    }
}

