/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.om;

import com.plpdf.exceptions.OMVisitorException;
import com.plpdf.om.IOMVisitor;
import com.plpdf.om.OMNumber;
import java.io.IOException;
import java.io.OutputStream;

public class OMInteger
extends OMNumber {
    private static int LOW = -100;
    private static int HIGH = 256;
    private static final OMInteger[] STATIC = new OMInteger[HIGH - LOW + 1];
    public static final OMInteger ZERO = OMInteger.get(0L);
    public static final OMInteger ONE = OMInteger.get(1L);
    public static final OMInteger TWO = OMInteger.get(2L);
    public static final OMInteger THREE = OMInteger.get(3L);
    private long value;

    public static OMInteger get(long val) {
        if ((long)LOW <= val && val <= (long)HIGH) {
            int index = (int)val - LOW;
            if (STATIC[index] == null) {
                OMInteger.STATIC[index] = new OMInteger(val);
            }
            return STATIC[index];
        }
        return new OMInteger(val);
    }

    public OMInteger(long val) {
        this.value = val;
    }

    public OMInteger(int val) {
        this((long)val);
    }

    public OMInteger(String val) throws IOException {
        try {
            this.value = Long.parseLong(val);
        }
        catch (NumberFormatException e) {
            throw new IOException("Error: value is not an integer type actual='" + val + "'");
        }
    }

    public boolean equals(Object o) {
        return o instanceof OMInteger && ((OMInteger)o).intValue() == this.intValue();
    }

    public int hashCode() {
        return (int)(this.value ^ this.value >> 32);
    }

    public String toString() {
        return "OMInt{" + this.value + "}";
    }

    public void setValue(long newValue) {
        this.value = newValue;
    }

    public float floatValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public Object accept(IOMVisitor visitor) throws OMVisitorException {
        return visitor.visitFromInt(this);
    }

    public void writePDF(OutputStream output) throws IOException {
        output.write(String.valueOf(this.value).getBytes("ISO-8859-1"));
    }
}

