/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.om;

import com.plpdf.exceptions.OMVisitorException;
import com.plpdf.io.RandomAccess;
import com.plpdf.io.RandomAccessBuffer;
import com.plpdf.io.RandomAccessFile;
import com.plpdf.om.IOMVisitor;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMObject;
import com.plpdf.om.OMStream;
import com.plpdf.pdfparser.PDFObjectStreamParser;
import com.plpdf.persistence.util.OMObjectKey;
import com.plpdf.smmodel.interactive.digitalsignature.SignatureInterface;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMDocument
extends OMBase {
    private float version = 1.4f;
    private final Map<OMObjectKey, OMObject> objectPool = new HashMap<OMObjectKey, OMObject>();
    private final Map<OMObjectKey, Long> xrefTable = new HashMap<OMObjectKey, Long>();
    private OMDictionary trailer;
    private SignatureInterface signatureInterface;
    private final RandomAccess scratchFile;
    private final File tmpFile;
    private String headerString = "%PDF-" + this.version;
    private boolean warnMissingClose = true;
    private boolean isDecrypted = false;
    private long startXref;
    private boolean closed = false;
    private final boolean forceParsing;

    public OMDocument(RandomAccess scratchFileValue, boolean forceParsingValue) {
        this.scratchFile = scratchFileValue;
        this.tmpFile = null;
        this.forceParsing = forceParsingValue;
    }

    public OMDocument(File scratchDir, boolean forceParsingValue) throws IOException {
        this.tmpFile = File.createTempFile("plpdf-", ".tmp", scratchDir);
        this.scratchFile = new RandomAccessFile(this.tmpFile, "rw");
        this.forceParsing = forceParsingValue;
    }

    public OMDocument() throws IOException {
        this(new RandomAccessBuffer(), false);
    }

    public OMDocument(File scratchDir) throws IOException {
        this(scratchDir, false);
    }

    public OMDocument(RandomAccess file) {
        this(file, false);
    }

    public RandomAccess getScratchFile() {
        if (!this.closed) {
            return this.scratchFile;
        }
        return null;
    }

    public OMStream createOMStream() {
        return new OMStream(this.getScratchFile());
    }

    public OMStream createOMStream(RandomAccess ra) {
        return new OMStream(ra);
    }

    public OMStream createCOSStream(OMDictionary dictionary) {
        return new OMStream(dictionary, this.getScratchFile());
    }

    public OMObject getObjectByType(String type) throws IOException {
        return this.getObjectByType(OMName.getPDFName(type));
    }

    public OMObject getObjectByType(OMName type) throws IOException {
        for (OMObject object : this.objectPool.values()) {
            OMBase realObject = object.getObject();
            if (!(realObject instanceof OMDictionary)) continue;
            try {
                OMDictionary dic = (OMDictionary)realObject;
                OMName objectType = (OMName)dic.getItem(OMName.TYPE);
                if (objectType == null || !objectType.equals(type)) continue;
                return object;
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return null;
    }

    public List<OMObject> getObjectsByType(String type) throws IOException {
        return this.getObjectsByType(OMName.getPDFName(type));
    }

    public List<OMObject> getObjectsByType(OMName type) throws IOException {
        ArrayList<OMObject> retval = new ArrayList<OMObject>();
        for (OMObject object : this.objectPool.values()) {
            OMBase realObject = object.getObject();
            if (!(realObject instanceof OMDictionary)) continue;
            try {
                OMDictionary dic = (OMDictionary)realObject;
                OMName objectType = (OMName)dic.getItem(OMName.TYPE);
                if (objectType == null || !objectType.equals(type)) continue;
                retval.add(object);
            }
            catch (ClassCastException classCastException) {
                // empty catch block
            }
        }
        return retval;
    }

    public void print() {
        for (OMObject object : this.objectPool.values()) {
            System.out.println(object);
        }
    }

    public void setVersion(float versionValue) {
        if (versionValue != this.version) {
            this.headerString = this.headerString.replaceFirst(String.valueOf(this.version), String.valueOf(versionValue));
        }
        this.version = versionValue;
    }

    public float getVersion() {
        return this.version;
    }

    public void setDecrypted() {
        this.isDecrypted = true;
    }

    public boolean isEncrypted() {
        if (this.isDecrypted) {
            return false;
        }
        boolean encrypted = false;
        if (this.trailer != null) {
            encrypted = this.trailer.getDictionaryObject(OMName.ENCRYPT) != null;
        }
        return encrypted;
    }

    public OMDictionary getEncryptionDictionary() {
        return (OMDictionary)this.trailer.getDictionaryObject(OMName.ENCRYPT);
    }

    public SignatureInterface getSignatureInterface() {
        return this.signatureInterface;
    }

    public void setEncryptionDictionary(OMDictionary encDictionary) {
        this.trailer.setItem(OMName.ENCRYPT, (OMBase)encDictionary);
    }

    public List<OMDictionary> getSignatureDictionaries() throws IOException {
        List<OMDictionary> signatureFields = this.getSignatureFields(false);
        LinkedList<OMDictionary> signatures = new LinkedList<OMDictionary>();
        for (OMDictionary dict : signatureFields) {
            OMBase dictionaryObject = dict.getDictionaryObject(OMName.V);
            if (dictionaryObject == null) continue;
            signatures.add((OMDictionary)dictionaryObject);
        }
        return signatures;
    }

    public List<OMDictionary> getSignatureFields(boolean onlyEmptyFields) throws IOException {
        OMArray fields;
        OMDictionary acroForm;
        OMObject documentCatalog = this.getCatalog();
        if (documentCatalog != null && (acroForm = (OMDictionary)documentCatalog.getDictionaryObject(OMName.ACRO_FORM)) != null && (fields = (OMArray)acroForm.getDictionaryObject(OMName.FIELDS)) != null) {
            HashMap<OMObjectKey, OMDictionary> signatures = new HashMap<OMObjectKey, OMDictionary>();
            for (OMBase object : fields) {
                OMBase dictionaryObject;
                OMObject dict = (OMObject)object;
                if (!OMName.SIG.equals(dict.getItem(OMName.FT)) || (dictionaryObject = dict.getDictionaryObject(OMName.V)) != null && (dictionaryObject == null || onlyEmptyFields)) continue;
                signatures.put(new OMObjectKey(dict), (OMDictionary)dict.getObject());
            }
            return new LinkedList<OMDictionary>(signatures.values());
        }
        return Collections.emptyList();
    }

    public OMArray getDocumentID() {
        return (OMArray)this.getTrailer().getDictionaryObject(OMName.ID);
    }

    public void setDocumentID(OMArray id) {
        this.getTrailer().setItem(OMName.ID, (OMBase)id);
    }

    public void setSignatureInterface(SignatureInterface sigInterface) {
        this.signatureInterface = sigInterface;
    }

    public OMObject getCatalog() throws IOException {
        OMObject catalog = this.getObjectByType(OMName.CATALOG);
        if (catalog == null) {
            throw new IOException("Catalog cannot be found");
        }
        return catalog;
    }

    public List<OMObject> getObjects() {
        return new ArrayList<OMObject>(this.objectPool.values());
    }

    public OMDictionary getTrailer() {
        return this.trailer;
    }

    public void setTrailer(OMDictionary newTrailer) {
        this.trailer = newTrailer;
    }

    @Override
    public Object accept(IOMVisitor visitor) throws OMVisitorException {
        return visitor.visitFromDocument(this);
    }

    public void close() throws IOException {
        if (!this.closed) {
            this.scratchFile.close();
            if (this.tmpFile != null) {
                this.tmpFile.delete();
            }
            this.closed = true;
        }
    }

    protected void finalize() throws IOException {
        if (!this.closed) {
            this.close();
        }
    }

    public void setWarnMissingClose(boolean warn) {
        this.warnMissingClose = warn;
    }

    public String getHeaderString() {
        return this.headerString;
    }

    public void setHeaderString(String header) {
        this.headerString = header;
    }

    public void dereferenceObjectStreams() throws IOException {
        for (OMObject objStream : this.getObjectsByType(OMName.OBJ_STM)) {
            OMStream stream = (OMStream)objStream.getObject();
            PDFObjectStreamParser parser = new PDFObjectStreamParser(stream, this, this.forceParsing);
            parser.parse();
            for (OMObject next : parser.getObjects()) {
                OMObjectKey key = new OMObjectKey(next);
                if (this.objectPool.get(key) != null && this.objectPool.get(key).getObject() != null && (!this.xrefTable.containsKey(key) || this.xrefTable.get(key) != -objStream.getObjectNumber().longValue())) continue;
                OMObject obj = this.getObjectFromPool(key);
                obj.setObject(next.getObject());
            }
        }
    }

    public OMObject getObjectFromPool(OMObjectKey key) throws IOException {
        OMObject obj = null;
        if (key != null) {
            obj = this.objectPool.get(key);
        }
        if (obj == null) {
            obj = new OMObject(null);
            if (key != null) {
                obj.setObjectNumber(OMInteger.get(key.getNumber()));
                obj.setGenerationNumber(OMInteger.get(key.getGeneration()));
                this.objectPool.put(key, obj);
            }
        }
        return obj;
    }

    public OMObject removeObject(OMObjectKey key) {
        return this.objectPool.remove(key);
    }

    public void addXRefTable(Map<OMObjectKey, Long> xrefTableValues) {
        this.xrefTable.putAll(xrefTableValues);
    }

    public Map<OMObjectKey, Long> getXrefTable() {
        return this.xrefTable;
    }

    public void setStartXref(long startXrefValue) {
        this.startXref = startXrefValue;
    }

    public long getStartXref() {
        return this.startXref;
    }

    public boolean isXRefStream() {
        if (this.trailer != null) {
            return OMName.XREF.equals(this.trailer.getItem(OMName.TYPE));
        }
        return false;
    }

    public RandomAccessBuffer getScratchFileBuffer() {
        if (this.scratchFile == null) {
            return new RandomAccessBuffer();
        }
        return (RandomAccessBuffer)this.scratchFile;
    }
}

