/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.om;

import com.plpdf.exceptions.OMVisitorException;
import com.plpdf.om.IOMVisitor;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMBoolean;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNull;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMObject;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.util.DateConverter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMDictionary
extends OMBase {
    private static final String PATH_SEPARATOR = "/";
    protected final Map<OMName, OMBase> items = new LinkedHashMap<OMName, OMBase>();

    public OMDictionary() {
    }

    public OMDictionary(OMDictionary dict) {
        this.items.putAll(dict.items);
    }

    public boolean containsValue(Object value) {
        boolean contains = this.items.containsValue(value);
        if (!contains && value instanceof OMObject) {
            contains = this.items.containsValue(((OMObject)value).getObject());
        }
        return contains;
    }

    public OMName getKeyForValue(Object value) {
        for (Map.Entry<OMName, OMBase> entry : this.items.entrySet()) {
            OMBase nextValue = entry.getValue();
            if (!nextValue.equals(value) && (!(nextValue instanceof OMObject) || !((OMObject)nextValue).getObject().equals(value))) continue;
            return entry.getKey();
        }
        return null;
    }

    public int size() {
        return this.items.size();
    }

    public void clear() {
        this.items.clear();
    }

    public OMBase getDictionaryObject(String key) {
        return this.getDictionaryObject(OMName.getPDFName(key));
    }

    public OMBase getDictionaryObject(String firstKey, String secondKey) {
        OMBase retval = this.getDictionaryObject(OMName.getPDFName(firstKey));
        if (retval == null) {
            retval = this.getDictionaryObject(OMName.getPDFName(secondKey));
        }
        return retval;
    }

    public OMBase getDictionaryObject(OMName firstKey, OMName secondKey) {
        OMBase retval = this.getDictionaryObject(firstKey);
        if (retval == null && secondKey != null) {
            retval = this.getDictionaryObject(secondKey);
        }
        return retval;
    }

    public OMBase getDictionaryObject(String[] keyList) {
        OMBase retval = null;
        int i = 0;
        while (i < keyList.length && retval == null) {
            retval = this.getDictionaryObject(OMName.getPDFName(keyList[i]));
            ++i;
        }
        return retval;
    }

    public OMBase getDictionaryObject(OMName key) {
        OMBase retval = this.items.get(key);
        if (retval instanceof OMObject) {
            retval = ((OMObject)retval).getObject();
        }
        if (retval instanceof OMNull) {
            retval = null;
        }
        return retval;
    }

    public void setItem(OMName key, OMBase value) {
        if (value == null) {
            this.removeItem(key);
        } else {
            this.items.put(key, value);
        }
    }

    public void setItem(OMName key, OMObjectable value) {
        OMBase base = null;
        if (value != null) {
            base = value.getOMObject();
        }
        this.setItem(key, base);
    }

    public void setItem(String key, OMObjectable value) {
        this.setItem(OMName.getPDFName(key), value);
    }

    public void setBoolean(String key, boolean value) {
        this.setItem(OMName.getPDFName(key), (OMBase)OMBoolean.getBoolean(value));
    }

    public void setBoolean(OMName key, boolean value) {
        this.setItem(key, (OMBase)OMBoolean.getBoolean(value));
    }

    public void setItem(String key, OMBase value) {
        this.setItem(OMName.getPDFName(key), value);
    }

    public void setName(String key, String value) {
        this.setName(OMName.getPDFName(key), value);
    }

    public void setName(OMName key, String value) {
        OMName name = null;
        if (value != null) {
            name = OMName.getPDFName(value);
        }
        this.setItem(key, (OMBase)name);
    }

    public void setDate(String key, Calendar date) throws IOException {
        this.setDate(OMName.getPDFName(key), date);
    }

    public void setDate(OMName key, Calendar date) throws IOException {
        this.setString(key, DateConverter.toString(date));
    }

    public void setEmbeddedDate(String embedded, String key, Calendar date) throws IOException {
        this.setEmbeddedDate(embedded, OMName.getPDFName(key), date);
    }

    public void setEmbeddedDate(String embedded, OMName key, Calendar date) throws IOException {
        OMDictionary dic = (OMDictionary)this.getDictionaryObject(embedded);
        if (dic == null && date != null) {
            dic = new OMDictionary();
            this.setItem(embedded, (OMBase)dic);
        }
        if (dic != null) {
            dic.setDate(key, date);
        }
    }

    public void setString(String key, String value) throws IOException {
        this.setString(OMName.getPDFName(key), value);
    }

    public void setString(OMName key, String value) throws IOException {
        OMString name = null;
        if (value != null) {
            name = new OMString(value);
        }
        this.setItem(key, name);
    }

    public void setEmbeddedString(String embedded, String key, String value) throws IOException {
        this.setEmbeddedString(embedded, OMName.getPDFName(key), value);
    }

    public void setEmbeddedString(String embedded, OMName key, String value) throws IOException {
        OMDictionary dic = (OMDictionary)this.getDictionaryObject(embedded);
        if (dic == null && value != null) {
            dic = new OMDictionary();
            this.setItem(embedded, (OMBase)dic);
        }
        if (dic != null) {
            dic.setString(key, value);
        }
    }

    public void setInt(String key, int value) {
        this.setInt(OMName.getPDFName(key), value);
    }

    public void setInt(OMName key, int value) {
        this.setItem(key, (OMBase)OMInteger.get(value));
    }

    public void setLong(String key, long value) {
        this.setLong(OMName.getPDFName(key), value);
    }

    public void setLong(OMName key, long value) {
        OMInteger intVal = null;
        intVal = OMInteger.get(value);
        this.setItem(key, (OMBase)intVal);
    }

    public void setEmbeddedInt(String embeddedDictionary, String key, int value) {
        this.setEmbeddedInt(embeddedDictionary, OMName.getPDFName(key), value);
    }

    public void setEmbeddedInt(String embeddedDictionary, OMName key, int value) {
        OMDictionary embedded = (OMDictionary)this.getDictionaryObject(embeddedDictionary);
        if (embedded == null) {
            embedded = new OMDictionary();
            this.setItem(embeddedDictionary, (OMBase)embedded);
        }
        embedded.setInt(key, value);
    }

    public void setFloat(String key, float value) {
        this.setFloat(OMName.getPDFName(key), value);
    }

    public void setFloat(OMName key, float value) {
        OMFloat fltVal = new OMFloat(value);
        this.setItem(key, (OMBase)fltVal);
    }

    public String getNameAsString(String key) {
        return this.getNameAsString(OMName.getPDFName(key));
    }

    public String getNameAsString(OMName key) {
        String retval = null;
        OMBase name = this.getDictionaryObject(key);
        if (name != null) {
            if (name instanceof OMName) {
                retval = ((OMName)name).getName();
            } else if (name instanceof OMString) {
                retval = ((OMString)name).getString();
            }
        }
        return retval;
    }

    public String getNameAsString(String key, String defaultValue) {
        return this.getNameAsString(OMName.getPDFName(key), defaultValue);
    }

    public String getNameAsString(OMName key, String defaultValue) {
        String retval = this.getNameAsString(key);
        if (retval == null) {
            retval = defaultValue;
        }
        return retval;
    }

    public String getString(String key) {
        return this.getString(OMName.getPDFName(key));
    }

    public String getString(OMName key) {
        String retval = null;
        OMBase value = this.getDictionaryObject(key);
        if (value != null && value instanceof OMString) {
            retval = ((OMString)value).getString();
        }
        return retval;
    }

    public String getString(String key, String defaultValue) {
        return this.getString(OMName.getPDFName(key), defaultValue);
    }

    public String getString(OMName key, String defaultValue) {
        String retval = this.getString(key);
        if (retval == null) {
            retval = defaultValue;
        }
        return retval;
    }

    public String getEmbeddedString(String embedded, String key) {
        return this.getEmbeddedString(embedded, OMName.getPDFName(key), null);
    }

    public String getEmbeddedString(String embedded, OMName key) {
        return this.getEmbeddedString(embedded, key, null);
    }

    public String getEmbeddedString(String embedded, String key, String defaultValue) {
        return this.getEmbeddedString(embedded, OMName.getPDFName(key), defaultValue);
    }

    public String getEmbeddedString(String embedded, OMName key, String defaultValue) {
        String retval = defaultValue;
        OMDictionary dic = (OMDictionary)this.getDictionaryObject(embedded);
        if (dic != null) {
            retval = dic.getString(key, defaultValue);
        }
        return retval;
    }

    public Calendar getDate(String key) throws IOException {
        return this.getDate(OMName.getPDFName(key));
    }

    public Calendar getDate(OMName key) throws IOException {
        OMString date = (OMString)this.getDictionaryObject(key);
        return DateConverter.toCalendar(date);
    }

    public Calendar getDate(String key, Calendar defaultValue) throws IOException {
        return this.getDate(OMName.getPDFName(key), defaultValue);
    }

    public Calendar getDate(OMName key, Calendar defaultValue) throws IOException {
        Calendar retval = this.getDate(key);
        if (retval == null) {
            retval = defaultValue;
        }
        return retval;
    }

    public Calendar getEmbeddedDate(String embedded, String key) throws IOException {
        return this.getEmbeddedDate(embedded, OMName.getPDFName(key), null);
    }

    public Calendar getEmbeddedDate(String embedded, OMName key) throws IOException {
        return this.getEmbeddedDate(embedded, key, null);
    }

    public Calendar getEmbeddedDate(String embedded, String key, Calendar defaultValue) throws IOException {
        return this.getEmbeddedDate(embedded, OMName.getPDFName(key), defaultValue);
    }

    public Calendar getEmbeddedDate(String embedded, OMName key, Calendar defaultValue) throws IOException {
        Calendar retval = defaultValue;
        OMDictionary eDic = (OMDictionary)this.getDictionaryObject(embedded);
        if (eDic != null) {
            retval = eDic.getDate(key, defaultValue);
        }
        return retval;
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(OMName.getPDFName(key), defaultValue);
    }

    public boolean getBoolean(OMName key, boolean defaultValue) {
        return this.getBoolean(key, null, defaultValue);
    }

    public boolean getBoolean(OMName firstKey, OMName secondKey, boolean defaultValue) {
        boolean retval = defaultValue;
        OMBase bool = this.getDictionaryObject(firstKey, secondKey);
        if (bool != null && bool instanceof OMBoolean) {
            retval = ((OMBoolean)bool).getValue();
        }
        return retval;
    }

    public int getEmbeddedInt(String embeddedDictionary, String key) {
        return this.getEmbeddedInt(embeddedDictionary, OMName.getPDFName(key));
    }

    public int getEmbeddedInt(String embeddedDictionary, OMName key) {
        return this.getEmbeddedInt(embeddedDictionary, key, -1);
    }

    public int getEmbeddedInt(String embeddedDictionary, String key, int defaultValue) {
        return this.getEmbeddedInt(embeddedDictionary, OMName.getPDFName(key), defaultValue);
    }

    public int getEmbeddedInt(String embeddedDictionary, OMName key, int defaultValue) {
        int retval = defaultValue;
        OMDictionary embedded = (OMDictionary)this.getDictionaryObject(embeddedDictionary);
        if (embedded != null) {
            retval = embedded.getInt(key, defaultValue);
        }
        return retval;
    }

    public int getInt(String key) {
        return this.getInt(OMName.getPDFName(key), -1);
    }

    public int getInt(OMName key) {
        return this.getInt(key, -1);
    }

    public int getInt(String[] keyList, int defaultValue) {
        int retval = defaultValue;
        OMBase obj = this.getDictionaryObject(keyList);
        if (obj != null && obj instanceof OMNumber) {
            retval = ((OMNumber)obj).intValue();
        }
        return retval;
    }

    public int getInt(String key, int defaultValue) {
        return this.getInt(OMName.getPDFName(key), defaultValue);
    }

    public int getInt(OMName key, int defaultValue) {
        return this.getInt(key, null, defaultValue);
    }

    public int getInt(OMName firstKey, OMName secondKey) {
        return this.getInt(firstKey, secondKey, -1);
    }

    public int getInt(OMName firstKey, OMName secondKey, int defaultValue) {
        int retval = defaultValue;
        OMBase obj = this.getDictionaryObject(firstKey, secondKey);
        if (obj != null && obj instanceof OMNumber) {
            retval = ((OMNumber)obj).intValue();
        }
        return retval;
    }

    public long getLong(String key) {
        return this.getLong(OMName.getPDFName(key), -1L);
    }

    public long getLong(OMName key) {
        return this.getLong(key, -1L);
    }

    public long getLong(String[] keyList, long defaultValue) {
        long retval = defaultValue;
        OMBase obj = this.getDictionaryObject(keyList);
        if (obj != null && obj instanceof OMNumber) {
            retval = ((OMNumber)obj).longValue();
        }
        return retval;
    }

    public long getLong(String key, long defaultValue) {
        return this.getLong(OMName.getPDFName(key), defaultValue);
    }

    public long getLong(OMName key, long defaultValue) {
        long retval = defaultValue;
        OMBase obj = this.getDictionaryObject(key);
        if (obj != null && obj instanceof OMNumber) {
            retval = ((OMNumber)obj).longValue();
        }
        return retval;
    }

    public float getFloat(String key) {
        return this.getFloat(OMName.getPDFName(key), -1.0f);
    }

    public float getFloat(OMName key) {
        return this.getFloat(key, -1.0f);
    }

    public float getFloat(String key, float defaultValue) {
        return this.getFloat(OMName.getPDFName(key), defaultValue);
    }

    public float getFloat(OMName key, float defaultValue) {
        float retval = defaultValue;
        OMBase obj = this.getDictionaryObject(key);
        if (obj != null && obj instanceof OMNumber) {
            retval = ((OMNumber)obj).floatValue();
        }
        return retval;
    }

    public void removeItem(OMName key) {
        this.items.remove(key);
    }

    public OMBase getItem(OMName key) {
        return this.items.get(key);
    }

    public OMBase getItem(String key) {
        return this.getItem(OMName.getPDFName(key));
    }

    public List<OMName> keyList() {
        return new ArrayList<OMName>(this.items.keySet());
    }

    public Set<OMName> keySet() {
        return this.items.keySet();
    }

    public Set<Map.Entry<OMName, OMBase>> entrySet() {
        return this.items.entrySet();
    }

    public Collection<OMBase> getValues() {
        return this.items.values();
    }

    @Override
    public Object accept(IOMVisitor visitor) throws OMVisitorException {
        return visitor.visitFromDictionary(this);
    }

    public void addAll(OMDictionary dic) {
        for (Map.Entry<OMName, OMBase> entry : dic.entrySet()) {
            if (entry.getKey().getName().equals("Size") && this.items.containsKey(OMName.getPDFName("Size"))) continue;
            this.setItem(entry.getKey(), entry.getValue());
        }
    }

    public boolean containsKey(OMName name) {
        return this.items.containsKey(name);
    }

    public boolean containsKey(String name) {
        return this.containsKey(OMName.getPDFName(name));
    }

    public void mergeInto(OMDictionary dic) {
        for (Map.Entry<OMName, OMBase> entry : dic.entrySet()) {
            if (this.getItem(entry.getKey()) != null) continue;
            this.setItem(entry.getKey(), entry.getValue());
        }
    }

    public OMBase getObjectFromPath(String objPath) {
        OMBase retval = null;
        String[] path = objPath.split(PATH_SEPARATOR);
        retval = this;
        int i = 0;
        while (i < path.length) {
            if (retval instanceof OMArray) {
                int idx = new Integer(path[i].replaceAll("\\[", "").replaceAll("\\]", ""));
                retval = ((OMArray)retval).getObject(idx);
            } else if (retval instanceof OMDictionary) {
                retval = retval.getDictionaryObject(path[i]);
            }
            ++i;
        }
        return retval;
    }

    public String toString() {
        StringBuilder retVal = new StringBuilder("OMDictionary{");
        for (OMName key : this.items.keySet()) {
            retVal.append("(");
            retVal.append(key);
            retVal.append(":");
            if (this.getDictionaryObject(key) != null) {
                retVal.append(this.getDictionaryObject(key).toString());
            } else {
                retVal.append("<null>");
            }
            retVal.append(") ");
        }
        retVal.append("}");
        return retVal.toString();
    }
}

