/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.om;

import com.plpdf.exceptions.OMVisitorException;
import com.plpdf.om.IOMVisitor;
import com.plpdf.om.OMBase;
import java.io.IOException;
import java.io.OutputStream;

public class OMBoolean
extends OMBase {
    public static final byte[] TRUE_BYTES = new byte[]{116, 114, 117, 101};
    public static final byte[] FALSE_BYTES = new byte[]{102, 97, 108, 115, 101};
    public static final OMBoolean TRUE = new OMBoolean(true);
    public static final OMBoolean FALSE = new OMBoolean(false);
    private boolean value;

    private OMBoolean(boolean aValue) {
        this.value = aValue;
    }

    public boolean getValue() {
        return this.value;
    }

    public Boolean getValueAsObject() {
        return this.value ? Boolean.TRUE : Boolean.FALSE;
    }

    public static OMBoolean getBoolean(boolean value) {
        return value ? TRUE : FALSE;
    }

    public static OMBoolean getBoolean(Boolean value) {
        return OMBoolean.getBoolean((boolean)value);
    }

    public Object accept(IOMVisitor visitor) throws OMVisitorException {
        return visitor.visitFromBoolean(this);
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public void writePDF(OutputStream output) throws IOException {
        if (this.value) {
            output.write(TRUE_BYTES);
        } else {
            output.write(FALSE_BYTES);
        }
    }
}

