/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.om;

import com.plpdf.exceptions.OMVisitorException;
import com.plpdf.om.IOMVisitor;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMFloat;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMNull;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMObject;
import com.plpdf.om.OMString;
import com.plpdf.smmodel.common.OMObjectable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OMArray
extends OMBase
implements Iterable<OMBase> {
    private List<OMBase> objects = new ArrayList<OMBase>();

    public void add(OMBase object) {
        this.objects.add(object);
    }

    public void add(OMObjectable object) {
        this.objects.add(object.getOMObject());
    }

    public void add(int i, OMBase object) {
        this.objects.add(i, object);
    }

    public void clear() {
        this.objects.clear();
    }

    public void removeAll(Collection<OMBase> objectsList) {
        this.objects.removeAll(objectsList);
    }

    public void retainAll(Collection<OMBase> objectsList) {
        this.objects.retainAll(objectsList);
    }

    public void addAll(Collection<OMBase> objectsList) {
        this.objects.addAll(objectsList);
    }

    public void addAll(OMArray objectList) {
        if (objectList != null) {
            this.objects.addAll(objectList.objects);
        }
    }

    public void addAll(int i, Collection<OMBase> objectList) {
        this.objects.addAll(i, objectList);
    }

    public void set(int index, OMBase object) {
        this.objects.set(index, object);
    }

    public void set(int index, int intVal) {
        this.objects.set(index, OMInteger.get(intVal));
    }

    public void set(int index, OMObjectable object) {
        OMBase base = null;
        if (object != null) {
            base = object.getOMObject();
        }
        this.objects.set(index, base);
    }

    public OMBase getObject(int index) {
        OMBase obj = this.objects.get(index);
        if (obj instanceof OMObject) {
            obj = ((OMObject)obj).getObject();
        } else if (obj instanceof OMNull) {
            obj = null;
        }
        return obj;
    }

    public OMBase get(int index) {
        return this.objects.get(index);
    }

    public int getInt(int index) {
        return this.getInt(index, -1);
    }

    public int getInt(int index, int defaultValue) {
        OMBase obj;
        int retval = defaultValue;
        if (index < this.size() && (obj = this.objects.get(index)) instanceof OMNumber) {
            retval = ((OMNumber)obj).intValue();
        }
        return retval;
    }

    public void setInt(int index, int value) {
        this.set(index, OMInteger.get(value));
    }

    public void setName(int index, String name) {
        this.set(index, OMName.getPDFName(name));
    }

    public String getName(int index) {
        return this.getName(index, null);
    }

    public String getName(int index, String defaultValue) {
        OMBase obj;
        String retval = defaultValue;
        if (index < this.size() && (obj = this.objects.get(index)) instanceof OMName) {
            retval = ((OMName)obj).getName();
        }
        return retval;
    }

    public void setString(int index, String string) {
        if (string != null) {
            this.set(index, new OMString(string));
        } else {
            this.set(index, null);
        }
    }

    public String getString(int index) {
        return this.getString(index, null);
    }

    public String getString(int index, String defaultValue) {
        OMBase obj;
        String retval = defaultValue;
        if (index < this.size() && (obj = this.objects.get(index)) instanceof OMString) {
            retval = ((OMString)obj).getString();
        }
        return retval;
    }

    public int size() {
        return this.objects.size();
    }

    public OMBase remove(int i) {
        return this.objects.remove(i);
    }

    public boolean remove(OMBase o) {
        return this.objects.remove(o);
    }

    public boolean removeObject(OMBase o) {
        boolean removed = this.remove(o);
        if (!removed) {
            int i = 0;
            while (i < this.size()) {
                OMObject objEntry;
                OMBase entry = this.get(i);
                if (entry instanceof OMObject && (objEntry = (OMObject)entry).getObject().equals(o)) {
                    return this.remove(entry);
                }
                ++i;
            }
        }
        return removed;
    }

    public String toString() {
        return "OMArray{" + this.objects + "}";
    }

    @Override
    public Iterator<OMBase> iterator() {
        return this.objects.iterator();
    }

    public int indexOf(OMBase object) {
        int retval = -1;
        int i = 0;
        while (retval < 0 && i < this.size()) {
            if (this.get(i).equals(object)) {
                retval = i;
            }
            ++i;
        }
        return retval;
    }

    public int indexOfObject(OMBase object) {
        int retval = -1;
        int i = 0;
        while (retval < 0 && i < this.size()) {
            OMBase item = this.get(i);
            if (item.equals(object)) {
                retval = i;
                break;
            }
            if (item instanceof OMObject && ((OMObject)item).getObject().equals(object)) {
                retval = i;
                break;
            }
            ++i;
        }
        return retval;
    }

    public void growToSize(int size) {
        this.growToSize(size, null);
    }

    public void growToSize(int size, OMBase object) {
        while (this.size() < size) {
            this.add(object);
        }
    }

    @Override
    public Object accept(IOMVisitor visitor) throws OMVisitorException {
        return visitor.visitFromArray(this);
    }

    public float[] toFloatArray() {
        float[] retval = new float[this.size()];
        int i = 0;
        while (i < this.size()) {
            retval[i] = ((OMNumber)this.getObject(i)).floatValue();
            ++i;
        }
        return retval;
    }

    public void setFloatArray(float[] value) {
        this.clear();
        int i = 0;
        while (i < value.length) {
            this.add(new OMFloat(value[i]));
            ++i;
        }
    }

    public List<?> toList() {
        ArrayList<OMBase> retList = new ArrayList<OMBase>(this.size());
        int i = 0;
        while (i < this.size()) {
            retList.add(this.get(i));
            ++i;
        }
        return retList;
    }
}

