/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.io;

import com.plpdf.io.RandomAccess;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMNumber;
import com.plpdf.om.OMObject;
import java.io.IOException;
import java.io.OutputStream;

public class RandomAccessFileOutputStream
extends OutputStream {
    private RandomAccess file;
    private long position;
    private long lengthWritten = 0L;
    private OMBase expectedLength = null;

    public RandomAccessFileOutputStream(RandomAccess raf) throws IOException {
        this.file = raf;
        this.position = raf.length();
    }

    public long getPosition() {
        return this.position;
    }

    public long getLengthWritten() {
        return this.lengthWritten;
    }

    public long getLength() {
        long length = -1L;
        if (this.expectedLength instanceof OMNumber) {
            length = ((OMNumber)this.expectedLength).intValue();
        } else if (this.expectedLength instanceof OMObject && ((OMObject)this.expectedLength).getObject() instanceof OMNumber) {
            length = ((OMNumber)((OMObject)this.expectedLength).getObject()).intValue();
        }
        if (length == -1L) {
            length = this.lengthWritten;
        }
        return length;
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        this.file.seek(this.position + this.lengthWritten);
        this.lengthWritten += (long)length;
        this.file.write(b, offset, length);
    }

    public void write(int b) throws IOException {
        this.file.seek(this.position + this.lengthWritten);
        ++this.lengthWritten;
        this.file.write(b);
    }

    public OMBase getExpectedLength() {
        return this.expectedLength;
    }

    public void setExpectedLength(OMBase value) {
        this.expectedLength = value;
    }
}

