/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.io;

import com.plpdf.io.RandomAccess;
import java.io.IOException;
import java.io.InputStream;

public class RandomAccessFileInputStream
extends InputStream {
    private RandomAccess file;
    private long currentPosition;
    private long endPosition;

    public RandomAccessFileInputStream(RandomAccess raFile, long startPosition, long length) {
        this.file = raFile;
        this.currentPosition = startPosition;
        this.endPosition = this.currentPosition + length;
    }

    public int available() {
        return (int)(this.endPosition - this.currentPosition);
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read() throws IOException {
        RandomAccess randomAccess = this.file;
        synchronized (randomAccess) {
            int retval = -1;
            if (this.currentPosition < this.endPosition) {
                this.file.seek(this.currentPosition);
                ++this.currentPosition;
                retval = this.file.read();
            }
            return retval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b, int offset, int length) throws IOException {
        if (length > this.available()) {
            length = this.available();
        }
        int amountRead = -1;
        if (this.available() > 0) {
            RandomAccess randomAccess = this.file;
            synchronized (randomAccess) {
                this.file.seek(this.currentPosition);
                amountRead = this.file.read(b, offset, length);
            }
        }
        if (amountRead > 0) {
            this.currentPosition += (long)amountRead;
        }
        return amountRead;
    }

    public long skip(long amountToSkip) {
        long amountSkipped = Math.min(amountToSkip, (long)this.available());
        this.currentPosition += amountSkipped;
        return amountSkipped;
    }
}

