/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.io;

import com.plpdf.io.RandomAccessRead;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.LinkedHashMap;
import java.util.Map;

public class RandomAccessBufferedFileInputStream
extends InputStream
implements RandomAccessRead {
    private int pageSizeShift = 12;
    private int pageSize = 1 << this.pageSizeShift;
    private long pageOffsetMask = -1L << this.pageSizeShift;
    private int maxCachedPages = 1000;
    private byte[] lastRemovedCachePage = null;
    private final LinkedHashMap<Long, byte[]> pageCache = new LinkedHashMap<Long, byte[]>(this.maxCachedPages, 0.75f, true){
        private static final long serialVersionUID = -6302488539257741101L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, byte[]> _eldest) {
            boolean doRemove;
            boolean bl = doRemove = this.size() > RandomAccessBufferedFileInputStream.this.maxCachedPages;
            if (doRemove) {
                RandomAccessBufferedFileInputStream.this.lastRemovedCachePage = _eldest.getValue();
            }
            return doRemove;
        }
    };
    private long curPageOffset = -1L;
    private byte[] curPage = new byte[this.pageSize];
    private int offsetWithinPage = 0;
    private final RandomAccessFile raFile;
    private final long fileLength;
    private long fileOffset = 0L;

    public RandomAccessBufferedFileInputStream(File _file) throws FileNotFoundException, IOException {
        this.raFile = new RandomAccessFile(_file, "r");
        this.fileLength = _file.length();
        this.seek(0L);
    }

    public long getFilePointer() {
        return this.fileOffset;
    }

    public long getPosition() {
        return this.fileOffset;
    }

    public void seek(long newOffset) throws IOException {
        long newPageOffset = newOffset & this.pageOffsetMask;
        if (newPageOffset != this.curPageOffset) {
            byte[] newPage = this.pageCache.get(newPageOffset);
            if (newPage == null) {
                this.raFile.seek(newPageOffset);
                newPage = this.readPage();
                this.pageCache.put(newPageOffset, newPage);
            }
            this.curPageOffset = newPageOffset;
            this.curPage = newPage;
        }
        this.offsetWithinPage = (int)(newOffset - this.curPageOffset);
        this.fileOffset = newOffset;
    }

    private final byte[] readPage() throws IOException {
        byte[] page;
        if (this.lastRemovedCachePage != null) {
            page = this.lastRemovedCachePage;
            this.lastRemovedCachePage = null;
        } else {
            page = new byte[this.pageSize];
        }
        int readBytes = 0;
        while (readBytes < this.pageSize) {
            int curBytesRead = this.raFile.read(page, readBytes, this.pageSize - readBytes);
            if (curBytesRead < 0) break;
            readBytes += curBytesRead;
        }
        return page;
    }

    public int read() throws IOException {
        if (this.fileOffset >= this.fileLength) {
            return -1;
        }
        if (this.offsetWithinPage == this.pageSize) {
            this.seek(this.fileOffset);
        }
        ++this.fileOffset;
        return this.curPage[this.offsetWithinPage++] & 0xFF;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.fileOffset >= this.fileLength) {
            return -1;
        }
        if (this.offsetWithinPage == this.pageSize) {
            this.seek(this.fileOffset);
        }
        int commonLen = Math.min(this.pageSize - this.offsetWithinPage, len);
        if (this.fileLength - this.fileOffset < (long)this.pageSize) {
            commonLen = Math.min(commonLen, (int)(this.fileLength - this.fileOffset));
        }
        System.arraycopy(this.curPage, this.offsetWithinPage, b, off, commonLen);
        this.offsetWithinPage += commonLen;
        this.fileOffset += (long)commonLen;
        return commonLen;
    }

    public int available() throws IOException {
        return (int)Math.min(this.fileLength - this.fileOffset, Integer.MAX_VALUE);
    }

    public long skip(long n) throws IOException {
        long toSkip = n;
        if (this.fileLength - this.fileOffset < toSkip) {
            toSkip = this.fileLength - this.fileOffset;
        }
        if (toSkip < (long)this.pageSize && (long)this.offsetWithinPage + toSkip <= (long)this.pageSize) {
            this.offsetWithinPage = (int)((long)this.offsetWithinPage + toSkip);
            this.fileOffset += toSkip;
        } else {
            this.seek(this.fileOffset + toSkip);
        }
        return toSkip;
    }

    public long length() throws IOException {
        return this.fileLength;
    }

    public void close() throws IOException {
        this.raFile.close();
        this.pageCache.clear();
    }
}

