/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.io;

import java.io.IOException;
import java.io.OutputStream;

public class NBitOutputStream {
    private int bitsInChunk;
    private OutputStream out;
    private int currentByte;
    private int positionInCurrentByte;

    public NBitOutputStream(OutputStream os) {
        this.out = os;
        this.currentByte = 0;
        this.positionInCurrentByte = 7;
    }

    public void write(long chunk) throws IOException {
        int i = this.bitsInChunk - 1;
        while (i >= 0) {
            long bitToWrite = chunk >> i & 1L;
            this.currentByte = (int)((long)this.currentByte | (bitToWrite <<= this.positionInCurrentByte));
            --this.positionInCurrentByte;
            if (this.positionInCurrentByte < 0) {
                this.out.write(this.currentByte);
                this.currentByte = 0;
                this.positionInCurrentByte = 7;
            }
            --i;
        }
    }

    public void close() throws IOException {
        if (this.positionInCurrentByte < 7) {
            this.out.write(this.currentByte);
        }
    }

    public int getBitsInChunk() {
        return this.bitsInChunk;
    }

    public void setBitsInChunk(int bitsInChunkValue) {
        this.bitsInChunk = bitsInChunkValue;
    }
}

