/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.io;

import com.plpdf.io.PushBackInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteArrayPushBackInputStream
extends PushBackInputStream {
    private byte[] data;
    private int datapos;
    private int datalen;
    private int save;
    private static final InputStream DUMMY = new ByteArrayInputStream("".getBytes());

    public ByteArrayPushBackInputStream(byte[] input) throws IOException {
        super(DUMMY, 1);
        this.data = input;
        this.save = this.datapos = 0;
        this.datalen = input != null ? input.length : 0;
    }

    public int peek() {
        try {
            return this.data[this.datapos] + 256 & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return -1;
        }
    }

    public boolean isEOF() {
        return this.datapos >= this.datalen;
    }

    public void mark(int readlimit) {
        this.save = this.datapos;
    }

    public boolean markSupported() {
        return true;
    }

    public void reset() {
        this.datapos = this.save;
    }

    public int available() {
        int av = this.datalen - this.datapos;
        return av > 0 ? av : 0;
    }

    public int size() {
        return this.datalen;
    }

    public void unread(int by) throws IOException {
        if (this.datapos == 0) {
            throw new IOException("ByteArrayParserInputStream.unread(int): cannot unread 1 byte at buffer position " + this.datapos);
        }
        --this.datapos;
        this.data[this.datapos] = (byte)by;
    }

    public void unread(byte[] buffer, int off, int len) throws IOException {
        if (len <= 0 || off >= buffer.length) {
            return;
        }
        if (off < 0) {
            off = 0;
        }
        if (len > buffer.length) {
            len = buffer.length;
        }
        this.localUnread(buffer, off, len);
    }

    public void unread(byte[] buffer) throws IOException {
        this.localUnread(buffer, 0, buffer.length);
    }

    private void localUnread(byte[] buffer, int off, int len) throws IOException {
        if (this.datapos < len) {
            throw new IOException("ByteArrayParserInputStream.unread(int): cannot unread " + len + " bytes at buffer position " + this.datapos);
        }
        this.datapos -= len;
        System.arraycopy(buffer, off, this.data, this.datapos, len);
    }

    public int read() {
        try {
            return this.data[this.datapos++] + 256 & 0xFF;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.datapos = this.datalen;
            return -1;
        }
    }

    public int read(byte[] buffer) {
        return this.localRead(buffer, 0, buffer.length);
    }

    public int read(byte[] buffer, int off, int len) {
        if (len <= 0 || off >= buffer.length) {
            return 0;
        }
        if (off < 0) {
            off = 0;
        }
        if (len > buffer.length) {
            len = buffer.length;
        }
        return this.localRead(buffer, off, len);
    }

    public int localRead(byte[] buffer, int off, int len) {
        if (len == 0) {
            return 0;
        }
        if (this.datapos >= this.datalen) {
            return -1;
        }
        int newpos = this.datapos + len;
        if (newpos > this.datalen) {
            newpos = this.datalen;
            len = newpos - this.datapos;
        }
        System.arraycopy(this.data, this.datapos, buffer, off, len);
        this.datapos = newpos;
        return len;
    }

    public long skip(long num) {
        if (num <= 0L) {
            return 0L;
        }
        long newpos = (long)this.datapos + num;
        if (newpos >= (long)this.datalen) {
            num = this.datalen - this.datapos;
            this.datapos = this.datalen;
        } else {
            this.datapos = (int)newpos;
        }
        return num;
    }

    public int seek(int newpos) {
        if (newpos < 0) {
            newpos = 0;
        } else if (newpos > this.datalen) {
            newpos = this.datalen;
        }
        int oldpos = this.pos;
        this.pos = newpos;
        return oldpos;
    }
}

