/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.font.ttf;

import com.plpdf.font.ttf.CMAPTable;
import com.plpdf.font.ttf.GlyphTable;
import com.plpdf.font.ttf.HeaderTable;
import com.plpdf.font.ttf.HorizontalHeaderTable;
import com.plpdf.font.ttf.HorizontalMetricsTable;
import com.plpdf.font.ttf.IndexToLocationTable;
import com.plpdf.font.ttf.MaximumProfileTable;
import com.plpdf.font.ttf.NamingTable;
import com.plpdf.font.ttf.OS2WindowsMetricsTable;
import com.plpdf.font.ttf.PostScriptTable;
import com.plpdf.font.ttf.TTFDataStream;
import com.plpdf.font.ttf.TTFTable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TrueTypeFont {
    private float version;
    private Map<String, TTFTable> tables = new HashMap<String, TTFTable>();
    private TTFDataStream data;

    TrueTypeFont(TTFDataStream fontData) {
        this.data = fontData;
    }

    public void close() throws IOException {
        this.data.close();
    }

    public float getVersion() {
        return this.version;
    }

    public void setVersion(float versionValue) {
        this.version = versionValue;
    }

    public void addTable(TTFTable table) {
        this.tables.put(table.getTag(), table);
    }

    public Collection<TTFTable> getTables() {
        return this.tables.values();
    }

    public NamingTable getNaming() {
        return (NamingTable)this.tables.get("name");
    }

    public PostScriptTable getPostScript() {
        return (PostScriptTable)this.tables.get("post");
    }

    public OS2WindowsMetricsTable getOS2Windows() {
        return (OS2WindowsMetricsTable)this.tables.get("OS/2");
    }

    public MaximumProfileTable getMaximumProfile() {
        return (MaximumProfileTable)this.tables.get("maxp");
    }

    public HeaderTable getHeader() {
        return (HeaderTable)this.tables.get("head");
    }

    public HorizontalHeaderTable getHorizontalHeader() {
        return (HorizontalHeaderTable)this.tables.get("hhea");
    }

    public HorizontalMetricsTable getHorizontalMetrics() {
        return (HorizontalMetricsTable)this.tables.get("hmtx");
    }

    public IndexToLocationTable getIndexToLocation() {
        return (IndexToLocationTable)this.tables.get("loca");
    }

    public GlyphTable getGlyph() {
        return (GlyphTable)this.tables.get("glyf");
    }

    public CMAPTable getCMAP() {
        return (CMAPTable)this.tables.get("cmap");
    }

    public InputStream getOriginalData() throws IOException {
        return this.data.getOriginalData();
    }
}

