/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.font.ttf;

import com.plpdf.font.ttf.TTFDataStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RAFDataStream
extends TTFDataStream {
    private RandomAccessFile raf = null;
    private File ttfFile = null;

    public RAFDataStream(String name, String mode) throws FileNotFoundException {
        this(new File(name), mode);
    }

    public RAFDataStream(File file, String mode) throws FileNotFoundException {
        this.raf = new RandomAccessFile(file, mode);
        this.ttfFile = file;
    }

    public short readSignedShort() throws IOException {
        return this.raf.readShort();
    }

    public long getCurrentPosition() throws IOException {
        return this.raf.getFilePointer();
    }

    public void close() throws IOException {
        this.raf.close();
        this.raf = null;
    }

    public int read() throws IOException {
        return this.raf.read();
    }

    public int readUnsignedShort() throws IOException {
        return this.raf.readUnsignedShort();
    }

    public long readLong() throws IOException {
        return this.raf.readLong();
    }

    public void seek(long pos) throws IOException {
        this.raf.seek(pos);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.raf.read(b, off, len);
    }

    public InputStream getOriginalData() throws IOException {
        return new FileInputStream(this.ttfFile);
    }
}

