/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.font.ttf;

import com.plpdf.font.encoding.Encoding;
import com.plpdf.font.ttf.MaximumProfileTable;
import com.plpdf.font.ttf.TTFDataStream;
import com.plpdf.font.ttf.TTFTable;
import com.plpdf.font.ttf.TrueTypeFont;
import java.io.IOException;

public class PostScriptTable
extends TTFTable {
    private float formatType;
    private float italicAngle;
    private short underlinePosition;
    private short underlineThickness;
    private long isFixedPitch;
    private long minMemType42;
    private long maxMemType42;
    private long mimMemType1;
    private long maxMemType1;
    private String[] glyphNames = null;
    public static final String TAG = "post";

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        block9: {
            MaximumProfileTable maxp;
            block10: {
                int i;
                block8: {
                    maxp = ttf.getMaximumProfile();
                    this.formatType = data.read32Fixed();
                    this.italicAngle = data.read32Fixed();
                    this.underlinePosition = data.readSignedShort();
                    this.underlineThickness = data.readSignedShort();
                    this.isFixedPitch = data.readUnsignedInt();
                    this.minMemType42 = data.readUnsignedInt();
                    this.maxMemType42 = data.readUnsignedInt();
                    this.mimMemType1 = data.readUnsignedInt();
                    this.maxMemType1 = data.readUnsignedInt();
                    if (this.formatType != 1.0f) break block8;
                    this.glyphNames = new String[258];
                    System.arraycopy(Encoding.MAC_GLYPH_NAMES, 0, this.glyphNames, 0, 258);
                    break block9;
                }
                if (this.formatType != 2.0f) break block10;
                int numGlyphs = data.readUnsignedShort();
                int[] glyphNameIndex = new int[numGlyphs];
                this.glyphNames = new String[numGlyphs];
                int maxIndex = Integer.MIN_VALUE;
                int i2 = 0;
                while (i2 < numGlyphs) {
                    int index;
                    glyphNameIndex[i2] = index = data.readUnsignedShort();
                    if (index <= Short.MAX_VALUE) {
                        maxIndex = Math.max(maxIndex, index);
                    }
                    ++i2;
                }
                String[] nameArray = null;
                if (maxIndex >= 258) {
                    nameArray = new String[maxIndex - 258 + 1];
                    i = 0;
                    while (i < maxIndex - 258 + 1) {
                        int numberOfChars = data.readUnsignedByte();
                        nameArray[i] = data.readString(numberOfChars);
                        ++i;
                    }
                }
                i = 0;
                while (i < numGlyphs) {
                    int index = glyphNameIndex[i];
                    this.glyphNames[i] = index < 258 ? Encoding.MAC_GLYPH_NAMES[index] : (index >= 258 && index <= Short.MAX_VALUE ? nameArray[index - 258] : ".undefined");
                    ++i;
                }
                break block9;
            }
            if (this.formatType != 2.5f) break block9;
            int[] glyphNameIndex = new int[maxp.getNumGlyphs()];
            int i = 0;
            while (i < glyphNameIndex.length) {
                int offset = data.readSignedByte();
                glyphNameIndex[i] = i + 1 + offset;
                ++i;
            }
            this.glyphNames = new String[glyphNameIndex.length];
            i = 0;
            while (i < this.glyphNames.length) {
                String name = Encoding.MAC_GLYPH_NAMES[glyphNameIndex[i]];
                if (name != null) {
                    this.glyphNames[i] = name;
                }
                ++i;
            }
        }
    }

    public float getFormatType() {
        return this.formatType;
    }

    public void setFormatType(float formatTypeValue) {
        this.formatType = formatTypeValue;
    }

    public long getIsFixedPitch() {
        return this.isFixedPitch;
    }

    public void setIsFixedPitch(long isFixedPitchValue) {
        this.isFixedPitch = isFixedPitchValue;
    }

    public float getItalicAngle() {
        return this.italicAngle;
    }

    public void setItalicAngle(float italicAngleValue) {
        this.italicAngle = italicAngleValue;
    }

    public long getMaxMemType1() {
        return this.maxMemType1;
    }

    public void setMaxMemType1(long maxMemType1Value) {
        this.maxMemType1 = maxMemType1Value;
    }

    public long getMaxMemType42() {
        return this.maxMemType42;
    }

    public void setMaxMemType42(long maxMemType42Value) {
        this.maxMemType42 = maxMemType42Value;
    }

    public long getMimMemType1() {
        return this.mimMemType1;
    }

    public void setMimMemType1(long mimMemType1Value) {
        this.mimMemType1 = mimMemType1Value;
    }

    public long getMinMemType42() {
        return this.minMemType42;
    }

    public void setMinMemType42(long minMemType42Value) {
        this.minMemType42 = minMemType42Value;
    }

    public short getUnderlinePosition() {
        return this.underlinePosition;
    }

    public void setUnderlinePosition(short underlinePositionValue) {
        this.underlinePosition = underlinePositionValue;
    }

    public short getUnderlineThickness() {
        return this.underlineThickness;
    }

    public void setUnderlineThickness(short underlineThicknessValue) {
        this.underlineThickness = underlineThicknessValue;
    }

    public String[] getGlyphNames() {
        return this.glyphNames;
    }

    public void setGlyphNames(String[] glyphNamesValue) {
        this.glyphNames = glyphNamesValue;
    }
}

