/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.font.ttf;

import com.plpdf.font.ttf.NameRecord;
import com.plpdf.font.ttf.TTFDataStream;
import com.plpdf.font.ttf.TTFTable;
import com.plpdf.font.ttf.TrueTypeFont;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamingTable
extends TTFTable {
    public static final String TAG = "name";
    private List<NameRecord> nameRecords = new ArrayList<NameRecord>();

    @Override
    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        NameRecord nr;
        int formatSelector = data.readUnsignedShort();
        int numberOfNameRecords = data.readUnsignedShort();
        int offsetToStartOfStringStorage = data.readUnsignedShort();
        int i = 0;
        while (i < numberOfNameRecords) {
            nr = new NameRecord();
            nr.initData(ttf, data);
            this.nameRecords.add(nr);
            ++i;
        }
        i = 0;
        while (i < numberOfNameRecords) {
            nr = this.nameRecords.get(i);
            data.seek(this.getOffset() + 6L + (long)(numberOfNameRecords * 2 * 6) + (long)nr.getStringOffset());
            int platform = nr.getPlatformId();
            int encoding = nr.getPlatformEncodingId();
            String charset = "ISO-8859-1";
            if (platform == 3 && encoding == 1) {
                charset = "UTF-16";
            } else if (platform == 2) {
                if (encoding == 0) {
                    charset = "US-ASCII";
                } else if (encoding == 1) {
                    charset = "ISO-10646-1";
                } else if (encoding == 2) {
                    charset = "ISO-8859-1";
                }
            }
            String string = data.readString(nr.getStringLength(), charset);
            nr.setString(string);
            ++i;
        }
    }

    public List<NameRecord> getNameRecords() {
        return this.nameRecords;
    }
}

