/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.font.ttf;

import com.plpdf.font.ttf.GlyphData;
import com.plpdf.font.ttf.IndexToLocationTable;
import com.plpdf.font.ttf.MaximumProfileTable;
import com.plpdf.font.ttf.TTFDataStream;
import com.plpdf.font.ttf.TTFTable;
import com.plpdf.font.ttf.TrueTypeFont;
import java.io.IOException;

public class GlyphTable
extends TTFTable {
    public static final String TAG = "glyf";
    private GlyphData[] glyphs;

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        MaximumProfileTable maxp = ttf.getMaximumProfile();
        IndexToLocationTable loc = ttf.getIndexToLocation();
        long[] offsets = loc.getOffsets();
        int numGlyphs = maxp.getNumGlyphs();
        long endOfGlyphs = offsets[numGlyphs];
        long currentOffset = -1L;
        long offset = this.getOffset();
        this.glyphs = new GlyphData[numGlyphs];
        int i = 0;
        while (i < numGlyphs) {
            if (endOfGlyphs == offsets[i]) break;
            if (offsets[i] != offsets[i + 1]) {
                currentOffset = offsets[i];
                this.glyphs[i] = new GlyphData();
                data.seek(offset + offsets[i]);
                this.glyphs[i].initData(ttf, data);
            }
            ++i;
        }
        i = 0;
        while (i < numGlyphs) {
            GlyphData glyph = this.glyphs[i];
            if (glyph != null && glyph.getDescription().isComposite()) {
                glyph.getDescription().resolve();
            }
            ++i;
        }
    }

    public GlyphData[] getGlyphs() {
        return this.glyphs;
    }

    public void setGlyphs(GlyphData[] glyphsValue) {
        this.glyphs = glyphsValue;
    }
}

