/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.font.ttf;

import com.plpdf.font.ttf.GlyfCompositeDescript;
import com.plpdf.font.ttf.GlyfDescript;
import com.plpdf.font.ttf.GlyfSimpleDescript;
import com.plpdf.font.ttf.GlyphDescription;
import com.plpdf.font.ttf.TTFDataStream;
import com.plpdf.font.ttf.TrueTypeFont;
import com.plpdf.font.util.BoundingBox;
import java.io.IOException;

public class GlyphData {
    private short xMin;
    private short yMin;
    private short xMax;
    private short yMax;
    private BoundingBox boundingBox = null;
    private short numberOfContours;
    private GlyfDescript glyphDescription = null;

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        this.numberOfContours = data.readSignedShort();
        this.xMin = data.readSignedShort();
        this.yMin = data.readSignedShort();
        this.xMax = data.readSignedShort();
        this.yMax = data.readSignedShort();
        this.boundingBox = new BoundingBox(this.xMin, this.yMin, this.xMax, this.yMax);
        this.glyphDescription = this.numberOfContours >= 0 ? new GlyfSimpleDescript(this.numberOfContours, data) : new GlyfCompositeDescript(data, ttf.getGlyph());
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public void setBoundingBox(BoundingBox boundingBoxValue) {
        this.boundingBox = boundingBoxValue;
    }

    public short getNumberOfContours() {
        return this.numberOfContours;
    }

    public void setNumberOfContours(short numberOfContoursValue) {
        this.numberOfContours = numberOfContoursValue;
    }

    public GlyphDescription getDescription() {
        return this.glyphDescription;
    }

    public short getXMaximum() {
        return this.xMax;
    }

    public short getXMinimum() {
        return this.xMin;
    }

    public short getYMaximum() {
        return this.yMax;
    }

    public short getYMinimum() {
        return this.yMin;
    }
}

