/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.font.ttf;

import com.plpdf.font.ttf.GlyphDescription;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;

public class Glyph2D {
    private short leftSideBearing = 0;
    private int advanceWidth = 0;
    private Point[] points;
    private GeneralPath glyphPath;

    public Glyph2D(GlyphDescription gd, short lsb, int advance) {
        this.leftSideBearing = lsb;
        this.advanceWidth = advance;
        this.describe(gd);
    }

    public int getAdvanceWidth() {
        return this.advanceWidth;
    }

    public short getLeftSideBearing() {
        return this.leftSideBearing;
    }

    private void describe(GlyphDescription gd) {
        int endPtIndex = 0;
        this.points = new Point[gd.getPointCount()];
        int i = 0;
        while (i < gd.getPointCount()) {
            boolean endPt;
            boolean bl = endPt = gd.getEndPtOfContours(endPtIndex) == i;
            if (endPt) {
                ++endPtIndex;
            }
            this.points[i] = new Point(gd.getXCoordinate(i), gd.getYCoordinate(i), (gd.getFlags(i) & 1) != 0, endPt);
            ++i;
        }
    }

    public GeneralPath getPath() {
        if (this.glyphPath == null) {
            this.glyphPath = this.calculatePath();
        }
        return this.glyphPath;
    }

    private GeneralPath calculatePath() {
        GeneralPath path = new GeneralPath();
        int numberOfPoints = this.points.length;
        int i = 0;
        boolean endOfContour = true;
        Point startingPoint = null;
        Point lastCtrlPoint = null;
        while (i < numberOfPoints) {
            Point point = this.points[i % numberOfPoints];
            Point nextPoint1 = this.points[(i + 1) % numberOfPoints];
            Point nextPoint2 = this.points[(i + 2) % numberOfPoints];
            if (endOfContour) {
                if (point.endOfContour) {
                    ++i;
                    continue;
                }
                path.moveTo(point.x, point.y);
                endOfContour = false;
                startingPoint = point;
            }
            if (point.onCurve && nextPoint1.onCurve) {
                path.lineTo(nextPoint1.x, nextPoint1.y);
                ++i;
                if (!point.endOfContour && !nextPoint1.endOfContour) continue;
                endOfContour = true;
                path.closePath();
                continue;
            }
            if (point.onCurve && !nextPoint1.onCurve && nextPoint2.onCurve) {
                if (nextPoint1.endOfContour) {
                    path.quadTo(nextPoint1.x, nextPoint1.y, startingPoint.x, startingPoint.y);
                } else {
                    path.quadTo(nextPoint1.x, nextPoint1.y, nextPoint2.x, nextPoint2.y);
                }
                if (nextPoint1.endOfContour || nextPoint2.endOfContour) {
                    endOfContour = true;
                    path.closePath();
                }
                i += 2;
                lastCtrlPoint = nextPoint1;
                continue;
            }
            if (point.onCurve && !nextPoint1.onCurve && !nextPoint2.onCurve) {
                int endPointX = this.midValue(nextPoint1.x, nextPoint2.x);
                int endPointY = this.midValue(nextPoint1.y, nextPoint2.y);
                path.quadTo(nextPoint1.x, nextPoint1.y, endPointX, endPointY);
                if (point.endOfContour || nextPoint1.endOfContour || nextPoint2.endOfContour) {
                    path.quadTo(nextPoint2.x, nextPoint2.y, startingPoint.x, startingPoint.y);
                    endOfContour = true;
                    path.closePath();
                }
                i += 2;
                lastCtrlPoint = nextPoint1;
                continue;
            }
            if (!point.onCurve && !nextPoint1.onCurve) {
                Point2D lastEndPoint = path.getCurrentPoint();
                lastCtrlPoint = new Point(this.midValue(lastCtrlPoint.x, (int)lastEndPoint.getX()), this.midValue(lastCtrlPoint.y, (int)lastEndPoint.getY()));
                int endPointX = this.midValue((int)lastEndPoint.getX(), nextPoint1.x);
                int endPointY = this.midValue((int)lastEndPoint.getY(), nextPoint1.y);
                path.quadTo(lastCtrlPoint.x, lastCtrlPoint.y, endPointX, endPointY);
                if (point.endOfContour || nextPoint1.endOfContour) {
                    endOfContour = true;
                    path.closePath();
                }
                ++i;
                continue;
            }
            if (!point.onCurve && nextPoint1.onCurve) {
                path.quadTo(point.x, point.y, nextPoint1.x, nextPoint1.y);
                if (point.endOfContour || nextPoint1.endOfContour) {
                    endOfContour = true;
                    path.closePath();
                }
                ++i;
                lastCtrlPoint = point;
                continue;
            }
            System.err.println("Unknown glyph command!!");
            break;
        }
        return path;
    }

    private int midValue(int a, int b) {
        return a + (b - a) / 2;
    }

    private class Point {
        public int x = 0;
        public int y = 0;
        public boolean onCurve = true;
        public boolean endOfContour = false;

        public Point(int xValue, int yValue, boolean onCurveValue, boolean endOfContourValue) {
            this.x = xValue;
            this.y = yValue;
            this.onCurve = onCurveValue;
            this.endOfContour = endOfContourValue;
        }

        public Point(int xValue, int yValue) {
            this(xValue, yValue, false, false);
        }
    }
}

