/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.font.ttf;

import com.plpdf.font.ttf.GlyfDescript;
import com.plpdf.font.ttf.TTFDataStream;
import java.io.IOException;

public class GlyfSimpleDescript
extends GlyfDescript {
    private int[] endPtsOfContours;
    private byte[] flags;
    private short[] xCoordinates;
    private short[] yCoordinates;
    private int pointCount;

    public GlyfSimpleDescript(short numberOfContours, TTFDataStream bais) throws IOException {
        super(numberOfContours, bais);
        if (numberOfContours == 0) {
            this.pointCount = 0;
            return;
        }
        this.endPtsOfContours = new int[numberOfContours];
        this.endPtsOfContours = bais.readUnsignedShortArray(numberOfContours);
        this.pointCount = this.endPtsOfContours[numberOfContours - 1] + 1;
        this.flags = new byte[this.pointCount];
        this.xCoordinates = new short[this.pointCount];
        this.yCoordinates = new short[this.pointCount];
        int instructionCount = bais.readUnsignedShort();
        this.readInstructions(bais, instructionCount);
        this.readFlags(this.pointCount, bais);
        this.readCoords(this.pointCount, bais);
    }

    public int getEndPtOfContours(int i) {
        return this.endPtsOfContours[i];
    }

    public byte getFlags(int i) {
        return this.flags[i];
    }

    public short getXCoordinate(int i) {
        return this.xCoordinates[i];
    }

    public short getYCoordinate(int i) {
        return this.yCoordinates[i];
    }

    public boolean isComposite() {
        return false;
    }

    public int getPointCount() {
        return this.pointCount;
    }

    private void readCoords(int count, TTFDataStream bais) throws IOException {
        short x = 0;
        short y = 0;
        int i = 0;
        while (i < count) {
            if ((this.flags[i] & 0x10) != 0) {
                if ((this.flags[i] & 2) != 0) {
                    x = (short)(x + (short)bais.readUnsignedByte());
                }
            } else {
                x = (this.flags[i] & 2) != 0 ? (short)(x + (short)(-((short)bais.readUnsignedByte()))) : (short)(x + bais.readSignedShort());
            }
            this.xCoordinates[i] = x;
            ++i;
        }
        i = 0;
        while (i < count) {
            if ((this.flags[i] & 0x20) != 0) {
                if ((this.flags[i] & 4) != 0) {
                    y = (short)(y + (short)bais.readUnsignedByte());
                }
            } else {
                y = (this.flags[i] & 4) != 0 ? (short)(y + (short)(-((short)bais.readUnsignedByte()))) : (short)(y + bais.readSignedShort());
            }
            this.yCoordinates[i] = y;
            ++i;
        }
    }

    private void readFlags(int flagCount, TTFDataStream bais) throws IOException {
        try {
            int index = 0;
            while (index < flagCount) {
                this.flags[index] = (byte)bais.readUnsignedByte();
                if ((this.flags[index] & 8) != 0) {
                    int repeats = bais.readUnsignedByte();
                    int i = 1;
                    while (i <= repeats) {
                        this.flags[index + i] = this.flags[index];
                        ++i;
                    }
                    index += repeats;
                }
                ++index;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            System.out.println("error: array index out of bounds");
        }
    }
}

