/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.font.ttf;

import com.plpdf.font.ttf.CMAPEncodingEntry;
import com.plpdf.font.ttf.TTFDataStream;
import com.plpdf.font.ttf.TTFTable;
import com.plpdf.font.ttf.TrueTypeFont;
import java.io.IOException;

public class CMAPTable
extends TTFTable {
    public static final String TAG = "cmap";
    public static final int PLATFORM_MISC = 0;
    public static final int PLATFORM_MACINTOSH = 1;
    public static final int PLATFORM_WINDOWS = 3;
    public static final int ENCODING_SYMBOL = 0;
    public static final int ENCODING_UNICODE = 1;
    public static final int ENCODING_SHIFT_JIS = 2;
    public static final int ENCODING_BIG5 = 3;
    public static final int ENCODING_PRC = 4;
    public static final int ENCODING_WANSUNG = 5;
    public static final int ENCODING_JOHAB = 6;
    private CMAPEncodingEntry[] cmaps;

    public void initData(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        int version = data.readUnsignedShort();
        int numberOfTables = data.readUnsignedShort();
        this.cmaps = new CMAPEncodingEntry[numberOfTables];
        int i = 0;
        while (i < numberOfTables) {
            CMAPEncodingEntry cmap = new CMAPEncodingEntry();
            cmap.initData(ttf, data);
            this.cmaps[i] = cmap;
            ++i;
        }
        i = 0;
        while (i < numberOfTables) {
            this.cmaps[i].initSubtable(ttf, data);
            ++i;
        }
    }

    public CMAPEncodingEntry[] getCmaps() {
        return this.cmaps;
    }

    public void setCmaps(CMAPEncodingEntry[] cmapsValue) {
        this.cmaps = cmapsValue;
    }
}

