/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.font.ttf;

import com.plpdf.font.ttf.CMAPTable;
import com.plpdf.font.ttf.DigitalSignatureTable;
import com.plpdf.font.ttf.GlyphTable;
import com.plpdf.font.ttf.HeaderTable;
import com.plpdf.font.ttf.HorizontalHeaderTable;
import com.plpdf.font.ttf.HorizontalMetricsTable;
import com.plpdf.font.ttf.IndexToLocationTable;
import com.plpdf.font.ttf.MaximumProfileTable;
import com.plpdf.font.ttf.MemoryTTFDataStream;
import com.plpdf.font.ttf.NamingTable;
import com.plpdf.font.ttf.OS2WindowsMetricsTable;
import com.plpdf.font.ttf.PostScriptTable;
import com.plpdf.font.ttf.RAFDataStream;
import com.plpdf.font.ttf.TTFDataStream;
import com.plpdf.font.ttf.TTFTable;
import com.plpdf.font.ttf.TrueTypeFont;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

abstract class AbstractTTFParser {
    protected boolean isEmbedded = false;

    public AbstractTTFParser(boolean isEmbedded) {
        this.isEmbedded = isEmbedded;
    }

    public TrueTypeFont parseTTF(String ttfFile) throws IOException {
        RAFDataStream raf = new RAFDataStream(ttfFile, "r");
        return this.parseTTF(raf);
    }

    public TrueTypeFont parseTTF(File ttfFile) throws IOException {
        RAFDataStream raf = new RAFDataStream(ttfFile, "r");
        return this.parseTTF(raf);
    }

    public TrueTypeFont parseTTF(InputStream ttfData) throws IOException {
        return this.parseTTF(new MemoryTTFDataStream(ttfData));
    }

    public TrueTypeFont parseTTF(TTFDataStream raf) throws IOException {
        TrueTypeFont font = new TrueTypeFont(raf);
        font.setVersion(raf.read32Fixed());
        int numberOfTables = raf.readUnsignedShort();
        int searchRange = raf.readUnsignedShort();
        int entrySelector = raf.readUnsignedShort();
        int rangeShift = raf.readUnsignedShort();
        int i = 0;
        while (i < numberOfTables) {
            TTFTable table = this.readTableDirectory(raf);
            font.addTable(table);
            ++i;
        }
        this.parseTables(font, raf);
        return font;
    }

    protected void parseTables(TrueTypeFont font, TTFDataStream raf) throws IOException {
        ArrayList<TTFTable> initialized = new ArrayList<TTFTable>();
        HeaderTable head = font.getHeader();
        if (head == null) {
            throw new IOException("head is mandatory");
        }
        raf.seek(head.getOffset());
        head.initData(font, raf);
        initialized.add(head);
        HorizontalHeaderTable hh = font.getHorizontalHeader();
        if (hh == null) {
            throw new IOException("hhead is mandatory");
        }
        raf.seek(hh.getOffset());
        hh.initData(font, raf);
        initialized.add(hh);
        MaximumProfileTable maxp = font.getMaximumProfile();
        if (maxp == null) {
            throw new IOException("maxp is mandatory");
        }
        raf.seek(maxp.getOffset());
        maxp.initData(font, raf);
        initialized.add(maxp);
        PostScriptTable post = font.getPostScript();
        if (post != null) {
            raf.seek(post.getOffset());
            post.initData(font, raf);
            initialized.add(post);
        } else if (!this.isEmbedded) {
            throw new IOException("post is mandatory");
        }
        IndexToLocationTable loc = font.getIndexToLocation();
        if (loc == null) {
            throw new IOException("loca is mandatory");
        }
        raf.seek(loc.getOffset());
        loc.initData(font, raf);
        initialized.add(loc);
        boolean cvt = false;
        boolean prep = false;
        boolean fpgm = false;
        for (TTFTable table : font.getTables()) {
            if (!initialized.contains(table)) {
                raf.seek(table.getOffset());
                table.initData(font, raf);
            }
            if (table.getTag().startsWith("cvt")) {
                cvt = true;
                continue;
            }
            if ("prep".equals(table.getTag())) {
                prep = true;
                continue;
            }
            if (!"fpgm".equals(table.getTag())) continue;
            fpgm = true;
        }
        if (font.getGlyph() == null) {
            throw new IOException("glyf is mandatory");
        }
        if (font.getNaming() == null && !this.isEmbedded) {
            throw new IOException("name is mandatory");
        }
        if (font.getHorizontalMetrics() == null) {
            throw new IOException("hmtx is mandatory");
        }
        if (this.isEmbedded) {
            if (!fpgm) {
                throw new IOException("fpgm is mandatory");
            }
            if (!prep) {
                throw new IOException("prep is mandatory");
            }
            if (!cvt) {
                throw new IOException("cvt_ is mandatory");
            }
        }
    }

    private TTFTable readTableDirectory(TTFDataStream raf) throws IOException {
        TTFTable retval = null;
        String tag = raf.readString(4);
        retval = tag.equals("cmap") ? new CMAPTable() : (tag.equals("glyf") ? new GlyphTable() : (tag.equals("head") ? new HeaderTable() : (tag.equals("hhea") ? new HorizontalHeaderTable() : (tag.equals("hmtx") ? new HorizontalMetricsTable() : (tag.equals("loca") ? new IndexToLocationTable() : (tag.equals("maxp") ? new MaximumProfileTable() : (tag.equals("name") ? new NamingTable() : (tag.equals("OS/2") ? new OS2WindowsMetricsTable() : (tag.equals("post") ? new PostScriptTable() : (tag.equals("DSIG") ? new DigitalSignatureTable() : new TTFTable()))))))))));
        retval.setTag(tag);
        retval.setCheckSum(raf.readUnsignedInt());
        retval.setOffset(raf.readUnsignedInt());
        retval.setLength(raf.readUnsignedInt());
        return retval;
    }
}

