/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.font.pfb;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PfbParser {
    private static final int PFB_HEADER_LENGTH = 18;
    private static final int START_MARKER = 128;
    private static final int ASCII_MARKER = 1;
    private static final int BINARY_MARKER = 2;
    private static final int[] PFB_RECORDS = new int[]{1, 2, 1};
    private static final int BUFFER_SIZE = 65535;
    private byte[] pfbdata;
    private int[] lengths;

    public PfbParser(String filename) throws IOException {
        this(new BufferedInputStream(new FileInputStream(filename), 65535));
    }

    public PfbParser(InputStream in) throws IOException {
        byte[] pfb = this.readPfbInput(in);
        this.parsePfb(pfb);
    }

    private void parsePfb(byte[] pfb) throws IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(pfb);
        this.pfbdata = new byte[pfb.length - 18];
        this.lengths = new int[PFB_RECORDS.length];
        int pointer = 0;
        int records = 0;
        while (records < PFB_RECORDS.length) {
            if (in.read() != 128) {
                throw new IOException("Start marker missing");
            }
            if (in.read() != PFB_RECORDS[records]) {
                throw new IOException("Incorrect record type");
            }
            int size = in.read();
            size += in.read() << 8;
            size += in.read() << 16;
            this.lengths[records] = size += in.read() << 24;
            int got = in.read(this.pfbdata, pointer, size);
            if (got < 0) {
                throw new EOFException();
            }
            pointer += got;
            ++records;
        }
    }

    private byte[] readPfbInput(InputStream in) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] tmpbuf = new byte[65535];
        int amountRead = -1;
        while ((amountRead = in.read(tmpbuf)) != -1) {
            out.write(tmpbuf, 0, amountRead);
        }
        return out.toByteArray();
    }

    public int[] getLengths() {
        return this.lengths;
    }

    public byte[] getPfbdata() {
        return this.pfbdata;
    }

    public InputStream getInputStream() {
        return new ByteArrayInputStream(this.pfbdata);
    }

    public int size() {
        return this.pfbdata.length;
    }
}

