/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.font.cmap;

import com.plpdf.font.cmap.CMap;
import com.plpdf.font.cmap.CodespaceRange;
import com.plpdf.font.util.ResourceLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class CMapParser {
    private static final String BEGIN_CODESPACE_RANGE = "begincodespacerange";
    private static final String BEGIN_BASE_FONT_CHAR = "beginbfchar";
    private static final String BEGIN_BASE_FONT_RANGE = "beginbfrange";
    private static final String BEGIN_CID_CHAR = "begincidchar";
    private static final String BEGIN_CID_RANGE = "begincidrange";
    private static final String USECMAP = "usecmap";
    private static final String END_CODESPACE_RANGE = "endcodespacerange";
    private static final String END_BASE_FONT_CHAR = "endbfchar";
    private static final String END_BASE_FONT_RANGE = "endbfrange";
    private static final String END_CID_CHAR = "endcidchar";
    private static final String END_CID_RANGE = "endcidrange";
    private static final String WMODE = "WMode";
    private static final String CMAP_NAME = "CMapName";
    private static final String CMAP_VERSION = "CMapVersion";
    private static final String CMAP_TYPE = "CMapType";
    private static final String REGISTRY = "Registry";
    private static final String ORDERING = "Ordering";
    private static final String SUPPLEMENT = "Supplement";
    private static final String MARK_END_OF_DICTIONARY = ">>";
    private static final String MARK_END_OF_ARRAY = "]";
    private byte[] tokenParserByteBuffer = new byte[512];

    public CMap parse(File file) throws IOException {
        String rootDir = String.valueOf(file.getParent()) + File.separator;
        FileInputStream input = null;
        try {
            input = new FileInputStream(file);
            CMap cMap = this.parse(rootDir, input);
            return cMap;
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }

    public CMap parse(String resourceRoot, InputStream input) throws IOException {
        PushbackInputStream cmapStream = new PushbackInputStream(input);
        CMap result = new CMap();
        Object previousToken = null;
        Object token = null;
        while ((token = this.parseNextToken(cmapStream)) != null) {
            if (token instanceof Operator) {
                byte[] startCode;
                byte[] inputCode;
                Object nextToken;
                Operator op = (Operator)token;
                if (op.op.equals(USECMAP)) {
                    LiteralName useCmapName = (LiteralName)previousToken;
                    InputStream useStream = ResourceLoader.loadResource(String.valueOf(resourceRoot) + useCmapName.name);
                    if (useStream == null) {
                        throw new IOException("Error: Could not find referenced cmap stream " + useCmapName.name);
                    }
                    CMap useCMap = this.parse(resourceRoot, useStream);
                    result.useCmap(useCMap);
                } else if (op.op.equals(BEGIN_CODESPACE_RANGE)) {
                    Number cosCount = (Number)previousToken;
                    int j = 0;
                    while (j < cosCount.intValue()) {
                        nextToken = this.parseNextToken(cmapStream);
                        if (nextToken instanceof Operator) {
                            if (!((Operator)nextToken).op.equals(END_CODESPACE_RANGE)) {
                                throw new IOException("Error : ~codespacerange contains an unexpected operator : " + ((Operator)nextToken).op);
                            }
                            break;
                        }
                        byte[] startRange = (byte[])nextToken;
                        byte[] endRange = (byte[])this.parseNextToken(cmapStream);
                        CodespaceRange range = new CodespaceRange();
                        range.setStart(startRange);
                        range.setEnd(endRange);
                        result.addCodespaceRange(range);
                        ++j;
                    }
                } else if (op.op.equals(BEGIN_BASE_FONT_CHAR)) {
                    Number cosCount = (Number)previousToken;
                    int j = 0;
                    while (j < cosCount.intValue()) {
                        nextToken = this.parseNextToken(cmapStream);
                        if (nextToken instanceof Operator) {
                            if (!((Operator)nextToken).op.equals(END_BASE_FONT_CHAR)) {
                                throw new IOException("Error : ~bfchar contains an unexpected operator : " + ((Operator)nextToken).op);
                            }
                            break;
                        }
                        inputCode = (byte[])nextToken;
                        nextToken = this.parseNextToken(cmapStream);
                        if (nextToken instanceof byte[]) {
                            byte[] bytes = (byte[])nextToken;
                            String value = this.createStringFromBytes(bytes);
                            result.addMapping(inputCode, value);
                        } else if (nextToken instanceof LiteralName) {
                            result.addMapping(inputCode, ((LiteralName)nextToken).name);
                        } else {
                            throw new IOException("Error parsing CMap beginbfchar, expected{COSString or COSName} and not " + nextToken);
                        }
                        ++j;
                    }
                } else if (op.op.equals(BEGIN_BASE_FONT_RANGE)) {
                    Number cosCount = (Number)previousToken;
                    int j = 0;
                    while (j < cosCount.intValue()) {
                        nextToken = this.parseNextToken(cmapStream);
                        if (nextToken instanceof Operator) {
                            if (!((Operator)nextToken).op.equals(END_BASE_FONT_RANGE)) {
                                throw new IOException("Error : ~bfrange contains an unexpected operator : " + ((Operator)nextToken).op);
                            }
                            break;
                        }
                        startCode = (byte[])nextToken;
                        byte[] endCode = (byte[])this.parseNextToken(cmapStream);
                        nextToken = this.parseNextToken(cmapStream);
                        List array = null;
                        byte[] tokenBytes = null;
                        if (nextToken instanceof List) {
                            array = (List)nextToken;
                            tokenBytes = (byte[])array.get(0);
                        } else {
                            tokenBytes = (byte[])nextToken;
                        }
                        boolean done = false;
                        if (Arrays.equals(startCode, tokenBytes)) {
                            done = true;
                        }
                        String value = null;
                        int arrayIndex = 0;
                        while (!done) {
                            if (this.compare(startCode, endCode) >= 0) {
                                done = true;
                            }
                            value = this.createStringFromBytes(tokenBytes);
                            result.addMapping(startCode, value);
                            this.increment(startCode);
                            if (array == null) {
                                this.increment(tokenBytes);
                                continue;
                            }
                            if (++arrayIndex >= array.size()) continue;
                            tokenBytes = (byte[])array.get(arrayIndex);
                        }
                        ++j;
                    }
                } else if (op.op.equals(BEGIN_CID_CHAR)) {
                    Number cosCount = (Number)previousToken;
                    int j = 0;
                    while (j < cosCount.intValue()) {
                        nextToken = this.parseNextToken(cmapStream);
                        if (nextToken instanceof Operator) {
                            if (!((Operator)nextToken).op.equals(END_CID_CHAR)) {
                                throw new IOException("Error : ~cidchar contains an unexpected operator : " + ((Operator)nextToken).op);
                            }
                            break;
                        }
                        inputCode = (byte[])nextToken;
                        int mappedCode = (Integer)this.parseNextToken(cmapStream);
                        String mappedStr = this.createStringFromBytes(inputCode);
                        result.addCIDMapping(mappedCode, mappedStr);
                        ++j;
                    }
                } else if (op.op.equals(BEGIN_CID_RANGE)) {
                    int numberOfLines = (Integer)previousToken;
                    int n = 0;
                    while (n < numberOfLines) {
                        nextToken = this.parseNextToken(cmapStream);
                        if (nextToken instanceof Operator) {
                            if (!((Operator)nextToken).op.equals(END_CID_RANGE)) {
                                throw new IOException("Error : ~cidrange contains an unexpected operator : " + ((Operator)nextToken).op);
                            }
                            break;
                        }
                        startCode = (byte[])nextToken;
                        int start = this.createIntFromBytes(startCode);
                        byte[] endCode = (byte[])this.parseNextToken(cmapStream);
                        int end = this.createIntFromBytes(endCode);
                        int mappedCode = (Integer)this.parseNextToken(cmapStream);
                        if (startCode.length <= 2 && endCode.length <= 2) {
                            result.addCIDRange((char)start, (char)end, mappedCode);
                        } else {
                            int endOfMappings = mappedCode + end - start;
                            while (mappedCode <= endOfMappings) {
                                String mappedStr = this.createStringFromBytes(startCode);
                                result.addCIDMapping(mappedCode++, mappedStr);
                                this.increment(startCode);
                            }
                        }
                        ++n;
                    }
                }
            } else if (token instanceof LiteralName) {
                Object next;
                LiteralName literal = (LiteralName)token;
                if (WMODE.equals(literal.name)) {
                    Object next2 = this.parseNextToken(cmapStream);
                    if (next2 instanceof Integer) {
                        result.setWMode((Integer)next2);
                    }
                } else if (CMAP_NAME.equals(literal.name)) {
                    Object next3 = this.parseNextToken(cmapStream);
                    if (next3 instanceof LiteralName) {
                        result.setName(((LiteralName)next3).name);
                    }
                } else if (CMAP_VERSION.equals(literal.name)) {
                    Object next4 = this.parseNextToken(cmapStream);
                    if (next4 instanceof Number) {
                        result.setVersion(((Number)next4).toString());
                    } else if (next4 instanceof String) {
                        result.setVersion((String)next4);
                    }
                } else if (CMAP_TYPE.equals(literal.name)) {
                    Object next5 = this.parseNextToken(cmapStream);
                    if (next5 instanceof Integer) {
                        result.setType((Integer)next5);
                    }
                } else if (REGISTRY.equals(literal.name)) {
                    Object next6 = this.parseNextToken(cmapStream);
                    if (next6 instanceof String) {
                        result.setRegistry((String)next6);
                    }
                } else if (ORDERING.equals(literal.name)) {
                    Object next7 = this.parseNextToken(cmapStream);
                    if (next7 instanceof String) {
                        result.setOrdering((String)next7);
                    }
                } else if (SUPPLEMENT.equals(literal.name) && (next = this.parseNextToken(cmapStream)) instanceof Integer) {
                    result.setSupplement((Integer)next);
                }
            }
            previousToken = token;
        }
        return result;
    }

    private Object parseNextToken(PushbackInputStream is) throws IOException {
        Object retval = null;
        int nextByte = is.read();
        while (nextByte == 9 || nextByte == 32 || nextByte == 13 || nextByte == 10 || nextByte == 0) {
            nextByte = is.read();
        }
        switch (nextByte) {
            case 37: {
                StringBuffer buffer = new StringBuffer();
                buffer.append((char)nextByte);
                this.readUntilEndOfLine(is, buffer);
                retval = buffer.toString();
                break;
            }
            case 40: {
                StringBuffer buffer = new StringBuffer();
                int stringByte = is.read();
                while (stringByte != -1 && stringByte != 41) {
                    buffer.append((char)stringByte);
                    stringByte = is.read();
                }
                retval = buffer.toString();
                break;
            }
            case 62: {
                int secondCloseBrace = is.read();
                if (secondCloseBrace == 62) {
                    retval = MARK_END_OF_DICTIONARY;
                    break;
                }
                throw new IOException("Error: expected the end of a dictionary.");
            }
            case 93: {
                retval = MARK_END_OF_ARRAY;
                break;
            }
            case 91: {
                ArrayList<Object> list = new ArrayList<Object>();
                Object nextToken = this.parseNextToken(is);
                while (nextToken != null && nextToken != MARK_END_OF_ARRAY) {
                    list.add(nextToken);
                    nextToken = this.parseNextToken(is);
                }
                retval = list;
                break;
            }
            case 60: {
                int theNextByte = is.read();
                if (theNextByte == 60) {
                    HashMap<String, Object> result = new HashMap<String, Object>();
                    Object key = this.parseNextToken(is);
                    while (key instanceof LiteralName && key != MARK_END_OF_DICTIONARY) {
                        Object value = this.parseNextToken(is);
                        result.put(((LiteralName)key).name, value);
                        key = this.parseNextToken(is);
                    }
                    retval = result;
                    break;
                }
                int multiplyer = 16;
                int bufferIndex = -1;
                while (theNextByte != -1 && theNextByte != 62) {
                    int intValue = 0;
                    if (theNextByte >= 48 && theNextByte <= 57) {
                        intValue = theNextByte - 48;
                    } else if (theNextByte >= 65 && theNextByte <= 70) {
                        intValue = 10 + theNextByte - 65;
                    } else if (theNextByte >= 97 && theNextByte <= 102) {
                        intValue = 10 + theNextByte - 97;
                    } else {
                        if (theNextByte == 32) {
                            theNextByte = is.read();
                            continue;
                        }
                        throw new IOException("Error: expected hex character and not " + (char)theNextByte + ":" + theNextByte);
                    }
                    intValue *= multiplyer;
                    if (multiplyer == 16) {
                        this.tokenParserByteBuffer[++bufferIndex] = 0;
                        multiplyer = 1;
                    } else {
                        multiplyer = 16;
                    }
                    int n = bufferIndex;
                    this.tokenParserByteBuffer[n] = (byte)(this.tokenParserByteBuffer[n] + intValue);
                    theNextByte = is.read();
                }
                byte[] finalResult = new byte[bufferIndex + 1];
                System.arraycopy(this.tokenParserByteBuffer, 0, finalResult, 0, bufferIndex + 1);
                retval = finalResult;
                break;
            }
            case 47: {
                StringBuffer buffer = new StringBuffer();
                int stringByte = is.read();
                while (!this.isWhitespaceOrEOF(stringByte)) {
                    buffer.append((char)stringByte);
                    stringByte = is.read();
                }
                retval = new LiteralName(buffer.toString());
                break;
            }
            case -1: {
                break;
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                StringBuffer buffer = new StringBuffer();
                buffer.append((char)nextByte);
                nextByte = is.read();
                while (!this.isWhitespaceOrEOF(nextByte) && (Character.isDigit((char)nextByte) || nextByte == 46)) {
                    buffer.append((char)nextByte);
                    nextByte = is.read();
                }
                is.unread(nextByte);
                String value = buffer.toString();
                if (value.indexOf(46) >= 0) {
                    retval = new Double(value);
                    break;
                }
                retval = new Integer(value);
                break;
            }
            default: {
                StringBuffer buffer = new StringBuffer();
                buffer.append((char)nextByte);
                nextByte = is.read();
                while (!this.isWhitespaceOrEOF(nextByte)) {
                    buffer.append((char)nextByte);
                    nextByte = is.read();
                }
                retval = new Operator(buffer.toString());
            }
        }
        return retval;
    }

    private void readUntilEndOfLine(InputStream is, StringBuffer buf) throws IOException {
        int nextByte = is.read();
        while (nextByte != -1 && nextByte != 13 && nextByte != 10) {
            buf.append((char)nextByte);
            nextByte = is.read();
        }
    }

    private boolean isWhitespaceOrEOF(int aByte) {
        return aByte == -1 || aByte == 32 || aByte == 13 || aByte == 10;
    }

    private void increment(byte[] data) {
        this.increment(data, data.length - 1);
    }

    private void increment(byte[] data, int position) {
        if (position > 0 && (data[position] + 256) % 256 == 255) {
            data[position] = 0;
            this.increment(data, position - 1);
        } else {
            data[position] = (byte)(data[position] + 1);
        }
    }

    private int createIntFromBytes(byte[] bytes) {
        int intValue = (bytes[0] + 256) % 256;
        if (bytes.length == 2) {
            intValue <<= 8;
            intValue += (bytes[1] + 256) % 256;
        }
        return intValue;
    }

    private String createStringFromBytes(byte[] bytes) throws IOException {
        String retval = null;
        retval = bytes.length == 1 ? new String(bytes, "ISO-8859-1") : new String(bytes, "UTF-16BE");
        return retval;
    }

    private int compare(byte[] first, byte[] second) {
        int retval = 1;
        int firstLength = first.length;
        int i = 0;
        while (i < firstLength) {
            if (first[i] != second[i]) {
                if ((first[i] + 256) % 256 < (second[i] + 256) % 256) {
                    retval = -1;
                    break;
                }
                retval = 1;
                break;
            }
            ++i;
        }
        return retval;
    }

    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("usage: java org.apache.fontbox.cmap.CMapParser <CMAP File>");
            System.exit(-1);
        }
        CMapParser parser = new CMapParser();
        File cmapFile = new File(args[0]);
        CMap result = parser.parse(cmapFile);
        System.out.println("Result:" + result);
    }

    private class LiteralName {
        private String name;

        private LiteralName(String theName) {
            this.name = theName;
        }
    }

    private class Operator {
        private String op;

        private Operator(String theOp) {
            this.op = theOp;
        }
    }
}

