/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.font.cff.encoding;

import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CFFEncoding {
    private List<Entry> entries = new ArrayList<Entry>();

    public boolean isFontSpecific() {
        return false;
    }

    public int getCode(int sid) {
        for (Entry entry : this.entries) {
            if (entry.entrySID != sid) continue;
            return entry.entryCode;
        }
        return -1;
    }

    public int getSID(int code) {
        for (Entry entry : this.entries) {
            if (entry.entryCode != code) continue;
            return entry.entrySID;
        }
        return -1;
    }

    public void register(int code, int sid) {
        this.entries.add(new Entry(code, sid));
    }

    public void addEntry(Entry entry) {
        this.entries.add(entry);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public static class Entry {
        private int entryCode;
        private int entrySID;

        protected Entry(int code, int sid) {
            this.entryCode = code;
            this.entrySID = sid;
        }

        public int getCode() {
            return this.entryCode;
        }

        public int getSID() {
            return this.entrySID;
        }

        public String toString() {
            return "[code=" + this.entryCode + ", sid=" + this.entrySID + "]";
        }
    }
}

