/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.font.cff;

public class Type1FontUtil {
    private Type1FontUtil() {
    }

    public static String hexEncode(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < bytes.length) {
            String string = Integer.toHexString(bytes[i] & 0xFF);
            if (string.length() == 1) {
                sb.append("0");
            }
            sb.append(string.toUpperCase());
            ++i;
        }
        return sb.toString();
    }

    public static byte[] hexDecode(String string) {
        if (string.length() % 2 != 0) {
            throw new IllegalArgumentException();
        }
        byte[] bytes = new byte[string.length() / 2];
        int i = 0;
        while (i < string.length()) {
            bytes[i / 2] = (byte)Integer.parseInt(string.substring(i, i + 2), 16);
            i += 2;
        }
        return bytes;
    }

    public static byte[] eexecEncrypt(byte[] buffer) {
        return Type1FontUtil.encrypt(buffer, 55665, 4);
    }

    public static byte[] charstringEncrypt(byte[] buffer, int n) {
        return Type1FontUtil.encrypt(buffer, 4330, n);
    }

    private static byte[] encrypt(byte[] plaintextBytes, int r, int n) {
        byte[] buffer = new byte[plaintextBytes.length + n];
        int i = 0;
        while (i < n) {
            buffer[i] = 0;
            ++i;
        }
        System.arraycopy(plaintextBytes, 0, buffer, n, buffer.length - n);
        int c1 = 52845;
        int c2 = 22719;
        byte[] ciphertextBytes = new byte[buffer.length];
        int i2 = 0;
        while (i2 < buffer.length) {
            int plain = buffer[i2] & 0xFF;
            int cipher = plain ^ r >> 8;
            ciphertextBytes[i2] = (byte)cipher;
            r = (cipher + r) * c1 + c2 & 0xFFFF;
            ++i2;
        }
        return ciphertextBytes;
    }

    public static byte[] eexecDecrypt(byte[] buffer) {
        return Type1FontUtil.decrypt(buffer, 55665, 4);
    }

    public static byte[] charstringDecrypt(byte[] buffer, int n) {
        return Type1FontUtil.decrypt(buffer, 4330, n);
    }

    private static byte[] decrypt(byte[] ciphertextBytes, int r, int n) {
        byte[] buffer = new byte[ciphertextBytes.length];
        int c1 = 52845;
        int c2 = 22719;
        int i = 0;
        while (i < ciphertextBytes.length) {
            int cipher = ciphertextBytes[i] & 0xFF;
            int plain = cipher ^ r >> 8;
            buffer[i] = (byte)plain;
            r = (cipher + r) * c1 + c2 & 0xFFFF;
            ++i;
        }
        byte[] plaintextBytes = new byte[ciphertextBytes.length - n];
        System.arraycopy(buffer, n, plaintextBytes, 0, plaintextBytes.length);
        return plaintextBytes;
    }
}

