/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.font.cff;

import com.plpdf.font.cff.CharStringCommand;
import com.plpdf.font.cff.CharStringHandler;
import com.plpdf.font.cff.IndexData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CharStringConverter
extends CharStringHandler {
    private int defaultWidthX = 0;
    private int nominalWidthX = 0;
    private List<Object> sequence = null;
    private int pathCount = 0;

    public CharStringConverter(int defaultWidth, int nominalWidth, IndexData fontGlobalSubrIndex, IndexData fontLocalSubrIndex) {
        this.defaultWidthX = defaultWidth;
        this.nominalWidthX = nominalWidth;
    }

    public CharStringConverter(int defaultWidth, int nominalWidth) {
        this.defaultWidthX = defaultWidth;
        this.nominalWidthX = nominalWidth;
    }

    public List<Object> convert(List<Object> commandSequence) {
        this.sequence = new ArrayList<Object>();
        this.pathCount = 0;
        this.handleSequence(commandSequence);
        return this.sequence;
    }

    @Override
    public List<Integer> handleCommand(List<Integer> numbers, CharStringCommand command) {
        if (CharStringCommand.TYPE1_VOCABULARY.containsKey(command.getKey())) {
            return this.handleType1Command(numbers, command);
        }
        return this.handleType2Command(numbers, command);
    }

    private List<Integer> handleType1Command(List<Integer> numbers, CharStringCommand command) {
        String name = CharStringCommand.TYPE1_VOCABULARY.get(command.getKey());
        if ("hstem".equals(name)) {
            numbers = this.clearStack(numbers, numbers.size() % 2 != 0);
            this.expandStemHints(numbers, true);
        } else if ("vstem".equals(name)) {
            numbers = this.clearStack(numbers, numbers.size() % 2 != 0);
            this.expandStemHints(numbers, false);
        } else if ("vmoveto".equals(name)) {
            numbers = this.clearStack(numbers, numbers.size() > 1);
            this.markPath();
            this.addCommand(numbers, command);
        } else if ("rlineto".equals(name)) {
            this.addCommandList(CharStringConverter.split(numbers, 2), command);
        } else if ("hlineto".equals(name)) {
            this.drawAlternatingLine(numbers, true);
        } else if ("vlineto".equals(name)) {
            this.drawAlternatingLine(numbers, false);
        } else if ("rrcurveto".equals(name)) {
            this.addCommandList(CharStringConverter.split(numbers, 6), command);
        } else if ("endchar".equals(name)) {
            numbers = this.clearStack(numbers, numbers.size() > 0);
            this.closePath();
            this.addCommand(numbers, command);
        } else if ("rmoveto".equals(name)) {
            numbers = this.clearStack(numbers, numbers.size() > 2);
            this.markPath();
            this.addCommand(numbers, command);
        } else if ("hmoveto".equals(name)) {
            numbers = this.clearStack(numbers, numbers.size() > 1);
            this.markPath();
            this.addCommand(numbers, command);
        } else if ("vhcurveto".equals(name)) {
            this.drawAlternatingCurve(numbers, false);
        } else if ("hvcurveto".equals(name)) {
            this.drawAlternatingCurve(numbers, true);
        } else {
            if ("return".equals(name)) {
                return numbers;
            }
            this.addCommand(numbers, command);
        }
        return null;
    }

    private List<Integer> handleType2Command(List<Integer> numbers, CharStringCommand command) {
        String name = CharStringCommand.TYPE2_VOCABULARY.get(command.getKey());
        if ("hflex".equals(name)) {
            List<Integer> first = Arrays.asList(numbers.get(0), 0, numbers.get(1), numbers.get(2), numbers.get(3), 0);
            List<Integer> second = Arrays.asList(numbers.get(4), 0, numbers.get(5), -numbers.get(2).intValue(), numbers.get(6), 0);
            this.addCommandList(Arrays.asList(first, second), new CharStringCommand(8));
        } else if ("flex".equals(name)) {
            List<Integer> first = numbers.subList(0, 6);
            List<Integer> second = numbers.subList(6, 12);
            this.addCommandList(Arrays.asList(first, second), new CharStringCommand(8));
        } else if ("hflex1".equals(name)) {
            List<Integer> first = Arrays.asList(numbers.get(0), numbers.get(1), numbers.get(2), numbers.get(3), numbers.get(4), 0);
            List<Integer> second = Arrays.asList(numbers.get(5), 0, numbers.get(6), numbers.get(7), numbers.get(8), 0);
            this.addCommandList(Arrays.asList(first, second), new CharStringCommand(8));
        } else if ("flex1".equals(name)) {
            int dx = 0;
            int dy = 0;
            int i = 0;
            while (i < 5) {
                dx += numbers.get(i * 2).intValue();
                dy += numbers.get(i * 2 + 1).intValue();
                ++i;
            }
            List<Integer> first = numbers.subList(0, 6);
            List<Integer> second = Arrays.asList(numbers.get(6), numbers.get(7), numbers.get(8), numbers.get(9), Math.abs(dx) > Math.abs(dy) ? numbers.get(10) : Integer.valueOf(-dx), Math.abs(dx) > Math.abs(dy) ? Integer.valueOf(-dy) : numbers.get(10));
            this.addCommandList(Arrays.asList(first, second), new CharStringCommand(8));
        } else if ("hstemhm".equals(name)) {
            numbers = this.clearStack(numbers, numbers.size() % 2 != 0);
            this.expandStemHints(numbers, true);
        } else if ("hintmask".equals(name) || "cntrmask".equals(name)) {
            if ((numbers = this.clearStack(numbers, numbers.size() % 2 != 0)).size() > 0) {
                this.expandStemHints(numbers, false);
            }
        } else if ("vstemhm".equals(name)) {
            numbers = this.clearStack(numbers, numbers.size() % 2 != 0);
            this.expandStemHints(numbers, false);
        } else if ("rcurveline".equals(name)) {
            this.addCommandList(CharStringConverter.split(numbers.subList(0, numbers.size() - 2), 6), new CharStringCommand(8));
            this.addCommand(numbers.subList(numbers.size() - 2, numbers.size()), new CharStringCommand(5));
        } else if ("rlinecurve".equals(name)) {
            this.addCommandList(CharStringConverter.split(numbers.subList(0, numbers.size() - 6), 2), new CharStringCommand(5));
            this.addCommand(numbers.subList(numbers.size() - 6, numbers.size()), new CharStringCommand(8));
        } else if ("vvcurveto".equals(name)) {
            this.drawCurve(numbers, false);
        } else if ("hhcurveto".equals(name)) {
            this.drawCurve(numbers, true);
        } else {
            this.addCommand(numbers, command);
        }
        return null;
    }

    private List<Integer> clearStack(List<Integer> numbers, boolean flag) {
        if (this.sequence.size() == 0) {
            if (flag) {
                this.addCommand(Arrays.asList(0, numbers.get(0) + this.nominalWidthX), new CharStringCommand(13));
                numbers = numbers.subList(1, numbers.size());
            } else {
                this.addCommand(Arrays.asList(0, this.defaultWidthX), new CharStringCommand(13));
            }
        }
        return numbers;
    }

    private void expandStemHints(List<Integer> numbers, boolean horizontal) {
    }

    private void markPath() {
        if (this.pathCount > 0) {
            this.closePath();
        }
        ++this.pathCount;
    }

    private void closePath() {
        CharStringCommand command = this.pathCount > 0 ? (CharStringCommand)this.sequence.get(this.sequence.size() - 1) : null;
        CharStringCommand closepathCommand = new CharStringCommand(9);
        if (command != null && !closepathCommand.equals(command)) {
            this.addCommand(Collections.<Integer>emptyList(), closepathCommand);
        }
    }

    private void drawAlternatingLine(List<Integer> numbers, boolean horizontal) {
        while (numbers.size() > 0) {
            this.addCommand(numbers.subList(0, 1), new CharStringCommand(horizontal ? 6 : 7));
            numbers = numbers.subList(1, numbers.size());
            boolean bl = horizontal = !horizontal;
        }
    }

    private void drawAlternatingCurve(List<Integer> numbers, boolean horizontal) {
        while (numbers.size() > 0) {
            boolean last;
            boolean bl = last = numbers.size() == 5;
            if (horizontal) {
                this.addCommand(Arrays.asList(numbers.get(0), 0, numbers.get(1), numbers.get(2), last ? numbers.get(4) : Integer.valueOf(0), numbers.get(3)), new CharStringCommand(8));
            } else {
                this.addCommand(Arrays.asList(0, numbers.get(0), numbers.get(1), numbers.get(2), numbers.get(3), last ? numbers.get(4) : Integer.valueOf(0)), new CharStringCommand(8));
            }
            numbers = numbers.subList(last ? 5 : 4, numbers.size());
            boolean bl2 = horizontal = !horizontal;
        }
    }

    private void drawCurve(List<Integer> numbers, boolean horizontal) {
        while (numbers.size() > 0) {
            boolean first;
            boolean bl = first = numbers.size() % 4 == 1;
            if (horizontal) {
                this.addCommand(Arrays.asList(numbers.get(first ? 1 : 0), first ? numbers.get(0) : Integer.valueOf(0), numbers.get(first ? 2 : 1), numbers.get(first ? 3 : 2), numbers.get(first ? 4 : 3), 0), new CharStringCommand(8));
            } else {
                this.addCommand(Arrays.asList(first ? numbers.get(0) : Integer.valueOf(0), numbers.get(first ? 1 : 0), numbers.get(first ? 2 : 1), numbers.get(first ? 3 : 2), 0, numbers.get(first ? 4 : 3)), new CharStringCommand(8));
            }
            numbers = numbers.subList(first ? 5 : 4, numbers.size());
        }
    }

    private void addCommandList(List<List<Integer>> numbers, CharStringCommand command) {
        int i = 0;
        while (i < numbers.size()) {
            this.addCommand(numbers.get(i), command);
            ++i;
        }
    }

    private void addCommand(List<Integer> numbers, CharStringCommand command) {
        this.sequence.addAll(numbers);
        this.sequence.add(command);
    }

    private static <E> List<List<E>> split(List<E> list, int size) {
        ArrayList<List<List<E>>> result = new ArrayList<List<List<E>>>();
        int i = 0;
        while (i < list.size() / size) {
            result.add(list.subList(i * size, (i + 1) * size));
            ++i;
        }
        return result;
    }
}

