/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.filter;

import com.plpdf.filter.Filter;
import com.plpdf.om.OMDictionary;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class RunLengthDecodeFilter
implements Filter {
    private static final int RUN_LENGTH_EOD = 128;

    public void decode(InputStream compressedData, OutputStream result, OMDictionary options, int filterIndex) throws IOException {
        int dupAmount = -1;
        byte[] buffer = new byte[128];
        while ((dupAmount = compressedData.read()) != -1 && dupAmount != 128) {
            if (dupAmount <= 127) {
                int amountToCopy = dupAmount + 1;
                int compressedRead = 0;
                while (amountToCopy > 0) {
                    compressedRead = compressedData.read(buffer, 0, amountToCopy);
                    result.write(buffer, 0, compressedRead);
                    amountToCopy -= compressedRead;
                }
                continue;
            }
            int dupByte = compressedData.read();
            int i = 0;
            while (i < 257 - dupAmount) {
                result.write(dupByte);
                ++i;
            }
        }
    }

    public void encode(InputStream rawData, OutputStream result, OMDictionary options, int filterIndex) throws IOException {
    }
}

