/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.filter;

import com.plpdf.filter.Filter;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import com.plpdf.smmodel.common.OMObjectable;
import com.plpdf.smmodel.graphics.color.SMColorSpaceFactory;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.imageio.ImageIO;

public class JPXFilter
implements Filter {
    public void decode(InputStream compressedData, OutputStream result, OMDictionary options, int filterIndex) throws IOException {
        DataBuffer dBuf;
        BufferedImage bi = ImageIO.read(compressedData);
        if (bi != null && (dBuf = bi.getData().getDataBuffer()).getDataType() == 0) {
            ColorModel colorModel = bi.getColorModel();
            if (options.getItem(OMName.COLORSPACE) == null) {
                options.setItem(OMName.COLORSPACE, (OMObjectable)SMColorSpaceFactory.createColorSpace(null, colorModel.getColorSpace()));
            }
            options.setInt(OMName.BITS_PER_COMPONENT, colorModel.getPixelSize() / colorModel.getNumComponents());
            options.setInt(OMName.HEIGHT, bi.getHeight());
            options.setInt(OMName.WIDTH, bi.getWidth());
            result.write(((DataBufferByte)dBuf).getData());
        }
    }

    public void encode(InputStream rawData, OutputStream result, OMDictionary options, int filterIndex) throws IOException {
    }
}

