/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.filter;

import com.plpdf.filter.Filter;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMInteger;
import com.plpdf.om.OMName;
import com.plpdf.om.OMStream;
import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;

public class JBIG2Filter
implements Filter {
    public void decode(InputStream compressedData, OutputStream result, OMDictionary options, int filterIndex) throws IOException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName("JBIG2");
        if (!readers.hasNext()) {
            return;
        }
        ImageReader reader = readers.next();
        OMDictionary decodeP = (OMDictionary)options.getDictionaryObject(OMName.DECODE_PARMS);
        OMInteger bits = (OMInteger)options.getDictionaryObject(OMName.BITS_PER_COMPONENT);
        OMStream st = null;
        if (decodeP != null) {
            st = (OMStream)decodeP.getDictionaryObject(OMName.JBIG2_GLOBALS);
        }
        if (st != null) {
            reader.setInput(ImageIO.createImageInputStream(new SequenceInputStream(st.getFilteredStream(), compressedData)));
        } else {
            reader.setInput(ImageIO.createImageInputStream(compressedData));
        }
        BufferedImage bi = reader.read(0);
        reader.dispose();
        if (bi != null) {
            DataBuffer dBuf;
            if (bi.getColorModel().getPixelSize() != bits.intValue()) {
                if (bits.intValue() != 1) {
                    return;
                }
                BufferedImage packedImage = new BufferedImage(bi.getWidth(), bi.getHeight(), 12);
                packedImage.getGraphics().drawImage(bi, 0, 0, null);
                bi = packedImage;
            }
            if ((dBuf = bi.getData().getDataBuffer()).getDataType() == 0) {
                result.write(((DataBufferByte)dBuf).getData());
            }
        }
    }

    public void encode(InputStream rawData, OutputStream result, OMDictionary options, int filterIndex) throws IOException {
        System.err.println("Warning: JBIG2.encode is not implemented yet, skipping this stream.");
    }
}

