/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.filter;

import com.plpdf.filter.Filter;
import com.plpdf.om.OMArray;
import com.plpdf.om.OMBase;
import com.plpdf.om.OMDictionary;
import com.plpdf.om.OMName;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;

public class FlateFilter
implements Filter {
    private static final int BUFFER_SIZE = 16384;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        int j = 0;
        while (j < bytes.length) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
            ++j;
        }
        return new String(hexChars);
    }

    public void decode(InputStream compressedData, OutputStream result, OMDictionary options, int filterIndex) throws IOException {
        OMBase baseObj = options.getDictionaryObject(OMName.DECODE_PARMS, OMName.DP);
        OMDictionary dict = null;
        if (baseObj instanceof OMDictionary) {
            dict = (OMDictionary)baseObj;
        } else if (baseObj instanceof OMArray) {
            OMArray paramArray = (OMArray)baseObj;
            if (filterIndex < paramArray.size()) {
                dict = (OMDictionary)paramArray.getObject(filterIndex);
            }
        } else if (baseObj != null) {
            throw new IOException("Error: Expected OMArray or OMDictionary and not " + baseObj.getClass().getName());
        }
        int predictor = -1;
        int colors = -1;
        int bitsPerPixel = -1;
        int columns = -1;
        ByteArrayInputStream bais = null;
        ByteArrayOutputStream baos = null;
        if (dict != null && (predictor = dict.getInt(OMName.PREDICTOR)) > 1) {
            colors = dict.getInt(OMName.COLORS);
            bitsPerPixel = dict.getInt(OMName.BITS_PER_COMPONENT);
            columns = dict.getInt(OMName.COLUMNS);
        }
        try {
            try {
                baos = this.decompress(compressedData);
                if (predictor == -1 || predictor == 1) {
                    result.write(baos.toByteArray());
                } else {
                    if (colors == -1) {
                        colors = 1;
                    }
                    if (bitsPerPixel == -1) {
                        bitsPerPixel = 8;
                    }
                    if (columns == -1) {
                        columns = 1;
                    }
                    bais = new ByteArrayInputStream(baos.toByteArray());
                    byte[] decodedData = this.decodePredictor(predictor, colors, bitsPerPixel, columns, bais);
                    bais.close();
                    bais = null;
                    result.write(decodedData);
                }
                result.flush();
            }
            catch (DataFormatException exception) {
                IOException io = new IOException();
                io.initCause(exception);
                throw io;
            }
        }
        finally {
            if (bais != null) {
                bais.close();
            }
            if (baos != null) {
                baos.close();
            }
        }
    }

    private ByteArrayOutputStream decompress(InputStream in) throws IOException, DataFormatException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        byte[] buf = new byte[2048];
        int read = in.read(buf);
        if (read > 0) {
            Inflater inflater = new Inflater();
            inflater.setInput(buf, 0, read);
            byte[] res = new byte[2048];
            while (true) {
                int resRead;
                if ((resRead = inflater.inflate(res)) != 0) {
                    out.write(res, 0, resRead);
                    continue;
                }
                if (inflater.finished() || inflater.needsDictionary() || in.available() == 0) break;
                read = in.read(buf);
                inflater.setInput(buf, 0, read);
            }
        }
        out.close();
        return out;
    }

    private byte[] decodePredictor(int predictor, int colors, int bitsPerComponent, int columns, InputStream data) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] buffer = new byte[2048];
        if (predictor == 1) {
            int i = 0;
            while ((i = data.read(buffer)) != -1) {
                baos.write(buffer, 0, i);
            }
        } else {
            int bitsPerPixel = colors * bitsPerComponent;
            int bytesPerPixel = (bitsPerPixel + 7) / 8;
            int rowlength = (columns * bitsPerPixel + 7) / 8;
            byte[] actline = new byte[rowlength];
            byte[] lastline = new byte[rowlength];
            boolean done = false;
            int linepredictor = predictor;
            while (!done && data.available() > 0) {
                if (predictor >= 10) {
                    linepredictor = data.read();
                    if (linepredictor == -1) {
                        done = true;
                        break;
                    }
                    linepredictor += 10;
                }
                int i = 0;
                int offset = 0;
                while (offset < rowlength && (i = data.read(actline, offset, rowlength - offset)) != -1) {
                    offset += i;
                }
                switch (linepredictor) {
                    case 2: {
                        int left;
                        int sub;
                        if (bitsPerComponent != 8) {
                            throw new IOException("TIFF-Predictor with " + bitsPerComponent + " bits per component not supported");
                        }
                        int p = 0;
                        while (p < rowlength) {
                            sub = actline[p] & 0xFF;
                            left = p - bytesPerPixel >= 0 ? actline[p - bytesPerPixel] & 0xFF : 0;
                            actline[p] = (byte)(sub + left);
                            ++p;
                        }
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        int left;
                        int sub;
                        int p = 0;
                        while (p < rowlength) {
                            sub = actline[p];
                            left = p - bytesPerPixel >= 0 ? actline[p - bytesPerPixel] : 0;
                            actline[p] = (byte)(sub + left);
                            ++p;
                        }
                        break;
                    }
                    case 12: {
                        int p = 0;
                        while (p < rowlength) {
                            int up = actline[p] & 0xFF;
                            int prior = lastline[p] & 0xFF;
                            actline[p] = (byte)(up + prior & 0xFF);
                            ++p;
                        }
                        break;
                    }
                    case 13: {
                        int left;
                        int p = 0;
                        while (p < rowlength) {
                            int avg = actline[p] & 0xFF;
                            left = p - bytesPerPixel >= 0 ? actline[p - bytesPerPixel] & 0xFF : 0;
                            int up = lastline[p] & 0xFF;
                            actline[p] = (byte)(avg + (int)Math.floor((left + up) / 2) & 0xFF);
                            ++p;
                        }
                        break;
                    }
                    case 14: {
                        int p = 0;
                        while (p < rowlength) {
                            int paeth = actline[p] & 0xFF;
                            int a = p - bytesPerPixel >= 0 ? actline[p - bytesPerPixel] & 0xFF : 0;
                            int b = lastline[p] & 0xFF;
                            int c = p - bytesPerPixel >= 0 ? lastline[p - bytesPerPixel] & 0xFF : 0;
                            int value = a + b - c;
                            int absa = Math.abs(value - a);
                            int absb = Math.abs(value - b);
                            int absc = Math.abs(value - c);
                            actline[p] = absa <= absb && absa <= absc ? (byte)(paeth + a & 0xFF) : (absb <= absc ? (byte)(paeth + b & 0xFF) : (byte)(paeth + c & 0xFF));
                            ++p;
                        }
                        break;
                    }
                }
                lastline = (byte[])actline.clone();
                baos.write(actline, 0, actline.length);
            }
        }
        return baos.toByteArray();
    }

    public void encode(InputStream rawData, OutputStream result, OMDictionary options, int filterIndex) throws IOException {
        DeflaterOutputStream out = new DeflaterOutputStream(result);
        int amountRead = 0;
        int mayRead = rawData.available();
        if (mayRead > 0) {
            byte[] buffer = new byte[Math.min(mayRead, 16384)];
            while ((amountRead = rawData.read(buffer, 0, Math.min(mayRead, 16384))) != -1) {
                out.write(buffer, 0, amountRead);
            }
        }
        out.close();
        result.flush();
    }
}

