/*
 * Decompiled with CFR 0.152.
 */
package com.plpdf.filter;

import com.plpdf.filter.ASCII85Filter;
import com.plpdf.filter.ASCIIHexFilter;
import com.plpdf.filter.CCITTFaxDecodeFilter;
import com.plpdf.filter.CryptFilter;
import com.plpdf.filter.DCTFilter;
import com.plpdf.filter.Filter;
import com.plpdf.filter.FlateFilter;
import com.plpdf.filter.JBIG2Filter;
import com.plpdf.filter.JPXFilter;
import com.plpdf.filter.LZWFilter;
import com.plpdf.filter.RunLengthDecodeFilter;
import com.plpdf.om.OMName;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterManager {
    private Map<OMName, Filter> filters = new HashMap<OMName, Filter>();

    public FilterManager() {
        FlateFilter flateFilter = new FlateFilter();
        DCTFilter dctFilter = new DCTFilter();
        CCITTFaxDecodeFilter ccittFaxFilter = new CCITTFaxDecodeFilter();
        LZWFilter lzwFilter = new LZWFilter();
        ASCIIHexFilter asciiHexFilter = new ASCIIHexFilter();
        ASCII85Filter ascii85Filter = new ASCII85Filter();
        RunLengthDecodeFilter runLengthFilter = new RunLengthDecodeFilter();
        CryptFilter cryptFilter = new CryptFilter();
        JPXFilter jpxFilter = new JPXFilter();
        JBIG2Filter jbig2Filter = new JBIG2Filter();
        this.addFilter(OMName.FLATE_DECODE, flateFilter);
        this.addFilter(OMName.FLATE_DECODE_ABBREVIATION, flateFilter);
        this.addFilter(OMName.DCT_DECODE, dctFilter);
        this.addFilter(OMName.DCT_DECODE_ABBREVIATION, dctFilter);
        this.addFilter(OMName.CCITTFAX_DECODE, ccittFaxFilter);
        this.addFilter(OMName.CCITTFAX_DECODE_ABBREVIATION, ccittFaxFilter);
        this.addFilter(OMName.LZW_DECODE, lzwFilter);
        this.addFilter(OMName.LZW_DECODE_ABBREVIATION, lzwFilter);
        this.addFilter(OMName.ASCII_HEX_DECODE, asciiHexFilter);
        this.addFilter(OMName.ASCII_HEX_DECODE_ABBREVIATION, asciiHexFilter);
        this.addFilter(OMName.ASCII85_DECODE, ascii85Filter);
        this.addFilter(OMName.ASCII85_DECODE_ABBREVIATION, ascii85Filter);
        this.addFilter(OMName.RUN_LENGTH_DECODE, runLengthFilter);
        this.addFilter(OMName.RUN_LENGTH_DECODE_ABBREVIATION, runLengthFilter);
        this.addFilter(OMName.CRYPT, cryptFilter);
        this.addFilter(OMName.JPX_DECODE, jpxFilter);
        this.addFilter(OMName.JBIG2_DECODE, jbig2Filter);
    }

    public Collection<Filter> getFilters() {
        return this.filters.values();
    }

    public void addFilter(OMName filterName, Filter filter) {
        this.filters.put(filterName, filter);
    }

    public Filter getFilter(OMName filterName) throws IOException {
        Filter filter = this.filters.get(filterName);
        if (filter == null) {
            throw new IOException("Unknown stream filter:" + filterName);
        }
        return filter;
    }

    public Filter getFilter(String filterName) throws IOException {
        return this.getFilter(OMName.getPDFName(filterName));
    }
}

